
function test_fun() {
    var lastSearchString = '';
    var fontFamilyElement = $("select[name='theme_font_family']");
    $.ajax({
        url: fcom.makeUrl('ThemeColor', 'getGoogleFonts'),
        type: 'post',
        dataType: 'json',
        success: function (data) {
            fontFamilyElement.select2({

                closeOnSelect: true,
                dir: layoutDirection,
                allowClear: true,
                placeholder: fontFamilyElement.attr('placeholder'),
                data: data.fonts,
                multiple: false,
                minimumInputLength: 0,
                theme: "default custom-select2",
                templateResult: function (result) {
                    return result.name;
                },
                templateSelection: function (result) {
                    return result.name || result.text;
                }
            }).on('select2:selecting', function (e) {
                var item = e.params.args.data;
                lastSearchString = $('.select2-search__field').val();
                updateFontWeightOptions(data.variantsArr[item.id]);
                /* loadGoogleFont(item); */
                return;
            }).on('select2:unselecting', function (e) {
                lastSearchString = '';
                $('link[data-font="googleFontCss--js"]').remove();
            });

            setTimeout(() => {
                var defaultFontFamily = fontFamilyElement.data('value');
                if ('undefined' != typeof defaultFontFamily && '' != defaultFontFamily) {
                    fontFamilyElement.val(defaultFontFamily).trigger('change.select2').trigger('select.select2');
                    updateFontWeightOptions(data.variantsArr[defaultFontFamily]);
                    $("#font-weight-js").val($.parseJSON(font_weights)).trigger('change');
                }
            }, 200);
        },
        error: function (xhr, ajaxOptions, thrownError) {
            alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
        }
    });

    $(document).on('select2:open', "select[name='theme_font_family']", function () {
        setTimeout(() => {
            if (lastSearchString) {
                $('.select2-search').find('input').val(lastSearchString).trigger('paste');
            }
            document.getElementById($(".select2-results__options").attr("id")).scrollTop = $(".select2-results__option[aria-selected=true]").outerHeight() * $(".select2-results__option[aria-selected=true]").index() - 100;
        }, 10);
    });

    $('.jscolor').trigger("input");
}

$(document).on('input', '.jscolor', function () {
    if ($(this).hasClass('themeColor--js')) {
        $("[data-jscolorSelector]:not(text)").attr('fill', $(this).val());
    }
    if ($(this).hasClass('themeColorInverse--js')) {
        $("text[data-jscolorSelector]").attr('fill', $(this).val());
    }
});

$(document).on('change', '#font-weight-js', function () {
    setupFontWeight();
});



setupFontWeight = function (){
    var name = $("select[name='theme_font_family']").val();
    var selected_weight = $("#font-weight-js").val();
    $.ajax({
        url: fcom.makeUrl('ThemeColor', 'loadGoogleFont'),
        data: {fIsAjax: 1, name: name, weight: selected_weight},
        dataType: 'json',
        type: 'post',
        success: function (resp) {
            if (null != resp.html) {
                $('link[data-font="googleFontCss--js"]').remove();
                $('head').append(resp.html);
                $('.googleFonts--js').find('text').attr('font-family', name);
                $("input[name='theme_font_family_url']").val($(resp.html).attr('href'));
                $('#font-weight-js').trigger('change');
                
            }
        },
        error: function (xhr, ajaxOptions, thrownError) {
            /* alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText); */
        }
    });
}

setupTheme = function (frm) {
    $('.select2-search__field').attr('name', 'testing');
    if (!$(frm).validate())
        return;
    var data = fcom.frmData(frm);
    fcom.updateWithAjax(fcom.makeUrl('ThemeColor', 'setup'), data, function (t) { });
};

resetToDefault = function () {
    if (!confirm(langLbl.confirmReset)) {
        return;
    }
    fcom.updateWithAjax(fcom.makeUrl('ThemeColor', 'resetToDefault'), '', function (t) {
        location.reload();
    });
};

$(document).on('change', 'input[name=theme_option]', function () {
    $.ajax({
        url: fcom.makeUrl('ThemeColor', 'themeForm'),
        data: {fIsAjax: 1, themeId: this.value},
        type: 'post',
        success: function (resp) {
            $('#theme-form-js').html(resp);
            test_fun();
            jscolor.install();
        },
        error: function (xhr, ajaxOptions, thrownError) {
            alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
        }
    });
});

function updateFontWeightOptions(variants)
{   
    var data = [];
    $.each(variants, function (key, variant) {
        data.push({
            id: variant,
            name: variant,
        });
    });

    $('.dropdown-font-weight-js').html(font_weight_html);
    $("#font-weight-js").html('');
    $("#font-weight-js").select2({
        closeOnSelect: true,
        dir: layoutDirection,
        allowClear: false,
        minimumInputLength: 0,
        multiple: true,
        matcher: function(params, data) {
            // If there are no search terms, return all of the data
            if ($.trim(params.term) === '') { return data; }
    
            // Do not display the item if there is no 'text' property
            if (typeof data.text === 'undefined') { return null; }
    
            // `params.term` is the user's search term
            // `data.id` should be checked against
            // `data.text` should be checked against
            var q = params.term.toLowerCase();
            if (data.text.toLowerCase().indexOf(q) > -1 || data.id.toLowerCase().indexOf(q) > -1) {
                return $.extend({}, data, true);
            }
    
            // Return `null` if the term should not be displayed
            return null;
        },
        placeholder: $("#font-weight-js").attr('placeholder'),
        data: data,
        theme: "default custom-select2",
        templateResult: function (result) {
            return result.name;
        },
        templateSelection: function (result) {
            return result.name || result.text;
        }
    })
    .on('select2:opening select2:closing', function( event ) {
        $(this).parent().find('.select2-search__field').addClass('form-control');
        var $searchfield = $(this).parent().find('.select2-search__field');
        $searchfield.css('height','inherit');
    })
    ;
    
    $("#font-weight-js").on("select2:select select2:unselect", function () {
        updateSelectedOptions();
    });

    $('.dropdown-font-weight-js .select2-selection--multiple').addClass('border-0 form-control');
    // $('.dropdown-font-weight-js .select2-selection__rendered').css('display','none');
     setTimeout(()=>{
         updateSelectedOptions();
     },500);
}

function updateSelectedOptions() {
    let selectedData = $("#font-weight-js").select2('data');
    let displayDiv = $("#selected-options");

    // Clear the existing content
    displayDiv.empty();

    // Display selected items in Select2's choice format
    selectedData.forEach(item => {
        displayDiv.append(`
            <li class="select2-selection__choice" title="${item.name || item.text}">
                <span class="select2-selection__choice__remove" role="presentation">×</span>
                ${item.name || item.text}
            </li>
        `);
    });

    // Attach event to remove selected items
    $(".select2-selection__choice__remove").on("click", function () {
        
        let itemText = $(this).parent().attr('title').trim();
        $("#select2-font-weight-js-results li").each(function() {
          
            if ($(this).text().trim() == itemText) {
                $(this).attr('aria-selected', 'false');
            }
        });
        // $("#font-weight-js").find("option").each(function () {
        //     if ($(this).text() === itemText) {
        //         $(this).prop("selected", false); // Unselect the item
        //     }
        // });
        $(this).parent().remove(); // Remove the item from the display div
        toggleWrapper();
    });
    toggleWrapper();
    $("#font-weight-js").trigger('change');
}

function toggleWrapper() {
    
    if ($('#selected-options li').length === 0) {
        $('.list-tag-wrapper').addClass('d-none');
    } else {
        $('.list-tag-wrapper').removeClass('d-none');
    }
}

$(document).on('click', '.select2-selection__choice__remove', function (e) {
    e.preventDefault();

    // Find the parent element that contains the title attribute
    var $choice = $(this).parent();

    // Retrieve the value associated with the selected item
    var valueToRemove = $choice.attr('title');

    // Get the current selected values
    var $select = $('#font-weight-js');
    var selectedValues = $select.val();

    // Remove the value from the array of selected values
    if (selectedValues) {
        var index = selectedValues.indexOf(valueToRemove);
        if (index > -1) {
            selectedValues.splice(index, 1);
        }
    }

    // Update the Select2 component with the new selection
    $select.val(selectedValues).trigger('change');
});

