<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');

$frm = $testimonialMediaFrm;

$testimonialMediaFrm->setFormTagAttribute('class', 'form web_form form_horizontal');
$testimonialMediaFrm->developerTags['colClassPrefix'] = 'col-md-';
$testimonialMediaFrm->developerTags['fld_default_col'] = 12;
$fld2 = $testimonialMediaFrm->getField('testimonial_image');
$fld2->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$fld2->addFieldTagAttribute('onChange', 'popupImage(this)');
$preferredDimensionsStr = '<small class="text--small form-text text-muted">' . sprintf(Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId), '80*80') . '</small>';
$htmlAfterField = $preferredDimensionsStr;
if (!empty($testimonialImages)) {
    $htmlAfterField .= '<ul class="mt-3 image-listing grids--onethird uploaded-list uploaded-list">';
    foreach ($testimonialImages as $testimonialImg) {
        $htmlAfterField .= '<li class="uploaded-list-item"><div class="media-lab"><div class="uploaded--image media-lab-thumb"><img src="' . UrlHelper::generateFullUrl('Image', 'testimonial', array($testimonialImg['afile_record_id'], $testimonialImg['afile_lang_id'], 'THUMB'), CONF_WEBROOT_FRONT_URL) . '?t=' . time() . '"> <a href="javascript:void(0);" onClick="removeTestimonialImage(' . $testimonialImg['afile_record_id'] . ',' . $testimonialImg['afile_lang_id'] . ')" class="deleteLink white btn-close btn-close-white"></a></div></div>';
    }
    $htmlAfterField .= '</li></ul>';
}
$fld2->htmlAfterField = $htmlAfterField;

$recordId = (int) $testimonialId;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'editTestimonialForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false,
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'editTestimonialLangForm("' . $recordId . '","' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . '")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'testimonialMediaForm("' . $recordId . '")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => true,
        'isPrimary' => true
    ],
];
$formTitle = Labels::getLabel('LBL_Testimonial_Media_setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<div>
    <?php
    $tpl = new FatTemplate('', '');
    $tpl->set('adminLangId', $adminLangId);
    echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
    echo $testimonialMediaFrm->getFormHtml();
    ?>
</div>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>