<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'taxcat_identifier' => Labels::getLabel('LBL_Tax_Category_Name', $adminLangId),
);

if ($activatedTaxServiceId) {
    $arr_flds['taxcat_code'] = Labels::getLabel('LBL_Tax_Code', $adminLangId);
}

$arr_flds['taxcat_active'] = Labels::getLabel('LBL_Status', $adminLangId);
$arr_flds['action'] = Labels::getLabel('LBL_Action(s)', $adminLangId);
if (!$canEdit) {
    unset($arr_flds['select_all']);
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$defaultStringLength = applicationConstants::DEFAULT_STRING_LENGTH;

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr', array());
    $tr->setAttribute("id", $row['taxcat_id']);

    foreach ($arr_flds as $key => $val) {
        $attr = ('taxcat_identifier' == $key ? ['title' => $row[$key]] : []);
        $td = $tr->appendElement('td', $attr);
        switch ($key) {
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="taxcat_ids[]" value=' . $row['taxcat_id'] . '></label>', true);
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'taxcat_identifier':
                $taxCatIdentifier = substr($row[$key], 0, $defaultStringLength);
                if ($defaultStringLength < strlen($row[$key])) {
                    $taxCatIdentifier .= '...';
                }
                if ($row['taxcat_name'] != '') {
                    $taxCatName = substr($row['taxcat_name'], 0, $defaultStringLength);
                    if ($defaultStringLength < strlen($row['taxcat_name'])) {
                        $taxCatName .= '...';
                    }
                    $td->appendElement('plaintext', array(), $taxCatName, true);
                    $td->appendElement('br', array());
                    $td->appendElement('plaintext', array(), '(' . $taxCatIdentifier . ')', true);
                } else {
                    $td->appendElement('plaintext', array(), $taxCatIdentifier, true);
                }
                break;
            case 'taxcat_active':
                $active = "";
                if ($row['taxcat_active']) {
                    $active = 'checked';
                }
                $statusAct = ($canEdit === true) ? 'toggleStatus(event,this)' : '';
                $statusClass = ($canEdit === false) ? 'disabled' : '';    
                $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                      <input ' . $active . ' type="checkbox" id="switch' . $row['taxcat_id'] . '" value="' . $row['taxcat_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                     </label>';

                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'action':
                $actionArr = [];
                if ($canEdit) {

                    $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addTaxForm(" . $row['taxcat_id'] . ")"
                    ];

                    if (0 == $activatedTaxServiceId) {
                        $actionArr[] =
                        [
                            "title" => Labels::getLabel('LBL_Add_Rule', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#tax-rule'></use></svg>",
                            "href" => UrlHelper::generateUrl('Tax', 'ruleList', array($row['taxcat_id']))
                        ];
                    }
                    
                    $actionArr[] =
                        [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteRecord(" . $row['taxcat_id'] . ")"
                        ];

                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['taxcat_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}




$frm = new Form('frmTaxListing', array('id' => 'frmTaxListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('Tax', 'toggleBulkStatuses'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml(); 
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
</div>
<?php $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmTaxSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
