<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-12">

                            <h5><?php echo Labels::getLabel('LBL_Manage_Tax', $adminLangId); ?> </h5>
                            <div class="breadcrumb-wrap">
                                <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                                <a href="javascript:void(0)" class="btn btn-icon btn-outline-brand js-add-tax-rule" onclick="ruleForm('<?php echo $taxCatId ?>')" title="<?php echo Labels::getLabel('LBL_ADD_TAX_RULE', $adminLangId); ?>" data-bs-toggle="tooltip" data-placement="top" data-bs-original-title="<?php echo Labels::getLabel('LBL_ADD_TAX_RULE', $adminLangId); ?>">
                                    <svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                        <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                    </svg>
                                    <span><?php echo Labels::getLabel('Lbl_New', $adminLangId) ?></span>        
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <section class="card searchform_filter advance-search">
                    <div class="card-head">
                        <h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?></h4>
                    </div>
                    <div class="card-body extra togglewrap">
                        <?php
                        $frmSearch->setFormTagAttribute('onsubmit', 'searchRuleList(this); return(false);');
                        $frmSearch->setFormTagAttribute('class', 'form web_form');
                        $frmSearch->developerTags['colClassPrefix'] = 'col-md-';
                        $frmSearch->developerTags['fld_default_col'] = 6;

                        $clrFld = $frmSearch->getField('btn_clear');
                        $clrFld->setFieldTagAttribute('onClick', 'clearSearch()');
                        echo $frmSearch->getFormHtml();
                        ?>
                    </div>
                </section>
                <section class="card section">
                    <div class="card-head">
                        <h4>
                            <a href="javascript:void(0);" onclick="reloadList()" class="btn-back d-none" id="taxBackBtn"
                            title="<?php echo Labels::getLabel('LBL_BACK_TO_TAX_RULE', $adminLangId); ?>">
                                <svg class="svg" width="24" height="24">
                                    <use xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back">
                                    </use>
                                </svg>
                            </a>
                            <?php echo Labels::getLabel('LBL_TAX_RULES', $adminLangId) . " (" . $taxCategory . ")"; ?>
                        </h4>
                        <?php
                        if ($canEdit) {
                            $data = [
                                'adminLangId' => $adminLangId,
                                'statusButtons' => false,
                                'deleteButton' => false,
                                'otherButtons' => [
                                    /* [
                                        'attr' => [
                                            'href' => 'javascript:void(0)',
                                            'onclick' => 'reloadList()',
                                            // 'class' => 'd-none',
                                            'id' => 'taxBackBtn',
                                            'title' => Labels::getLabel('LBL_BACK_TO_TAX_RULE', $adminLangId)
                                        ],
                                        'label' => '<i class="fas fa-arrow-left"></i>'
                                    ], */
                                    /* [
                                        'attr' => [
                                            'href' => 'javascript:void(0)',
                                            'onclick' => 'ruleForm(' . $taxCatId . ')',
                                            'title' => Labels::getLabel('LBL_ADD_TAX_RULE', $adminLangId)
                                        ],
                                        'label' => '<svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                    <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                </svg>'
                                    ], */
                                ]
                            ];

                            $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        }
                        ?>
                    </div>
                    <div class="card-table">
                        <div class="table-responsive table-scrollable js-scrollable tablewrap">
                            <div id="taxListing"> <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>