<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'form web_form');
$frm->setFormTagAttribute('onsubmit', 'setupTaxStructure(this); return(false);');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;

$fld = $frm->getField('taxstr_is_combined');
$fld->setOptionListTagAttribute('class', 'list-radio');
$fld->developerTags['cbLabelAttributes'] = array('class' => 'switch switch-sm switch-icon');
$fld->developerTags['cbHtmlAfterCheckbox'] = '';

$formTitle = Labels::getLabel('LBL_Tax_Structure_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php echo $frm->getFormTag(); ?>
<div class="row">
	<div class="col-md-12">
		<div class="field-set">
			<div class="caption-wraper">
				<label class="form-label">
					<?php $fld = $frm->getField('taxstr_name[' . $siteDefaultLangId . ']');
					echo $fld->getCaption(); ?>
					<span class="spn_must_field">*</span></label>
			</div>
			<div class="field-wraper">
				<div class="field_cover">
					<?php echo $frm->getFieldHtml('taxstr_name[' . $siteDefaultLangId . ']'); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<div class="row">
	<div class="col-md-12">
		<div class="field-set">
			<div class="field-wraper">
				<div class="field_cover setting-block">
					<?php echo $frm->getFieldHtml('taxstr_is_combined'); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php $combTaxCount = 0; ?>
<?php if (array_key_exists('taxstr_is_combined', $taxStrData) && $taxStrData['taxstr_is_combined']) { ?>
	<div id="combinedTax-js" <?php echo (!array_key_exists('taxstr_is_combined', $taxStrData) || (!$taxStrData['taxstr_is_combined'])) ? 'style="display:none"' : ''; ?>>
		<div class="row">
			<div class="col-md-12">
				<h6><?php
				$fld = $frm->getField('taxstr_component_name[' . $combTaxCount . '][' . $siteDefaultLangId . ']');
				echo $fld->getCaption();
				?> <span class="spn_must_field">*</span></h6>
			</div>
		</div>
		<div class="row combined-tax--js">
			<?php foreach ($combinedTaxes as $combTaxCount => $combinedTax) { ?>
				<div class="col-md-12 combined-tax-row<?php echo $combTaxCount; ?>">
					<div class="field-set">
						<div class="field-wraper">
							<div class="field_cover d-flex">
								<input type="text"
									data-field-caption="<?php echo Labels::getLabel('LBL_Tax_Component_Name', $adminLangId) ?>"
									name="taxstr_component_name[<?php echo $combTaxCount; ?>][<?php echo $siteDefaultLangId; ?>]"
									value="<?php echo isset($combinedTax[$siteDefaultLangId]) ? $combinedTax[$siteDefaultLangId] : ''; ?>"
									maxlength="30">
								<button type="button" data-id="<?php echo $combTaxCount; ?>"
									class="btn btn-brand remove-combined-form--js ms-2"
									title="<?php echo Labels::getLabel('LBL_Remove', $adminLangId); ?>"><svg class="svg" width="18" height="18"><use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#minus"></use></svg></button>
								<button type="button" class="btn btn-brand add-combined-form--js ms-2"
									title="<?php echo Labels::getLabel('LBL_Add', $adminLangId); ?>"><svg class="svg" width="18" height="18"><use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#plus"></use></svg></button>
							</div>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
<?php } else { ?>
	<div id="combinedTax-js" <?php echo (!array_key_exists('taxstr_is_combined', $taxStrData) || (!$taxStrData['taxstr_is_combined'])) ? 'style="display:none"' : ''; ?>>
		<div class="row">
			<div class="col-md-12">
				<h6><?php
				$fld = $frm->getField('taxstr_component_name[' . $combTaxCount . '][' . $siteDefaultLangId . ']');
				echo $fld->getCaption();
				?> <span class="spn_must_field">*</span></h6>
			</div>
		</div>
		<div class="row combined-tax--js">
			<div class="col-md-12 combined-tax-row<?php echo $combTaxCount; ?>">
				<div class="field-set">
					<div class="field-wraper">
						<div class="field_cover d-flex">
							<?php echo $frm->getFieldHtml('taxstr_component_name[' . $combTaxCount . '][' . $siteDefaultLangId . ']'); ?>
							<button type="button" data-id="<?php echo $combTaxCount; ?>"
								class="btn btn-brand ripplelink remove-combined-form--js ms-2"
								title="<?php echo Labels::getLabel('LBL_Remove', $adminLangId); ?>"><svg class="svg" width="18" height="18"><use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#minus"></use></svg></button>
							<button type="button" class="btn btn-brand add-combined-form--js ms-2"
								title="<?php echo Labels::getLabel('LBL_Add', $adminLangId); ?>"><svg class="svg" width="18" height="18"><use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#plus"></use></svg></button>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php } ?>
<?php /* $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
																		  if(!empty($translatorSubscriptionKey) && count($otherLangData) > 0) { ?>
<div class="col-md-12">
<div class="field-set">
<div class="field-wraper">
<div class="field_cover">
<?php echo $frm->getFieldHtml('auto_update_other_langs_data'); ?>
</div>
</div>
</div>
</div>
</div>
<?php } */ ?>
<?php if (!empty($otherLangData)) {
	foreach ($otherLangData as $langId => $data) { ?>
		<div class="custom-accordion accordians_container accordians_container-categories"
			defaultLang="<?php echo $siteDefaultLangId; ?>" language="<?php echo $langId; ?>"
			id="accordion-language_<?php echo $langId; ?>" onClick="translateData(this)">
			<div class="custom-accordion-block accordian_panel">
				<button class="accordian-btn btn btn-secondary dropdown-toggle accordianhead"
					id="collapse_<?php echo $langId; ?>">
					<?php echo $data . " ";
					echo Labels::getLabel('LBL_Language_Data', $adminLangId); ?>
				</button>
				<div class="custom-accordion-body accordian_body accordiancontent form-section" style="display: none;">
					<div class="row">
						<div class="col-md-12">
							<div class="field-set">
								<div class="caption-wraper">
									<label class="form-label">
										<?php $fld = $frm->getField('taxstr_name[' . $langId . ']');
										echo $fld->getCaption(); ?>
									</label>
								</div>
								<div class="field-wraper">
									<div class="field_cover">
										<?php echo $frm->getFieldHtml('taxstr_name[' . $langId . ']'); ?>
									</div>
								</div>
							</div>
						</div>
					</div>
					<?php $combTaxCount = 0; ?>
					<?php if (array_key_exists('taxstr_is_combined', $taxStrData) && $taxStrData['taxstr_is_combined']) { ?>
						<div id="combinedTaxLang-js" <?php echo (!array_key_exists('taxstr_is_combined', $taxStrData) || (!$taxStrData['taxstr_is_combined'])) ? 'style="display: none;"' : ''; ?>>
							<div class="row">
								<div class="col-md-12">
									<h6><?php
									$fld = $frm->getField('taxstr_component_name[' . $combTaxCount . '][' . $langId . ']');
									echo $fld->getCaption();
									?> </h6>
								</div>
							</div>
							<div class="row combined-tax-lang--js<?php echo $langId; ?>">
								<?php foreach ($combinedTaxes as $combTaxCount => $combinedTax) { ?>
									<div class="col-md-12 combined-tax-row<?php echo $combTaxCount; ?>">
										<div class="field-set">
											<div class="field-wraper">
												<div class="field_cover">
													<input type="text"
														data-field-caption="<?php echo Labels::getLabel('LBL_Tax_Component_Name', $adminLangId) ?>"
														name="taxstr_component_name[<?php echo $combTaxCount; ?>][<?php echo $langId; ?>]"
														value="<?php echo isset($combinedTax[$langId]) ? $combinedTax[$langId] : ''; ?>"
														maxlength="30">
												</div>
											</div>
										</div>
									</div>
								<?php } ?>
							</div>
						</div>
					<?php } else { ?>
						<div id="combinedTaxLang-js" <?php echo (!array_key_exists('taxstr_is_combined', $taxStrData) || (!$taxStrData['taxstr_is_combined'])) ? 'style="display: none;"' : ''; ?>>
							<div class="row">
								<div class="col-md-12">
									<h6><?php
									$fld = $frm->getField('taxstr_component_name[' . $combTaxCount . '][' . $langId . ']');
									echo $fld->getCaption();
									?> </h6>
								</div>
							</div>
							<div class="row combined-tax-lang--js<?php echo $langId; ?>">
								<div class="col-md-12 combined-tax-row<?php echo $combTaxCount; ?>">
									<div class="field-set">
										<div class="field-wraper">
											<div class="field_cover">
												<?php echo $frm->getFieldHtml('taxstr_component_name[' . $combTaxCount . '][' . $langId . ']'); ?>
											</div>
										</div>
									</div>
								</div>
							</div>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	<?php }
} ?>
<div class="row">
	<div class="col-md-12">
		<div class="field-set d-flex align-items-center">
			<div class="field-wraper w-auto">
				<div class="field_cover">
					<?php //echo $frm->getFieldHtml('btn_submit'); ?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php echo $frm->getFieldHtml('taxstr_id'); ?>
</form>
<?php echo $frm->getExternalJS(); ?>

<script>
	$(document).ready(function () {
		var combTaxCount = <?php echo $combTaxCount; ?>;
		$('body').on('click', '.add-combined-form--js', function (event) {
			event.stopImmediatePropagation();
			combTaxCount++;
			var rowHtml = '<div class="col-md-12 combined-tax-row' + combTaxCount + '"><div class="field-set"><div class="field-wraper"><div class="field_cover d-flex"><input maxlength ="30" type="text" data-field-caption="<?php echo Labels::getLabel('LBL_Tax_Component_Name', $adminLangId) ?>" name="taxstr_component_name[' + combTaxCount + '][<?php echo $siteDefaultLangId; ?>]" value=""><button type="button" data-id="' + combTaxCount + '" class="btn btn-brand remove-combined-form--js ms-2" title="<?php echo Labels::getLabel('LBL_Remove', $adminLangId); ?>"><svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16"><use xlink:href="/images/admin/retina/sprite-actions.svg#minus"></use></svg></button><button type="button" class="btn btn-brand  add-combined-form--js ms-2" title="<?php echo Labels::getLabel('LBL_Add', $adminLangId); ?>"><svg class="svg" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16"><use xlink:href="/images/admin/retina/sprite-actions.svg#plus"></use></svg></button></div></div></div></div>';
			$('.combined-tax--js').append(rowHtml);

			<?php foreach ($otherLangData as $langId => $data) { ?>
				var langRowHtml = '<div class="col-md-12 combined-tax-row' + combTaxCount +
					'"><div class="field-set"><div class="field-wraper"><div class="field_cover"><input  maxlength ="30" type="text" data-field-caption="<?php echo Labels::getLabel('LBL_Tax_Component_Name', $langId) ?>"  name="taxstr_component_name[' +
					combTaxCount + '][<?php echo $langId; ?>]" value=""></div></div></div></div>';
				$('.combined-tax-lang--js' + <?php echo $langId; ?>).append(langRowHtml);
			<?php } ?>
			fcom.resetBootstrapModalHeight();
		});



		// Find and remove selected table rows
		$('body').on('click', '.remove-combined-form--js', function () {
			var rowCount = $(this).data("id");
			if (rowCount > 0) {
				var className = $('.combined-tax-row' + rowCount).remove();
			}
			fcom.resetBootstrapModalHeight();
		});
	});
</script>

<style>
	#combinedTax-js .combined-tax-row0 .remove-combined-form--js.ms-2 {
		display: none;
	}
	<?php 
	if(CommonHelper::getLayoutDirection() == 'rtl') { ?>

		#combinedTax-js .ms-2 {
			margin-right: .5rem !important;
			margin-left: 0 !important;
		}
		<?php
	}
	?>
</style>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>