<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<section class="card section">
    <div class="card-head">
        <h4><?php echo Labels::getLabel('LBL_Shop_Setup', $adminLangId); ?></h4>
    </div>
    <div class="card-body extra">
        <div class="row">
            <div class="col-sm-12">
                <div class="need-remove">
                    <ul class="nav-tabs nav-tabs-line tabs_nav">
                        <li class="nav-tabs-item">
                            <a class="nav-tabs-link" href="javascript:void(0);" onclick="shopForm(<?php echo $shop_id ?>);">
                                <?php echo Labels::getLabel('LBL_General', $adminLangId); ?>
                            </a>
                        </li>
                        <li class="nav-tabs-item <?php echo (0 == $shop_id) ? 'fat-inactive' : ''; ?>">
                            <a class="nav-tabs-link" href="javascript:void(0);" <?php echo (0 < $shop_id) ? "onclick='addShopLangForm(" . $shop_id . "," . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ");'" : ""; ?>>
                                <?php echo Labels::getLabel('LBL_Language_Data', $adminLangId); ?>
                            </a>
                        </li>
                        <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0);" <?php if ($shop_id > 0) { ?>
                                        onclick="shopMediaForm(<?php echo $shop_id ?>);" <?php } ?>><?php echo Labels::getLabel('LBL_Media', $adminLangId); ?></a></li>
                        <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0);" <?php if ($shop_id > 0) { ?>
                                        onclick="shopCollections(<?php echo $shop_id ?>);" <?php } ?>><?php echo Labels::getLabel('LBL_Collections', $adminLangId); ?></a></li>
                    </ul>
                    <div class="tabs_panel_wrap">
                        <div class="row" id="shopFormBlock">
                            <?php foreach ($shopTemplateLayouts as $k => $layout) { ?>
                                    <div class="col-lg-3 col-md-3 col-sm-3 col-xs-12  ">
                                        <div
                                            class="shop-template <?php echo ($shopLayoutTemplateId == $layout['ltemplate_id']) ? 'is--active' : ''; ?>">
                                            <a href="javascript:void(0)"
                                                onClick="setTemplate(<?php echo $shop_id; ?>,<?php echo $layout['ltemplate_id']; ?>)">
                                                <figure class="thumb--square"><img
                                                        src="<?php echo UrlHelper::generateFullUrl('Image', 'shopLayout', array($layout['ltemplate_id'], 'THUMB'), CONF_WEBROOT_FRONT_URL) ?>"
                                                        alt=""></figure>
                                                <p style="text-align: center">
                                                    <?php echo Labels::getLabel('LBL_Layout', $adminLangId); ?>
                                                    <strong><?php echo $layout['ltemplate_id']; ?></strong>
                                                </p>
                                            </a>
                                        </div>
                                    </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>