<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
    <?php
    $arr_flds = array(
        'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
        // 'listserial' => Labels::getLabel('LBL_#', $adminLangId),
        // 'shop_logo' => '',
        'shop_identifier' => Labels::getLabel('LBL_Name', $adminLangId),
        // 'user_name' => Labels::getLabel('LBL_Owner', $adminLangId),
        'numOfProducts' => Labels::getLabel('LBL_Products', $adminLangId),
        'numOfReports' => Labels::getLabel('LBL_Reports', $adminLangId),
        'numOfReviews' => Labels::getLabel('LBL_Reviews', $adminLangId),
        'shop_featured' => Labels::getLabel('LBL_Featured', $adminLangId),
        'shop_active' => Labels::getLabel('LBL_Status', $adminLangId),
        'shop_created_on' => Labels::getLabel('LBL_Created_on', $adminLangId),
        'shop_supplier_display_status' => Labels::getLabel('LBL_Status_by_seller', $adminLangId),
        'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
    );
    if (!$canEdit) {
        unset($arr_flds['select_all'], $arr_flds['action']);
    }
    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
    $th = $tbl->appendElement('thead')->appendElement('tr');
    foreach ($arr_flds as $key => $val) {
        if ('select_all' == $key) {
            $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
        } elseif ('shop_identifier' == $key) {
            $e = $th->appendElement('th', array('width' => '30%'), $val);
        } else {
            $e = $th->appendElement('th', array(), $val);
        }
    }

    $sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
    foreach ($arr_listing as $sn => $row) {
        $tr = $tbl->appendElement('tr', array('id' => $row['shop_id'], 'class' => ''));

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'select_all':
                    $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="shop_ids[]" value=' . $row['shop_id'] . '></label>', true);
                    break;
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no);
                    break;
                case 'shop_logo':
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_SHOP_LOGO, $row['shop_id'], 0, 0, false);
                    $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId);
                    $str = '<div class="shop-logo"><img class="" width="60" ';
                    if (!empty($fileData) && $fileData['afile_aspect_ratio'] > 0) {
                        $str .= 'data-ratio="' . $aspectRatioArr[$fileData['afile_aspect_ratio']] . '"';
                    }
                    $str .= 'src="' . UrlHelper::generateUrl('image', 'shopLogo', array($row['shop_id'], $adminLangId, 'THUMB'), CONF_WEBROOT_FRONT_URL) . '?t=' . strtotime($fileData['afile_updated_at']) . '" alt="' . $row['shop_name'] . '"></div>';
                    $td->appendElement('plaintext', array(), $str, true);
                    break;
                case 'user_name':
                    $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['shop_user_id'] . ')'), $row['user_name'], true);
                    break;
                case 'shop_supplier_display_status':
                    $td->appendElement('plaintext', array(), $onOffArr[$row[$key]], true);
                    break;
                case 'shop_active':
                    $active = "";
                    if ($row['shop_active']) {
                        $active = 'checked';
                    }
                    $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                    $statusClass = ($canEdit === false) ? 'disabled' : '';
                    $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                        <input ' . $active . ' type="checkbox" id="switch' . $row['shop_id'] . '" value="' . $row['shop_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                        </label>';
                    $td->appendElement('plaintext', array(), $str, true);
                    break;
                case 'numOfProducts':
                    if ($canViewSellerProducts) {
                        $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('SellerProducts') . '", ' . $row['shop_user_id'] . ')'), $row[$key]);
                    } else {
                        $td->appendElement('plaintext', array(), $row[$key], true);
                    }
                    break;
                case 'shop_featured':
                    $td->appendElement('plaintext', array(), applicationConstants::getYesNoArr($adminLangId)[$row[$key]], true);
                    break;
                case 'numOfReports':
                    if ($canViewShopReports) {
                        $td->appendElement('a', array('target' => '_blank', 'href' => UrlHelper::generateUrl('ShopReports', 'index', array($row['shop_id']))), $row[$key]);
                    } else {
                        $td->appendElement('plaintext', array(), $row[$key], true);
                    }
                    break;
                case 'numOfReviews':
                    if ($canViewShopReports) {
                        $td->appendElement('a', array('target' => '_blank', 'href' => UrlHelper::generateUrl('ProductReviews', 'index', array($row['shop_user_id']))), $row[$key]);
                    } else {
                        $td->appendElement('plaintext', array(), $row[$key], true);
                    }
                    break;
                case 'shop_identifier':
                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_SHOP_LOGO, $row['shop_id'], 0, 0, false);
                    $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId);
                    $strImg = '<img ';
                    if (!empty($fileData) && $fileData['afile_aspect_ratio'] > 0) {
                        $strImg .= 'data-aspect-ratio="' . $aspectRatioArr[$fileData['afile_aspect_ratio']] . '"';
                    }
                    $strImg .= 'src="' . UrlHelper::generateUrl('image', 'shopLogo', array($row['shop_id'], $adminLangId, 'THUMB1'), CONF_WEBROOT_FRONT_URL) . '?t=' . strtotime($fileData['afile_updated_at']) . '" alt="' . $row['shop_name'] . '">';


                    $str = '<div class="shop-profile">
                                <div class="shop-profile-thumbnail">
                                <a target="_blank" href="' . UrlHelper::generateUrl('image', 'shopLogo', array($row['shop_id'], $adminLangId, 'ORIGINAL'), CONF_WEBROOT_FRONT_URL) . '?t=' . strtotime($fileData['afile_updated_at']) . '">
                                    ' . $strImg . '
                                </a>
                            </div>
                            <div class="shop-profile-data">
                            <div class="title">' . $row['shop_name'] . '<br><span class="text-muted form-text">(' . $row[$key] . ')</span></div>
                                <ul class="list-options list-options--vertical" >
                                        <li  class="list-options-item">
                                            <span class="label">' . Labels::getLabel('LBL_Seller', $adminLangId) . ':</span>
                                            <a href="javascript:void();" onclick="redirectfunc(\'' . UrlHelper::generateUrl('Users') . '\',\'' . $row['shop_user_id'] . '\')" class="value">' . $row['user_name'] . '</a>
                                        </li>
                                </ul>
                            </div>
                    </div>';

                    $td->appendElement('plaintext', array(), $str, true);

                    break;
                case 'shop_created_on':
                    $date = FatDate::format($row[$key]);
                    $dateHtml = "";
                    if (strpos($date, ' ') !== false) {
                        list($formattedDate, $formattedTime) = explode(' ', $date);
                        $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                    } else {
                        $dateHtml = "<date class='date'>" . $date . "</date>";
                    }
                    $td->appendElement('plaintext', array(), $dateHtml, true);
                    break;
                case 'action':
                    if ($canEdit) {
                        $actionArr = [
                            [
                                "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                "onclick" => "addShopForm(" . $row['shop_id'] . ")"
                            ]
                        ];
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['shop_id']], false);
                    }
                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }
        $sr_no--;
    }


    $frm = new Form('frmShopListing', array('id' => 'frmShopListing'));
    $frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
    $frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
    $frm->setFormTagAttribute('action', UrlHelper::generateUrl('Shops', 'toggleBulkStatuses'));
    $frm->addHiddenField('', 'status');

    echo $frm->getFormTag();
    echo $frm->getFieldHtml('status');
    ?>
    <?php echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
        $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
    }
    ?>
    </form>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmShopSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);