<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'form web_form form_horizontal');
$frm->setFormTagAttribute('onsubmit', 'setupRate(this); return(false);');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;

$nameFld = $frm->getField('shiprate_identifier');
$nameFld->htmlAfterField = "<span class='form-text text-muted'>" . Labels::getLabel("LBL_Customers_will_see_this_at_checkout.", $adminLangId) . "</span>";

if (CommonHelper::isDistanceShippingEnabled()) {
    $costFld = $frm->getField('shiprate_cost');
}

$daysFld = $frm->getField('shiprate_min_duration');
$daysFld->captionWrapper = array('<div>', '<svg class="svg" data-toggle="tooltip" data-placement="right" title="' . Labels::getLabel("LBL_Minimum_Duration_For_Shipping(Days).", $adminLangId) . '" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#info-circle"></use></svg></div>');

$recordId = (int) $rateId;
$tabsButtons[] = [
        'attr' => [
            'onclick' => 'addEditShipRates('.$zoneId.','.$recordId.')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => true,
        'isPrimary' => true
];
foreach ($languages as $keylangId => $langName) { 
$tabsButtons[] = [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'editRateLangForm("'.$zoneId.'","'.$recordId.'","'.$keylangId.'")' : '',
            'title' => Labels::getLabel('LBL_' . $langName, $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_' . $langName, $adminLangId),
        'isActive' => false,
		'isDisabled' => $inactive = ($rateId == 0) ?true:false
];
}

$formTitle = Labels::getLabel('LBL_Manage_Rates', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>

<?php echo $frm->getFormHtml(); ?>
<script>
	$('[data-toggle="tooltip"]').tooltip();
</script>

<?php 
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>

