<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

    $arr_flds = array(
        'listserial' => Labels::getLabel('LBL_#', $adminLangId),
        'shippack_name' => Labels::getLabel('LBL_Name', $adminLangId),
        'shippack_units' => Labels::getLabel('LBL_Dimensions', $adminLangId),
        'action' => Labels::getLabel('', $adminLangId)
    );

    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
    $th = $tbl->appendElement('thead')->appendElement('tr');
    foreach ($arr_flds as $key => $val) {
        $th->appendElement('th', array(), $val);
    }

    $sr_no = ($page == 1) ? 0 : ($pageSize * ($page - 1));
    foreach ($arr_listing as $sn => $row) {
        $sr_no++;
        $tr = $tbl->appendElement('tr', array());

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no);
                    break;
                case 'shippack_units':
                    $unitType = (isset($unitTypeArray[$row['shippack_units']])) ? $unitTypeArray[$row['shippack_units']] : '';

                    $dimension = $row['shippack_length'] . ' x ' . $row['shippack_width'] . ' x ' . $row['shippack_height'] . ' ' . $unitType;

                    $td->appendElement('plaintext', array(), $dimension, true);
                    break;
                case 'action':
                    if ($canEdit) {
                        $actionArr = [
                            [
                                "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                "onclick" => 'addPackageForm(' . $row['shippack_id'] . ')'
                            ]
                        ];
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['shippack_id']], false);
                    }
                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }
    }


    $frm = new Form('frmPackageListing', array('id' => 'frmPackageListing'));
    $frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
    $frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
    echo $frm->getFormTag();
    echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
        $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
    }  
    ?>
    </form>
    <?php $postedData['page'] = $page;
    echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmPackageSearchPaging'));
    $pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
    $this->includeTemplate('_partial/pagination.php', $pagingArr, false);

