<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'dragdrop' => '',
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'shippingapi_identifier' => Labels::getLabel('LBL_Shipping_Method', $adminLangId),
    'shippingapi_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['dragdrop']);
    unset($arr_flds['select_all']);
    unset($arr_flds['action']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered  table-justified', 'id' => 'shippingMethod'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = 0;
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr', array());
    $tr->setAttribute("id", $row['shippingapi_id']);

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'dragdrop':
                if ($row['shippingapi_active'] == applicationConstants::ACTIVE) {
                    $td->appendElement('svg', array('width'=>'16','height'=>'16'),"<use xlink:href='".CONF_WEBROOT_FRONT_URL."images/admin/retina/sprite.svg#drag-move-2'></use>",true);
                    $td->setAttribute("class", 'dragHandle');
                }
                break;
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="shippingapi_ids[]" value=' . $row['shippingapi_id'] . '></label>', true);
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'shippingapi_active':
                $active = "";
                if ($row['shippingapi_active']) {
                    $active = 'checked';
                }
                $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(this,' . applicationConstants::NO . ')';
                $statusClass = ($canEdit === false) ? 'disabled' : '';
                $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                <input ' . $active . ' type="checkbox" id="switch' . $row['shippingapi_id'] . '" value="' . $row['shippingapi_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                </label>';
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'shippingapi_identifier':
                if ($row['shippingapi_name'] != '') {
                    $td->appendElement('plaintext', array(), $row['shippingapi_name'], true);
                    $td->appendElement('br', array());
                    $td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                } else {
                    $td->appendElement('plaintext', array(), $row[$key], true);
                }
                break;
            case 'action':
                if ($canEdit) {

                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "editForm(" . $row['shippingapi_id'] . ")"
                        ]
                    ];
                    if ($row['shippingapi_id'] > 1) {
                        $actionArr[] = [
                                "title" => Labels::getLabel('LBL_Settings', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#gear'></use></svg>",
                                "onclick" => "settingsForm(" . $row['shippingapi_id'] . ")"
                        ];
                    }


                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['shippingapi_id']], false);
                    
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}


$frm = new Form('frmShpApiListing', array('id' => 'frmShpApiListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('ShippingMethods', 'toggleBulkStatuses'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml(); 
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
<script>
    $(document).ready(function () {
        $('#shippingMethod').tableDnD({
            onDrop: function (table, row) {
                fcom.displayProcessing();
                var order = $.tableDnD.serialize('id');
                fcom.ajax(fcom.makeUrl('ShippingMethods', 'updateOrder'), order, function (res) {
                    var ans = $.parseJSON(res);
                    if (ans.status == 1) {
                        fcom.displaySuccessMessage(ans.msg);
                    } else {
                        fcom.displayErrorMessage(ans.msg);
                    }
                });
            },
            dragHandle: ".dragHandle",
        });
    });
</script>