<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="card-head">
    <h4>
        <a class="btn-back" href="javascript:void(0)" onclick="searchPackages()">
            <svg class="svg" width="24" height="24">
                <use xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back"></use>
            </svg>
        </a>
        <?php echo Labels::getLabel('LBL_Seller_Packages_Listings', $adminLangId); ?>
    </h4>
    <?php
    $url = UrlHelper::generateUrl('FaqCategories');
    $data = [
        'adminLangId' => $adminLangId,
        'statusButtons' => false,
        'deleteButton' => false,
        'otherButtons' => [
            /*  [
                 'attr' => [
                     'href' => 'javascript:void(0)',
                     'onclick' => "searchPackages()",
                     'title' => Labels::getLabel('LBL_BACK', $adminLangId)
                 ],
                 'label' => '<i class="fas fa-arrow-left"></i>'
             ], */
        ]
    ];

    if ($canEdit && $spackageData[sellerPackages::DB_TBL_PREFIX . 'type'] != sellerPackages::FREE_TYPE || ($spackageData[sellerPackages::DB_TBL_PREFIX . 'type'] == sellerPackages::FREE_TYPE && empty($arr_listing))) {
        /* $data['otherButtons'][] = [
            'attr' => [
                'href' => 'javascript:void(0)',
                'onclick' => "planForm(" . $spackageId . ")",
                'title' => Labels::getLabel('LBL_Add_New', $adminLangId)
            ],
            'label' => '<svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                    <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                </svg>'
        ]; */
    }

    $this->includeTemplate('_partial/action-buttons.php', $data, false);
    ?>
</div>
<div class="card-table">
    <div class="table-responsive table-scrollable js-scrollable tablewrap">
        <?php
        $arr_flds = array(
            'listserial' => Labels::getLabel('LBL_#', $adminLangId),
            SellerPackagePlans::DB_TBL_PREFIX . 'price' => Labels::getLabel('LBL_Plan_Price', $adminLangId),
            'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
        );

        $tbl = new HtmlElement(
            'table',
            array('width' => '100%', 'class' => 'table table-hovered table-justified', 'id' => 'options')
        );

        $th = $tbl->appendElement('thead')->appendElement('tr');
        foreach ($arr_flds as $val) {
            $e = $th->appendElement('th', array(), $val);
        }

        $sr_no = 0;
        foreach ($arr_listing as $sn => $row) {
            $sr_no++;
            $tr = $tbl->appendElement('tr');
            $tr->setAttribute("id", $row[SellerPackagePlans::DB_TBL_PREFIX . 'id']);
            if ($row['spplan_active'] != applicationConstants::ACTIVE) {
                $tr->setAttribute("class", "fat-inactive nodrag nodrop tr-inactive");
            }
            foreach ($arr_flds as $key => $val) {
                $td = $tr->appendElement('td');
                switch ($key) {
                    case 'listserial':
                        $td->appendElement('plaintext', array(), $sr_no);
                        break;
                    case SellerPackagePlans::DB_TBL_PREFIX . 'price':
                        $td->appendElement('plaintext', array(), SellerPackagePlans::getPlanPriceWithPeriod($row, $row[SellerPackagePlans::DB_TBL_PREFIX . 'price']), true);
                        break;
                    case SellerPackagePlans::DB_TBL_PREFIX . 'trial_interval':
                        $td->appendElement('plaintext', array(), SellerPackagePlans::getPlanTrialPeriod($row), true);
                        break;

                        break;

                    case 'action':
                        if ($canEdit) {
                            $actionArr = [
                                [
                                    "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                    "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                    "onclick" => "planForm(" . $row[SellerPackagePlans::DB_TBL_PREFIX . 'spackage_id'] . "," . $row[SellerPackagePlans::DB_TBL_PREFIX . 'id'] . ")"
                                ]
                            ];
                            $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $key], false);
                        }
                        break;
                    default:
                        $td->appendElement('plaintext', array(), $row[$key], true);
                        break;
                }
            }
        }
        echo $tbl->getHtml();
        if (count($arr_listing) == 0) {
            $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
        }
        ?>
    </div>
</div>