<?php
$selected_method = '';
if ($order['order_pmethod_id']) {
    $selected_method .= CommonHelper::displayNotApplicable($adminLangId, $order["plugin_name"]);
}
if ($order['order_is_wallet_selected'] == applicationConstants::YES) {
    $selected_method .= ($selected_method != '') ? ' + ' . Labels::getLabel("LBL_Wallet", $adminLangId) : Labels::getLabel("LBL_Wallet", $adminLangId);
}
if ($order['order_reward_point_used'] > 0) {
    $selected_method .= ($selected_method != '') ? ' + ' . Labels::getLabel("LBL_Rewards", $adminLangId) : Labels::getLabel("LBL_Rewards", $adminLangId);
}
if (!empty($order['plugin_code']) && strtolower($order['plugin_code']) == 'cashondelivery' && $order['opshipping_fulfillment_type'] == Shipping::FULFILMENT_PICKUP) {
    $selected_method = Labels::getLabel('LBL_PAY_ON_PICKUP', $adminLangId);
}

$orderStatusLbl = Labels::getLabel('LBL_AWAITING_SHIPMENT', $adminLangId);
$orderStatus = '';
if (!empty($order["thirdPartyorderInfo"]) && isset($order["thirdPartyorderInfo"]['orderStatus'])) {
    $orderStatus = $order["thirdPartyorderInfo"]['orderStatus'];
    $orderStatusLbl = strpos($orderStatus, "_") ? str_replace('_', ' ', $orderStatus) : $orderStatus;
}

if (!empty($order['opship_tracking_url'])) {
    $orderStatusLbl = Labels::getLabel('LBL_SHIPPED', $adminLangId);
}
$completedOrderStatus = FatApp::getConfig("CONF_RENTAL_COMPLETED_ORDER_STATUS");
$orderProducts = array_merge(array($order), $attachedServices);
$isShippingDisplay = false;
foreach ($orderProducts as $orderProduct) {
    if (Shipping::FULFILMENT_PICKUP != $orderProduct['opshipping_fulfillment_type']) {
        $isShippingDisplay = true;
        break;
    }
}
$penaltyPercentage = 0;
if (!empty($cancelRequestDetail) && $cancelRequestDetail['ocrequest_status'] == "1" && $cancelRequestDetail['ocrequest_is_penalty_applicable'] == "1") {
    $penaltyPercentage = $cancelRequestDetail['ocrequest_refund_amount'];
}

?>
<div class="page">
    <div class="content content-space">
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <?php if (!$print) { ?>
                    <div class="page-title no-print">
                        <div class="row">
                            <div class="col--first col-lg-6">

                                <h5><?php echo Labels::getLabel('LBL_Orders_Details', $adminLangId); ?></h5>
                                <?php
                                $breadcrumbData = [];
                                if ($order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {
                                    $breadcrumbData['hrefRental'] = '/rental';
                                }
                                $this->includeTemplate('_partial/header/header-breadcrumb.php', $breadcrumbData);
                                ?>
                                <?php
                                if (isset($parentorder) && !empty($parentorder)) {
                                    echo HtmlHelper::getMessage(Labels::getLabel('LBL_This_order_is_extended_from_', $adminLangId) . ' <a href="' . CommonHelper::generateUrl('SellerOrders', 'view', array($parentorder['op_id'])) . '">#' . $parentorder['op_invoice_number'] . '</a> ');
                                }
                                if (isset($extendedChildData) && !empty($extendedChildData)) {
                                    echo HtmlHelper::getMessage(Labels::getLabel('LBL_This_order_is_extended_by', $adminLangId) . ' <a href="' . CommonHelper::generateUrl('SellerOrders', 'view', array($extendedChildData['opd_op_id'])) . '">#' . $extendedChildData['opd_order_id'] . '</a> ');
                                }
                                ?>
                            </div>
                        </div>
                    </div>

                    <?php /*  [ RENTAL END COUNTER NOTE  */ ?>
                    <?php if ($order['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) { ?>
                        <?php
                        if (strtotime($order['opd_rental_start_date']) <= strtotime(date('Y-m-d 00:00:00')) && strtotime($order['opd_rental_end_date']) >= strtotime(date('Y-m-d 00:00:00')) && in_array($order['op_status_id'], OrderStatus::statusArrForRentalExpireNote())) {
                            if (date('Y-m-d 00:00:00') == $order['opd_rental_end_date']) {
                                $dateToRentalEnd = 0;
                            } else {
                                $dateToRentalEnd = CommonHelper::getDifferenceBetweenDates(date('Y-m-d 00:00:00'), $order['opd_rental_end_date'], 0, ProductRental::DURATION_TYPE_DAY);
                            }

                            if ($dateToRentalEnd >= 3) {
                                $rentalEndMsgClass = 'alert-success';
                            } elseif ($dateToRentalEnd >= 2) {
                                $rentalEndMsgClass = 'alert-warning';
                            } else {
                                $rentalEndMsgClass = 'alert-danger';
                            }
                            ?>
                            <div class="alert text-center  alert-dismissible fade show <?php echo $rentalEndMsgClass; ?>"
                                role="alert">
                                <h5><?php echo $dateToRentalEnd . ' ' . Labels::getLabel('LBL_Day(s)_Remaining_to_end_rental', $adminLangId); ?>
                                </h5>
                            </div>
                        <?php } elseif (strtotime($order['opd_rental_end_date']) < strtotime(date('Y-m-d 00:00:00')) && in_array($order['op_status_id'], OrderStatus::statusArrForLateChargeNote())) { ?>
                            <div class="alert alert-primary text-center alert-dismissible fade show" role="alert">
                                <h5> <?php echo Labels::getLabel('LBL_Rental_Duration_Ended._Late_Charges_may_be_Apply', $adminLangId); ?>
                                </h5>
                                <!-- <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button> -->
                            </div>
                        <?php } ?>
                    <?php } ?>
                    <?php /* ]  */ ?>
                <?php } ?>
                <section class="card section">
                    <div class="card-head">
                        <h4>
                            <?php
                            if (!$print) {
                                $backUrl = UrlHelper::generateUrl('SellerOrders');
                                if ($order['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                    $backUrl = UrlHelper::generateUrl('SellerOrders', 'rental');
                                }
                                ?>
                                <a class="btn-back" href="<?php echo $backUrl ?>">
                                    <svg class="svg" width="24" height="24">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back">
                                        </use>
                                    </svg>
                                </a>
                                <?php

                            }
                            ?>

                            <?php echo Labels::getLabel('LBL_Seller_Order_Details', $adminLangId); ?>
                        </h4>
                        <?php
                        if (!$print) {
                            $backUrl = UrlHelper::generateUrl('SellerOrders');
                            if ($order['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                $backUrl = UrlHelper::generateUrl('SellerOrders', 'rental');
                            }
                            $data = [
                                'adminLangId' => $adminLangId,
                                'statusButtons' => false,
                                'deleteButton' => false,
                                // 'otherButtons' => [
                                //     [
                                //         'attr' => [
                                //             'href' => $backUrl,
                                //             'title' => Labels::getLabel('LBL_BACK', $adminLangId)
                                //         ],
                                //         'label' => '<i class="fas fa-arrow-left"></i>'
                                //     ],
                                // ]
                            ];

                            $data['otherButtons'][] = [
                                'attr' => [
                                    'href' => Fatutility::generateUrl('sellerOrders', 'viewInvoice', [$order['op_id']]),
                                    'target' => '_blank',
                                    'title' => Labels::getLabel('LBL_Print_Order_Detail', $adminLangId)
                                ],
                                'label' => '<svg class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#print"></use></svg>'
                            ];

                            if (!$shippingHanldedBySeller && true === $canShipByPlugin && ('CashOnDelivery' == $order['plugin_code'] || Orders::ORDER_PAYMENT_PAID == $order['order_payment_status']) && $order['opshipping_type'] == Shipping::SHIPPING_SERVICES) {
                                $plugin = new Plugin();
                                $keyName = $plugin->getDefaultPluginKeyName(Plugin::TYPE_SHIPPING_SERVICES);

                                if (empty($order['opship_response']) && empty($order['opship_tracking_number']) && 'EasyPost' != $keyName) {
                                    $data['otherButtons'][] = [
                                        'attr' => [
                                            'href' => 'javascript:void(0)',
                                            'onclick' => 'generateLabel(' . $order['op_id'] . ')',
                                            'title' => Labels::getLabel('LBL_GENERATE_LABEL', $adminLangId)
                                        ],
                                        'label' => '<svg class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#icon-download"></use></svg>'
                                    ];
                                } elseif (!empty($order['opship_response']) && 'EasyPost' != $keyName) {
                                    $data['otherButtons'][] = [
                                        'attr' => [
                                            'href' => UrlHelper::generateUrl("ShippingServices", 'previewLabel', [$order['op_id']]),
                                            'target' => "_blank",
                                            'title' => Labels::getLabel('LBL_PREVIEW_LABEL', $adminLangId)
                                        ],
                                        'label' => '<svg class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#export"></use></svg>'
                                    ];
                                }

                                if ((!empty($orderStatus) && 'awaiting_shipment' == $orderStatus && !empty($order['opship_response']) || 'EasyPost' == $keyName) && empty($order['opship_tracking_number'])) {
                                    if ('EasyPost' == $keyName) {
                                        $label = Labels::getLabel('LBL_BUY_SHIPMENT_&_GENERATE_LABEL', $adminLangId);
                                    } else {
                                        $label = Labels::getLabel('LBL_PROCEED_TO_SHIPMENT', $adminLangId);
                                    }
                                    $data['otherButtons'][] = [
                                        'attr' => [
                                            'href' => 'javascript:void(0)',
                                            'onclick' => 'proceedToShipment(' . $order['op_id'] . ')',
                                            'title' => $label
                                        ],
                                        'label' => '<svg class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#truck"></use></svg>'
                                    ];
                                }
                            }

                            $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        }
                        ?>
                    </div>
                    <div class="card-body">
                        <?php /* echo "<pre>"; print_r($order); echo "</pre>";  */ ?>
                        <!-- <table class="table table-details"> -->
                        <div class="listview listview-3">
                            <?php
                            $fldKeys = [
                                'op_invoice_number' => Labels::getLabel('LBL_Invoice_Id', $adminLangId),
                                'order_date_added' => Labels::getLabel('LBL_Order_Date', $adminLangId),
                                'orderstatus_name' => Labels::getLabel('LBL_Status', $adminLangId),
                                'buyer_user_name' => Labels::getLabel('LBL_Customer/Guest', $adminLangId),
                                'selected_method' => Labels::getLabel('LBL_Payment_Method', $adminLangId),
                                'op_refund_qty' => Labels::getLabel('LBL_Refund_for_Qty.', $adminLangId) . '[' . $order["op_refund_qty"] . ']',
                                'op_commission_row' => Labels::getLabel('LBL_Commission_Charged', $adminLangId) . '[' . $order["op_commission_percentage"] . '%] <a href="javascript:void(0);" onClick="showBreakdownPopup(this);"  data-target="#commsion--js"><svg class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#question"></use></svg></a>',
                                'delivery_shipping' => Labels::getLabel('LBL_Delivery/Shipping', $adminLangId),
                                'tax_row' => Labels::getLabel('LBL_Tax', $adminLangId),
                                'cart_total' => Labels::getLabel('LBL_Cart_Total', $adminLangId),
                                'volumn_discount' => Labels::getLabel('LBL_Volume_Discount', $adminLangId),
                                'duration_discount' => Labels::getLabel('LBL_Duration_Discount', $adminLangId),
                                'op_rounding_off' => Labels::getLabel('LBL_Rounding_Down', $adminLangId),
                                'net_amount' => Labels::getLabel('LBL_Total_Paid', $adminLangId),
                                'pickup_row' => Labels::getLabel('LBL_Pickup_Date', $adminLangId),
                                'late_charges' => Labels::getLabel('LBL_Late_Charges', $adminLangId)
                            ];
                            if($order['op_pending_amount'] > 0){
                                $fldKeys['net_amount'] = Labels::getLabel('LBL_Total_Order_Amount', $adminLangId);
                                $fldKeys['paid_amount'] = Labels::getLabel('LBL_Total_Paid', $adminLangId);
                                $fldKeys['pending_amount'] = Labels::getLabel('LBL_Pending_Amount', $adminLangId);
                            }
                            if (1 > $order["op_refund_qty"]) {
                                unset($fldKeys['op_refund_qty']);
                            }
                            if (!$shippingHanldedBySeller || $order["opshipping_fulfillment_type"] != Shipping::FULFILMENT_SHIP) {
                                unset($fldKeys['delivery_shipping']);
                            }
                            if (!$order['op_tax_collected_by_seller']) {
                                unset($fldKeys['tax_row']);
                            }
                            if ($order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_SALE) {
                                unset($fldKeys['duration_discount']);
                            }
                            if ($order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {
                                unset($fldKeys['volumn_discount']);
                            }
                            $roundingOff = (array_key_exists('op_rounding_off', $order)) ? $order['op_rounding_off'] : 0;
                            if ($roundingOff == 0) {
                                unset($fldKeys['op_rounding_off']);
                            }

                            if ($order["opshipping_fulfillment_type"] != Shipping::FULFILMENT_PICKUP || $order["order_is_rfq"] == applicationConstants::YES || $order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {
                                unset($fldKeys['pickup_row']);
                            }
                            $lateCharges = $order['charge_total_amount'] + $serviceTotalPriceArr['late_charges_total'];
                            if (0 >= $lateCharges) {
                                unset($fldKeys['late_charges']);
                            }

                            $keyIndex = 0;
                            foreach ($fldKeys as $key => $fldKey) {
                                if ($keyIndex == 0) {
                                    echo "<tr>";
                                }

                                if ($keyIndex % 3 == 0 && $keyIndex != 0) {
                                    echo "</tr><tr>";
                                }
                                $value = "";
                                switch (strtolower($key)) {
                                    case 'order_payment_status':
                                        $value = $order["orderstatus_name"];
                                        if (Orders::ORDER_PAYMENT_CANCELLED == $order["order_payment_status"]) {
                                            $value = Orders::getOrderPaymentStatusArr($adminLangId)[$order["order_payment_status"]];
                                        }
                                        break;
                                    case 'buyer_user_name':
                                        $userName = "<a href='javascript:void(0)' class='link-underline link-brand' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $order['order_user_id'] . ")'>" . $order['buyer_user_name'] . "</a>";
                                        $value = $userName . ' (' . $order['buyer_username'] . ')';
                                        break;
                                    case 'selected_method':
                                        if (empty($selected_method)) {
                                            $value = Labels::getLabel('LBL_Other', $adminLangId);
                                        } else {
                                            $value = $selected_method;
                                        }
                                        break;
                                    case 'op_commission_row':
                                        $value = $order['op_commission_charged'] - $order['op_refund_commission'];

                                        $addonCommission = 0;
                                        foreach ($orderProducts as $key => $val) {
                                            if ($val['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON && $val['op_attached_op_id'] == $order['op_id']) {
                                                if ($val['op_qty'] - $val['op_refund_qty'] == 0) {
                                                    $addonCommission = ($val['op_unit_price'] * $val['op_commission_percentage'] / 100);
                                                } else {
                                                    $addonCommission = ($val['op_unit_price'] * $val['op_commission_percentage'] / 100) * ($val['op_qty'] - $val['op_refund_qty']);
                                                }

                                                $value += $addonCommission;
                                            }
                                        }

                                        $productComm = ($order['op_unit_price'] * $order['op_commission_percentage'] / 100) * ($order['op_qty'] - $order['op_refund_qty']);

                                        $productCommTxt = CommonHelper::displayMoneyFormat($productComm, true, true);
                                        if (!empty($penaltyPercentage)) {
                                            $productCommUpt = $productComm - ($productComm * $penaltyPercentage) / 100;
                                            $value -= ($productComm * $penaltyPercentage) / 100;
                                            $productCommTxt = '<span class="text-decoration-line-through">' . CommonHelper::displayMoneyFormat($productComm, true, true) . '</span> ' . CommonHelper::displayMoneyFormat($productCommUpt, true, true);
                                        }
                                        $commisionHtml = '<tr><th>' . Labels::getLabel('LBL_Product_Amount', $adminLangId) . '</th><td>' . $productCommTxt . '</td></tr>';

                                        if (!empty($addonCommission)) {
                                            $commisionHtml .= '<tr><th>' . Labels::getLabel('LBL_Product_Addons', $adminLangId) . '</th><td>' . CommonHelper::displayMoneyFormat($addonCommission, true, true) . '</td></tr>';
                                        }

                                        if ($order['op_commission_include_shipping'] && $shippingHanldedBySeller) {
                                            $shippingCost = CommonHelper::orderProductAmount($order, 'SHIPPING') / $order['op_qty'];
                                            if (!empty($order['op_refund_shipping'])) {
                                                $shippingCost = $shippingCost - $order['op_refund_shipping'];
                                            }
                                            $shipcmmission = ($shippingCost * $order['op_commission_percentage'] / 100) * (empty($order['op_qty'] - $order['op_refund_qty']) ? 1 : $order['op_qty'] - $order['op_refund_qty']);
                                            $shipcmmissionTxt = CommonHelper::displayMoneyFormat($shipcmmission, true, true);
                                            if (!empty($penaltyPercentage)) {
                                                $shipcmmissionUpt = 0;
                                                $value -= $shipcmmission;
                                                $shipcmmissionTxt = '<span class="text-decoration-line-through">' . CommonHelper::displayMoneyFormat($shipcmmission, true, true) . '</span> ' . CommonHelper::displayMoneyFormat($shipcmmissionUpt, true, true);
                                            }
                                            $commisionHtml .= '<tr><th>' . Labels::getLabel('LBL_Shipping', $adminLangId) . '</th><td>' . $shipcmmissionTxt . '</td></tr>';
                                        }

                                        if ($order['op_commission_include_tax'] && $order['op_tax_collected_by_seller']) {

                                            $addonCommissionTax = 0;
                                            foreach ($orderProducts as $key => $val) {
                                                if ($val['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON && $val['op_attached_op_id'] == $order['op_id']) {

                                                    $taxCostTemp = CommonHelper::orderProductAmount($val, 'TAX') / $val['op_qty'];
                                                    $addonCommissionTax = ($taxCostTemp * $val['op_commission_percentage'] / 100) * ($val['op_qty'] - $val['op_refund_qty']);

                                                    $value += $addonCommissionTax;
                                                }
                                            }

                                            if ($order['op_commission_include_tax'] && $order['op_tax_collected_by_seller']) {

                                                $addonCommissionTax = 0;
                                                foreach ($orderProducts as $key => $val) {
                                                    if ($val['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON && $val['op_attached_op_id'] == $order['op_id']) {

                                                        $taxCostTemp = CommonHelper::orderProductAmount($val, 'TAX') / $val['op_qty'];
                                                        $addonCommissionTax = ($taxCostTemp * $val['op_commission_percentage'] / 100) * ($val['op_qty'] - $val['op_refund_qty']);

                                                        $value += $addonCommissionTax;
                                                    }
                                                }
                                                $taxCost = CommonHelper::orderProductAmount($order, 'TAX') / $order['op_qty'];
                                                $taxcmmission = ($taxCost * $order['op_commission_percentage'] / 100) * ($order['op_qty'] - $order['op_refund_qty']);
                                                $taxcmmissionTxt = CommonHelper::displayMoneyFormat($taxcmmission, true, true);
                                                if (!empty($penaltyPercentage)) {
                                                    $taxcmmissionUpt = $taxcmmission - ($taxcmmission * $penaltyPercentage) / 100;
                                                    $value -= ($taxcmmission * $penaltyPercentage) / 100;

                                                    $taxcmmissionTxt = '<span class="text-decoration-line-through">' . CommonHelper::displayMoneyFormat($taxcmmission, true, true) . '</span> ' . CommonHelper::displayMoneyFormat($taxcmmissionUpt, true, true);
                                                }
                                                $commisionHtml .= '<tr><th>' . Labels::getLabel('LBL_Tax', $adminLangId) . '</th><td>' . $taxcmmissionTxt . '</td></tr>';
                                                if (!empty($addonCommissionTax)) {
                                                    $commisionHtml .= '<tr><th>' . Labels::getLabel('LBL_Addon_Tax', $adminLangId) . '</th><td>' . CommonHelper::displayMoneyFormat($addonCommissionTax, true, true) . '</td></tr>';
                                                }

                                            }

                                        }

                                        if ($order['op_commission_on_security']) {
                                            if (!isset($order['refund_security_amount']) || empty($order['refund_security_amount'])) {
                                                $order['refund_security_amount'] = 0;
                                            }
                                            $remaingSecAmt = ($order['opd_rental_security'] * $order['op_qty']) - $order['opd_refunded_security_amount'] ?? 0;
                                            $secCommission = $remaingSecAmt * $order['op_commission_percentage'] / 100;

                                            $commisionHtml .= '<tr><th>' . Labels::getLabel('LBL_REntal_Security', $adminLangId) . '</th><td>' . CommonHelper::displayMoneyFormat($secCommission, true, true) . '</td></tr>';
                                        }

                                        $value = CommonHelper::displayMoneyFormat($value, true, true);
                                        $commisionHtml .= '<tr><th>' . Labels::getLabel('LBL_Total_Commission', $adminLangId) . '</th><td>' . $value . '</td></tr>';

                                        break;
                                    case 'op_refund_qty':
                                        $value = CommonHelper::displayMoneyFormat($order["op_refund_amount"], true, true);
                                        break;
                                    case 'pending_amount':
                                        $value = CommonHelper::displayMoneyFormat($order["op_pending_amount"], true, true);
                                        break;
                                    case 'paid_amount':
                                        $value = CommonHelper::displayMoneyFormat($total_paid_amount, true, true);
                                        break;    
                                    case 'cart_total':
                                        $value = CommonHelper::displayMoneyFormat((CommonHelper::orderProductAmount($order, 'CART_TOTAL') + $serviceTotalPriceArr['cart_total']), true, true);
                                        break;
                                    case 'delivery_shipping':
                                        $value = '+' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'SHIPPING'), true, true);
                                        break;
                                    case 'tax_row':
                                        $totalTaxes = CommonHelper::orderProductAmount($order, 'TAX');
                                        if (!empty($serviceTotalPriceArr)) {
                                            $totalTaxes += $serviceTotalPriceArr['tax_total'];
                                        }
                                        $value = CommonHelper::displayMoneyFormat($totalTaxes, true, true);
                                        break;
                                    case 'volumn_discount':
                                        $value = CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'VOLUME_DISCOUNT'), true, true);
                                        break;
                                    case 'duration_discount':
                                        $value = CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($order, 'DURATION_DISCOUNT'), true, true);
                                        break;
                                    case 'net_amount':
                                        $value = CommonHelper::displayMoneyFormat((CommonHelper::orderProductAmount($order, 'netamount', false, User::USER_TYPE_SELLER) + $serviceTotalPriceArr['net_total']), true, true);
                                        break;
                                    case 'op_rounding_off':
                                        $fldKey = (0 < $order['op_rounding_off']) ? Labels::getLabel('LBL_Rounding_Up', $adminLangId) : Labels::getLabel('LBL_Rounding_Down', $adminLangId);
                                        $value = CommonHelper::displayMoneyFormat($order['op_rounding_off'], true, true);
                                        break;
                                    case 'pickup_row':
                                        $fromTime = date('H:i', strtotime($order["opshipping_time_slot_from"]));
                                        $toTime = date('H:i', strtotime($order["opshipping_time_slot_to"]));
                                        $value = FatDate::format($order["opshipping_date"]) . ' ' . $fromTime . ' - ' . $toTime;
                                        break;
                                    case 'late_charges':
                                        $value = CommonHelper::displayMoneyFormat(($order['charge_total_amount'] + $serviceTotalPriceArr['late_charges_total']));
                                        break;
                                    case 'orderstatus_name':
                                        $value = (isset($order[$key])) ? $order[$key] : "";
                                        if($order['op_pending_amount'] > 0){
                                            $value .= ' | '.Labels::getLabel('LBL_Partial_Paid', $adminLangId);
                                        }
                                        break;
                                    default:
                                        $value = (isset($order[$key])) ? $order[$key] : "";
                                        break;
                                }

                                /* echo '<td><strong>' . $fldKey . ' : </strong>' . $value . '</td>';
                                if ($keyIndex == (count($fldKeys) - 1)) {
                                    echo "</tr>";
                                }
                                $keyIndex++; */

                                echo '<dl class="list">
                                        <dt>'. $fldKey .'</dt>
                                        <dd>'. $value .'</dd>
                                    </dl>';
                            }
                            ?>
                        </div>
                        <!-- </table> -->
                    </div>
                </section>
                <div class="row row--cols-group">
                    <?php
                    $shipDetailColClass = 'col-lg-4';
                    if (!empty($order['shippingAddress']) || !empty($order['pickupAddress'])) {
                        $shipDetailColClass = 'col-lg-3';
                    }
                    ?>
                    <div class="<?php echo $shipDetailColClass; ?>">
                        <section class="card section">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Seller_Details', $adminLangId); ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <?php /* <h5><?php echo Labels::getLabel('LBL_Seller_Details', $adminLangId); ?>
                               </h5> */ ?>
                                    <p><strong><?php echo Labels::getLabel('LBL_Shop_Name', $adminLangId); ?> :
                                        </strong><?php echo "<a href='javascript:void(0)' class='link-underline link-brand' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $order['op_shop_id'] . ")'>" . $order['op_shop_name'] . "</a>"; ?><br><strong><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?>:
                                        </strong><?php echo "<a href='javascript:void(0)' class='link-underline link-brand' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $order['op_selprod_user_id'] . ")'>" . $order['op_shop_owner_name'] . "</a>"; ?><br><strong><?php echo Labels::getLabel('LBL_Email_ID', $adminLangId); ?>
                                            : </strong>
                                        <?php echo $order["op_shop_owner_email"] ?><br><strong><?php echo Labels::getLabel('LBL_Phone', $adminLangId); ?>
                                            : </strong>
                                        <?php echo $order['op_shop_owner_phone_code'] . ' ' . $order["op_shop_owner_phone"] ?>
                                    </p>
                                </div>
                            </div>
                        </section>
                    </div>

                    <div class="<?php echo $shipDetailColClass; ?>">
                        <section class="card section">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Customer_Details', $adminLangId); ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <?php /* <h5><?php echo Labels::getLabel('LBL_Customer_Details', $adminLangId); ?>
                               </h5> */ ?>
                                    <p><strong><?php echo Labels::getLabel('LBL_Name', $adminLangId); ?> :
                                        </strong><?php echo "<a href='javascript:void(0)' class='link-underline link-brand' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $order['buyer_user_id'] . ")'>" . $order['buyer_name'] . "</a>"; ?><br><strong><?php echo Labels::getLabel('LBL_UserName', $adminLangId); ?>:
                                        </strong><?php echo $order["buyer_username"]; ?><br><strong><?php echo Labels::getLabel('LBL_Email_ID', $adminLangId); ?>
                                            :
                                        </strong><?php echo $order["buyer_email"] ?><br><strong><?php echo Labels::getLabel('LBL_Phone', $adminLangId); ?>
                                            : </strong>
                                        <?php echo $order["user_dial_code"] . ' ' . $order["buyer_phone"] ?></p>
                                </div>
                            </div>
                        </section>
                    </div>

                    <div class="<?php echo $shipDetailColClass; ?>">
                        <section class="card section">
                            <div class="card-head">
                                <h4><?php echo Labels::getLabel('LBL_Billing_Details', $adminLangId); ?></h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <p><strong><?php echo $order['billingAddress']['oua_name']; ?></strong><br>
                                        <?php
                                        $billingAddress = '';
                                        if ($order['billingAddress']['oua_address1'] != '') {
                                            $billingAddress .= $order['billingAddress']['oua_address1'] . '<br>';
                                        }

                                        if ($order['billingAddress']['oua_address2'] != '') {
                                            $billingAddress .= $order['billingAddress']['oua_address2'] . '<br>';
                                        }

                                        if ($order['billingAddress']['oua_city'] != '') {
                                            $billingAddress .= $order['billingAddress']['oua_city'] . ',';
                                        }

                                        if ($order['billingAddress']['oua_zip'] != '') {
                                            $billingAddress .= ' ' . $order['billingAddress']['oua_state'];
                                        }

                                        if ($order['billingAddress']['oua_zip'] != '') {
                                            $billingAddress .= '-' . $order['billingAddress']['oua_zip'];
                                        }

                                        if ($order['billingAddress']['oua_phone'] != '') {
                                            $billingAddress .= '<br>' . Labels::getLabel('LBL_Phone:', $adminLangId) . ' ' . $order['billingAddress']['oua_dial_code'] . ' ' . $order['billingAddress']['oua_phone'];
                                        }
                                        echo $billingAddress;
                                        ?>
                                    </p>
                                </div>
                            </div>
                        </section>
                    </div>
                    <div class="<?php echo $shipDetailColClass; ?>">
                        <section class="card section">
                            <div class="card-head">

                                <h4><?php
                                if (!empty($order['pickupAddress'])) {
                                    echo Labels::getLabel('LBL_Pickup_Details', $adminLangId);
                                } else {
                                    echo Labels::getLabel('LBL_Shipping_Details', $adminLangId);
                                } ?>
                                </h4>
                            </div>
                            <div class="card-body">
                                <div class="address-group">
                                    <?php if (!empty($order['pickupAddress'])) { ?>
                                        <p>
                                            <?php if ($order['order_is_rfq'] == applicationConstants::NO && $order['opd_sold_or_rented'] != applicationConstants::PRODUCT_FOR_RENT) { ?>
                                                <strong>
                                                    <?php
                                                    $opshippingDate = isset($order['opshipping_date']) ? $order['opshipping_date'] . ' ' : '';
                                                    $timeSlotFrom = isset($order['opshipping_time_slot_from']) ? date('H:i', strtotime($order['opshipping_time_slot_from'])) . ' - ' : '';
                                                    $timeSlotTo = isset($order['opshipping_time_slot_to']) ? date('H:i', strtotime($order['opshipping_time_slot_to'])) : '';
                                                    echo $opshippingDate . ' (' . $timeSlotFrom . $timeSlotTo . ')';
                                                    ?>
                                                </strong><br>
                                            <?php } ?>
                                            <?php echo $order['pickupAddress']['oua_name']; ?>,
                                            <?php
                                            $pickupAddress = '';
                                            if ($order['pickupAddress']['oua_address1'] != '') {
                                                $pickupAddress .= $order['pickupAddress']['oua_address1'] . '<br>';
                                            }

                                            if ($order['pickupAddress']['oua_address2'] != '') {
                                                $pickupAddress .= $order['pickupAddress']['oua_address2'] . '<br>';
                                            }

                                            if ($order['pickupAddress']['oua_city'] != '') {
                                                $pickupAddress .= $order['pickupAddress']['oua_city'] . ',';
                                            }

                                            if ($order['pickupAddress']['oua_zip'] != '') {
                                                $pickupAddress .= ' ' . $order['pickupAddress']['oua_state'];
                                            }

                                            if ($order['pickupAddress']['oua_zip'] != '') {
                                                $pickupAddress .= '-' . $order['pickupAddress']['oua_zip'];
                                            }

                                            if ($order['pickupAddress']['oua_phone'] != '') {
                                                $pickupAddress .= '<br>' . Labels::getLabel('LBL_Phone:', $adminLangId) . ' ' . $order['pickupAddress']['oua_dial_code'] . ' ' . $order['pickupAddress']['oua_phone'];
                                            }
                                            echo $pickupAddress;

                                            ?>
                                        </p>
                                    <?php } else { ?>
                                        <p>
                                            <strong>
                                                <?php echo $order['shippingAddress']['oua_name']; ?></strong><br>
                                            <?php
                                            $shippingAddress = '';
                                            if ($order['shippingAddress']['oua_address1'] != '') {
                                                $shippingAddress .= $order['shippingAddress']['oua_address1'] . '<br>';
                                            }

                                            if ($order['shippingAddress']['oua_address2'] != '') {
                                                $shippingAddress .= $order['shippingAddress']['oua_address2'] . '<br>';
                                            }

                                            if ($order['shippingAddress']['oua_city'] != '') {
                                                $shippingAddress .= $order['shippingAddress']['oua_city'] . ',';
                                            }

                                            if ($order['shippingAddress']['oua_zip'] != '') {
                                                $shippingAddress .= ' ' . $order['shippingAddress']['oua_state'];
                                            }

                                            if ($order['shippingAddress']['oua_zip'] != '') {
                                                $shippingAddress .= '-' . $order['shippingAddress']['oua_zip'];
                                            }

                                            if ($order['shippingAddress']['oua_phone'] != '') {
                                                $shippingAddress .= '<br>' . Labels::getLabel('LBL_Phone:', $adminLangId) . ' ' . $order['shippingAddress']['oua_dial_code'] . ' ' . $order['shippingAddress']['oua_phone'];
                                            }
                                            echo $shippingAddress; ?>
                                        </p>
                                    <?php } ?>
                                </div>
                            </div>
                        </section>
                    </div>
                </div>
                <section class="card section">
                    <div class="card-head">
                        <h4><?php echo Labels::getLabel('LBL_Order_Details', $adminLangId); ?></h4>
                    </div>
                    <div class="card-table">
                        <div class="table-responsive table-scrollable js-scrollable tablewrap"> 
                            <table class="table table-hovered table-justified">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo Labels::getLabel('LBL_Product_Name', $adminLangId); ?></th>
                                        <?php if (!empty($order['shippingAddress']) && !empty($orderProducts) && Shipping::FULFILMENT_PICKUP != $orderProducts[0]['opshipping_fulfillment_type']) { ?>
                                            <th>
                                                <?php echo Labels::getLabel('LBL_Shipping_Details', $adminLangId); ?>
                                            </th>
                                        <?php } ?>
                                        <?php if ($orderProduct['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT && $orderProduct['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
											<th><?php echo Labels::getLabel('LBL_Rent_details', $adminLangId); ?></th>
										<?php } else { ?>
											<th><?php echo Labels::getLabel('LBL_Unit_Price', $adminLangId); ?></th>	
										<?php } ?>
										
                                        <?php if ($order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                                            <th>
                                                <?php echo Labels::getLabel('LBL_Security_Amount', $adminLangId); ?>
                                            </th>
                                        <?php } ?>
                                        <th><?php echo Labels::getLabel('LBL_Qty', $adminLangId); ?></th>

                                        <?php if ($shippingHanldedBySeller) { ?>
                                            <th><?php echo Labels::getLabel('LBL_Shipping', $adminLangId); ?></th>
                                        <?php } ?>
                                        <?php if ($order['op_tax_collected_by_seller']) { ?>
                                            <th><?php echo Labels::getLabel('LBL_Tax', $adminLangId); ?></th>
                                        <?php } ?>
                                        <th><?php echo Labels::getLabel('LBL_Volume/Duration_Discount', $adminLangId); ?>
                                        </th>
                                        <th><?php echo Labels::getLabel('LBL_Total', $adminLangId); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($orderProducts as $orderProduct) { ?>
                                        <tr>
                                            <td>#</td>
                                            <td>
                                                <?php
                                                $txt = '';
                                                if ($orderProduct['op_selprod_title'] != '') {
                                                    $txt .= $orderProduct['op_selprod_title'] . '<br/>';
                                                }
                                                $txt .= $orderProduct['op_product_name'];
                                                $txt .= '<br/>';
                                                if (!empty($orderProduct['op_brand_name'])) {
                                                    $txt .= Labels::getLabel('LBL_Brand', $adminLangId) . ': ' . $orderProduct['op_brand_name'];
                                                }
                                                if (!empty($orderProduct['op_brand_name']) && !empty($orderProduct['op_selprod_options'])) {
                                                    $txt .= ' | ';
                                                }
                                                if ($orderProduct['op_selprod_options'] != '') {
                                                    $txt .= $orderProduct['op_selprod_options'];
                                                }
                                                if ($orderProduct['op_selprod_sku'] != '') {
                                                    $txt .= '<br/>' . Labels::getLabel('LBL_SKU', $adminLangId) . ':  ' . $orderProduct['op_selprod_sku'];
                                                }
                                                if ($orderProduct['op_product_model'] != '') {
                                                    $txt .= '<br/>' . Labels::getLabel('LBL_Model', $adminLangId) . ':  ' . $orderProduct['op_product_model'];
                                                }
                                                echo $txt;
                                                ?>
                                            </td>
                                            <?php if (Shipping::FULFILMENT_PICKUP != $orderProduct['opshipping_fulfillment_type']) { ?>
                                                <td>
                                                    <?php if ($orderProduct['op_product_type'] == Product::PRODUCT_TYPE_PHYSICAL) { ?>
                                                        <strong>
                                                            <?php echo Labels::getLabel('LBL_Shipping_Class', $adminLangId); ?> :
                                                        </strong>
                                                        <?php echo CommonHelper::displayNotApplicable($adminLangId, $orderProduct["opshipping_label"]); ?><br>
                                                        <?php if (!empty($orderProduct["opshipping_service_code"])) { ?>
                                                            <strong>
                                                                <?php echo Labels::getLabel('LBL_SHIPPING_SERVICES', $adminLangId); ?> :
                                                            </strong>
                                                            <?php echo $orderProduct["opshipping_service_code"]; ?><br>
                                                        <?php } ?>
                                                        <?php if (!empty($orderStatusLbl)) { ?>
                                                            <strong>
                                                                <?php echo Labels::getLabel('LBL_ORDER_STATUS', $adminLangId); ?>:
                                                            </strong>
                                                            <?php echo ucwords($orderStatusLbl); ?>
                                                        <?php } ?>
                                                        <?php
                                                    } else {
                                                        echo Labels::getLabel('LBL_N/A', $adminLangId);
                                                    }
                                                    ?>
                                                </td>
                                            <?php } ?>
                                            <td>
                                                <?php
                                                if ($orderProduct['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT && $orderProduct['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) {
													echo Labels::getLabel('LBL_From:', $adminLangId) . ' ' . date('M d, Y H:i', strtotime($orderProduct['opd_rental_start_date'])) . '<br />' . Labels::getLabel('LBL_to', $adminLangId) . ': ' . date('M d, Y H:i', strtotime($orderProduct['opd_rental_end_date']));
                                                    //echo CommonHelper::displayMoneyFormat($orderProduct["opd_duration_price"], true, true);
                                                    $duration = CommonHelper::getDifferenceBetweenDates($orderProduct['opd_rental_start_date'], $orderProduct['opd_rental_end_date'], $orderProduct['op_selprod_user_id'], $orderProduct['opd_rental_type']);
                                                    $durationStr = CommonHelper::displayProductRentalDuration($duration, $orderProduct['opd_rental_type'], $adminLangId);
                                                    //echo '<br /><strong>' . Labels::getLabel('LBL_Rental_Price:', $adminLangId) . ' ' . CommonHelper::displayMoneyFormat($orderProduct['opd_rental_price']) . '&nbsp;<svg data-toggle="tooltip" title="Unit Price * Duration"  class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#info-circle"></use></svg>' . '</strong> <br />' . Labels::getLabel('LBL_Duration:', $adminLangId) . ' ' . $durationStr . '<br />' . Labels::getLabel('LBL_From:', $adminLangId) . ' ' . date('M d, Y', strtotime($orderProduct['opd_rental_start_date'])) . '<br />' . Labels::getLabel('LBL_to', $adminLangId) . ': ' . date('M d, Y', strtotime($orderProduct['opd_rental_end_date'])) . ') ';
                                                } else {
                                                    echo CommonHelper::displayMoneyFormat($orderProduct["op_unit_price"], true, true);
                                                }
                                                ?>
                                            </td>
                                            <?php if ($order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                                                <td>
                                                    <?php if (isset($parentorder) && !empty($parentorder)) {
                                                        echo CommonHelper::displayMoneyFormat($order['totalSecurityAmount'], true, true);
                                                        echo '&nbsp;<svg class="svg"  data-toggle="tooltip" title="' . Labels::getLabel('MSG_SHIFTED_FROM_PRIMARY_ORDER._NOT_INCLUDED_IN_CURRENT_ORDER_TOTAL_AMOUNT', $adminLangId) . ' " width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#info-circle"></use></svg>';
                                                    } else {
                                                        echo CommonHelper::displayMoneyFormat(($orderProduct["opd_rental_security"] * $orderProduct["op_qty"]), true, true);
                                                    }
                                                    ?>
                                                </td>
                                            <?php } ?>
                                            <td><?php echo $orderProduct["op_qty"] ?></td>
                                            <?php if ($shippingHanldedBySeller) { ?>
                                                <td><?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderProduct, 'SHIPPING'), true, true); ?>
                                                </td>
                                            <?php } ?>
                                            <?php if ($orderProduct['op_tax_collected_by_seller']) { ?>
                                                <td>
                                                    <?php
                                                    if (empty($orderProduct['taxOptions'])) {
                                                        echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderProduct, 'TAX'), true, true);
                                                    } else {
                                                        foreach ($orderProduct['taxOptions'] as $key => $val) {
                                                            ?>
                                                            <p>
                                                            <strong><?php echo CommonHelper::displayTaxPercantage($val, true) ?> :
                                                                </strong>
                                                                <?php echo CommonHelper::displayMoneyFormat($val['value']); ?>
                                                            </p>
                                                            <?php
                                                        }
                                                    }
                                                    ?>
                                                </td>
                                            <?php } ?>
                                            <td>
                                                <?php
                                                if ($orderProduct['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {
                                                    echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderProduct, 'DURATION_DISCOUNT'), true, true);
                                                } else {
                                                    echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderProduct, 'VOLUME_DISCOUNT'), true, true);
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <?php
                                                echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($orderProduct, 'netamount', false, User::USER_TYPE_SELLER), true, true);

                                                /* if ($roundingOff = CommonHelper::getRoundingOff($order)) {
                                            echo '(+' . $roundingOff . ')';
                                            } */
                                                ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </section>
                <?php
                if (!empty($verificationFldsData) && $order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {
                    $verificationData = [];
                    foreach ($verificationFldsData as $val) {
                        $verificationData[$val['ovd_vfld_id']][] = $val;
                    }
                    ?>
                    <section class="card section">
                        <div class="card-head">
                            <h4><?php echo Labels::getLabel('LBL_Verification_Data', $adminLangId); ?></h4>
                        </div>
                        <div class="card-table">
                            <div class="table-responsive table-scrollable js-scrollable tablewrap"> 
                                <table class="table table-hovered table-justified">
                                    <thead>
                                        <tr>
                                            <th width="33%"><?php echo Labels::getLabel('LBL_Field_Name', $adminLangId); ?>
                                            </th>
                                            <th width="33%"><?php echo Labels::getLabel('LBL_Field_Value', $adminLangId); ?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($verificationData as $key => $val) { ?>
                                            <tr>
                                                <td><?php echo $val[0]['ovd_vflds_name']; ?></td>
                                                <td><?php
                                                if ($val[0]['ovd_vflds_type'] == VerificationFields::FLD_TYPE_TEXTBOX) {
                                                    echo $val[0]['ovd_value'];
                                                } else {
                                                    $downloadUrl = UrlHelper::generateUrl('Orders', 'downloadAttachedFile', array($order['order_order_id'], $val[0]['ovd_vfld_id']), CONF_WEBROOT_BACKEND);
                                                    $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_VERIFICATION_ATTACHMENT, $order['order_order_id'], $val[0]['ovd_vfld_id']);
                                                    echo '<a download href="' . $downloadUrl . '"> ' . $file_row['afile_name'] . '</a>';
                                                }
                                                ?>
                                                </td>
                                            </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </section>
                <?php } ?>
                <?php

                    if(!empty($partialPaymentLog)){
                    ?>
                    <div class="row mt-5">
                        <div class="col-md-12">

                            <div class="card">
                                <div class="card-head"><h5 class="card-title"><?php echo Labels::getLabel('LBL_Payment_Log', $adminLangId); ?>   </div>
                                <div class="card-table">
                                <div class="table-responsive table-scrollable js-scrollable tablewrap">
                                    <table class="table table-justified">
                                        <thead>
                                            <tr>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Date', $adminLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Type', $adminLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Comment', $adminLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Txn_Id', $adminLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Amount', $adminLangId); ?>
                                                </th>
                                                
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            foreach($partialPaymentLog as $key => $val){
                                                ?>
                                                <tr>
                                                    <td>
                                                        <?php echo $val['oppl_created_at']; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $val['status_title']; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $val['oppl_comment']; ?>
                                                        <?php
                                                    $attachedFile = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_FLEXI_PAYMENT_ATTACHMENT, $val['oppl_id']);
                                                    if (!empty($attachedFile)) {
                                                        ?>
                                                         <?php
                                                        foreach ($attachedFile as $attach) {
                                                            ?>
                                                            <a class="actions-link" href="<?php echo UrlHelper::generateUrl('Account', 'downloadAttachedFileMsg', array(CommonHelper::encryptId($attach['afile_id']))); ?>" data-bs-toggle='tooltip' data-placement='top' data-original-title='<?php echo $attach['afile_name']; ?>' title='<?php echo $attach['afile_name']; ?>' download>
                       

                                                                <span data-bs-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $attach['afile_name']; ?>"><svg class='svg' width='28' height='28'>
                                                                <use xlink:href=' <?php echo CONF_WEBROOT_URL ?>images/retina/sprite.svg#dash-downloads'></use></svg></span>
                                                            </a>
                                                        <?php }
                                                    } ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $val['opayment_gateway_txn_id']; ?>
                                                    </td>
                                                    <td>
                                                        
                                                        <?php 
                                                        if($key == 0){
                                                            echo  CommonHelper::displayMoneyFormat(($val['oppl_amount']+$orderProduct['op_discount_total']), true, false, true, false, true) ; 
                                                            $txtCoupon = Labels::getLabel('MSG_Upfront_paid_%s_+_Discount_beared_by_platform_%s', $adminLangId);
                                                            $txtCoupon = sprintf($txtCoupon, CommonHelper::displayMoneyFormat($val['oppl_amount'], true, false, true, false, true), CommonHelper::displayMoneyFormat($orderProduct['op_discount_total'], true, false, true, false, true));
                                                            if($orderProduct['op_discount_total'] > 0){
                                                                echo '&nbsp;<svg width="14px" height="14px" data-toggle="tooltip" data-bs-html="true" data-placement="right" title="'.$txtCoupon.'" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 9.5C12.8284 9.5 13.5 8.82843 13.5 8C13.5 7.17157 12.8284 6.5 12 6.5C11.1716 6.5 10.5 7.17157 10.5 8C10.5 8.82843 11.1716 9.5 12 9.5ZM14 15H13V10.5H10V12.5H11V15H10V17H14V15Z"></path></svg>';
                                                            }
                                                        }else{
                                                            echo  CommonHelper::displayMoneyFormat($val['oppl_amount'], true, false, true, false, true) ; 
                                                        }
                                                        

                                                        ?>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                            ?>
                                        </tbody>
                                        </div>
                                </table></div>
                                </div>
                            </div>

                                
                            </div>
                        </div>
                        <?php } ?>
                <?php
                $orderCompleteExtended = false;
                if (!empty($order['comments']) && !$print) {
                    ?>
                    <section class="card section no-print">
                        <div class="card-head">
                            <h4><?php echo Labels::getLabel('LBL_Order_Comments', $adminLangId); ?></h4>
                        </div>
                        <div class="card-table">
                            <div class="table-responsive table-scrollable js-scrollable tablewrap">
                                <table class="table table-hovered">
                                    <tr>
                                        <th><?php echo Labels::getLabel('LBL_Date_Added', $adminLangId); ?></td>
                                        <th><?php echo Labels::getLabel('LBL_Customer_Notified', $adminLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Attached_Files', $adminLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Status', $adminLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Comments', $adminLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_Other_Details', $adminLangId); ?></th>
                                    </tr>
                                    <?php
                                    foreach ($order['comments'] as $row) {
                                        $attachedFiles = (isset($statusAttachedFiles) && isset($statusAttachedFiles[$row['oshistory_id']])) ? $statusAttachedFiles[$row['oshistory_id']] : [];
                                        if ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_RENTAL_EXTENDED) {
                                            $orderCompleteExtended = true;
                                        }
                                        ?>
                                        <tr>
                                            <td><?php echo FatDate::format($row['oshistory_date_added']); ?></td>
                                            <td><?php echo $yesNoArr[$row['oshistory_customer_notified']]; ?></td>
                                            <td style="width:30%;">
                                                <?php if (!empty($attachedFiles)) { ?>
                                                    <div>
                                                        <?php foreach ($attachedFiles as $attachedFile) { ?>
                                                            <a class="btn btn-outline-secondary btn-sm"
                                                                href="<?php echo UrlHelper::generateUrl('sellerOrders', 'downloadBuyerAtatchedFile', array($attachedFile['afile_record_id'], 0, $attachedFile['afile_id'])); ?>"
                                                                title="<?php echo $attachedFile['afile_name']; ?>"><svg class="svg"
                                                                    width="18" height="18">
                                                                    <use
                                                                        xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#icon-download">
                                                                    </use>
                                                                </svg>
                                                                <?php echo $attachedFile['afile_name']; ?></a>
                                                        <?php } ?>
                                                    </div>
                                                    <?php
                                                } else {
                                                    echo Labels::getLabel('LBL_N/A', $adminLangId);
                                                }
                                                ?>
                                            </td>
                                            <td>
                                                <p><?php
                                                if ($order['opshipping_fulfillment_type'] == Shipping::FULFILMENT_PICKUP && $row['oshistory_orderstatus_id'] == OrderStatus::ORDER_DELIVERED) {
                                                    $orderStatuses[$row['oshistory_orderstatus_id']] = Labels::getLabel('LBL_Picked', $adminLangId);
                                                }


                                                echo $orderStatuses[$row['oshistory_orderstatus_id']];

                                                if ($row['oshistory_orderstatus_id'] == FatApp::getConfig('CONF_DEFAULT_DEIVERED_ORDER_STATUS') && $row['oshistory_status_updated_by'] == $order['order_user_id']) {
                                                    echo ' - ' . Labels::getLabel('LBL_Marked_by_Buyer', $adminLangId);
                                                }
                                                if (FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) {

                                                    if ($order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {

                                                        if ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_SHIPPED && (!empty($order['checklistPoints']) && array_key_exists($row['oshistory_orderstatus_id'], $order['checklistPoints']))) {
                                                            ?>
                                                                <a class="btn btn-outline-secondary btn-sm" href="javascript:void(0);"
                                                                    onclick="showBreakdownPopup(this);"
                                                                    data-target="#shipping-checklist--js"><?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $adminLangId); ?></a>
                                                            <?php } else if ((Shipping::FULFILMENT_PICKUP == $order['opshipping_fulfillment_type'] && $row['oshistory_orderstatus_id'] == 7) && (!empty($order['checklistPoints']) && array_key_exists(7, $order['checklistPoints']))) { ?>
                                                                    <a class="btn btn-outline-secondary btn-sm" href="javascript:void(0);"
                                                                        onclick="showBreakdownPopup(this);"
                                                                        data-target="#shipping-checklist--js"><?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $adminLangId); ?></a>
                                                            <?php }

                                                        if ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_RENTAL_RETURNED && (!empty($order['checklistPoints']) && array_key_exists($row['oshistory_orderstatus_id'], $order['checklistPoints']))) {
                                                            ?>
                                                                <a class="btn btn-outline-secondary btn-sm" href="javascript:void(0);"
                                                                    onclick="showBreakdownPopup(this);"
                                                                    data-target="#rentalreturned-checklist--js"><?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $adminLangId); ?></a>
                                                            <?php }

                                                    }
                                                }
                                                ?>
                                                </p>
                                            </td>
                                            <td>
                                                <span> <?php echo html_entity_decode(nl2br($row['oshistory_comments'])); ?> </span>
                                            </td>
                                            <td>
                                                <?php 
                                                    if (isset($statusAddressData[$row['oshistory_id']])) {
                                                        $dropOffAddress = $statusAddressData[$row['oshistory_id']];
                                                        echo '<p><strong>' . Labels::getLabel('LBL_DROPOFF_ADDRESS', $adminLangId) . '</strong></p><address class="delivery-address"><h6>' . $dropOffAddress['addr_name'] . ' <span>' . $dropOffAddress['addr_title'] . '</span></h6><p>' . $dropOffAddress['addr_address1'] . '<br>' . $dropOffAddress['addr_city'] . ',' . $dropOffAddress['state_name'] . '<br>' . $dropOffAddress['country_name'] . '<br>' . Labels::getLabel("LBL_Zip", $adminLangId) . ': ' . $dropOffAddress['addr_zip'] . '<br><svg class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#mobile"></use></svg> ' . Labels::getLabel("LBL_Phone", $adminLangId) . ': ' . $dropOffAddress['addr_dial_code'] . ' ' . $dropOffAddress['addr_phone'] . '<br></p></address>';
                                                    }
                                                ?>
                                                <?php
                                                /* echo ' ' . (($row['oshistory_orderstatus_id'] > 0) ? $orderStatuses[$row['oshistory_orderstatus_id']] : CommonHelper::displayNotApplicable($adminLangId, '')) . ' '; */
                                                if ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_SHIPPED || $row['oshistory_orderstatus_id'] == OrderStatus::ORDER_READY_FOR_RENTAL_RETURN) {
                                                    if (empty($row['oshistory_courier'])) {
                                                        $str = !empty($row['oshistory_tracking_number']) ? ' <p> <strong>' . Labels::getLabel('LBL_Tracking_Number', $adminLangId) . '</strong> : ' . ' ' . $row['oshistory_tracking_number'] : '';
                                                        if (empty($order['opship_tracking_url']) && !empty($row['oshistory_tracking_number'])) {
                                                            $str .= " VIA <em>" . CommonHelper::displayNotApplicable($adminLangId, $order["opshipping_label"]) . "</em>";
                                                        } elseif (!empty($order['opship_tracking_url']) && !empty($row['oshistory_tracking_number'])) {
                                                            $str .= " <a class='btn btn-outline-secondary btn-sm' href='" . $order['opship_tracking_url'] . "' target='_blank'>" . Labels::getLabel("MSG_TRACK", $adminLangId) . "</a>";
                                                        }

                                                        $str .= '</p>';
                                                        echo $str;
                                                    } else {
                                                        echo "<p>";
                                                        echo ($row['oshistory_tracking_number']) ? '<strong>' . Labels::getLabel('LBL_Tracking_Number', $adminLangId) . '</strong> : ' : '';
                                                        $trackingNumber = $row['oshistory_tracking_number'];
                                                        $carrier = $row['oshistory_courier'];

                                                        if ($trackingPluginEnable && $row['oshistory_orderstatus_id'] != OrderStatus::ORDER_READY_FOR_RENTAL_RETURN) {
                                                            ?>
                                                            <a href="javascript:void(0)"
                                                                title="<?php echo Labels::getLabel('LBL_TRACK', $adminLangId); ?>"
                                                                onClick="trackOrder('<?php echo trim($trackingNumber); ?>', '<?php echo trim($carrier); ?>', '<?php echo $order["op_invoice_number"]; ?>')">
                                                                <?php echo $trackingNumber; ?>
                                                            </a>
                                                            <?php
                                                        } else {
                                                            echo $trackingNumber;
                                                            if (trim($row['oshistory_tracking_url']) != '') {
                                                                echo " <a class='btn btn-outline-secondary btn-sm' href='" . $row['oshistory_tracking_url'] . "'  target='_blank'>" . Labels::getLabel("MSG_TRACK", $adminLangId) . "</a>";
                                                            }
                                                        }

                                                        echo '</p>';

                                                        if ($row['oshistory_orderstatus_id'] != OrderStatus::ORDER_READY_FOR_RENTAL_RETURN) {
                                                            echo '<p> ' . Labels::getLabel('LBL_VIA', $adminLangId);
                                                            echo "<em>" . CommonHelper::displayNotApplicable($adminLangId, $order["opshipping_label"]) . "</em></p>";
                                                        }
                                                    }
                                                }
                                                
                                                ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </table>
                            </div>
                        </div>
                    </section>
                    <?php
                }

                if (!empty($attachment) && $order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {
                    ?>
                    <section class="card section">
                        <div class="card-head">
                            <h4><?php echo Labels::getLabel('LBL_Signature', $adminLangId); ?></h4>
                        </div>
                        <div class="card-body extra">
                            <img
                                src="<?php echo CommonHelper::generateUrl('Orders', 'downloadDigitalFile', [$attachment["afile_record_id"], $attachment['afile_id'], AttachedFile::FILETYPE_SIGNATURE_IMAGE]); ?>" />
                        </div>
                    </section>
                    <?php
                }

                if ($displayForm && !$print && ($completedOrderStatus != $order['op_status_id']) && $order['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                    <section class="card section no-print">
                        <div class="card-head">
                            <h4><?php echo Labels::getLabel('LBL_Comments_on_order', $adminLangId); ?></h4>
                        </div>
                        <div class="card-body extra">
                            <?php
                            if (isset($extendedChildData) && !empty($extendedChildData) && $orderCompleteExtended) {
                               /* echo '<div class="section--repeated no-print text-danger extend-order-section">' . HtmlHelper::getMessage(sprintf(Labels::getLabel('LBL_This_order_is_extended_.To_check_or_change_status_of_this_order_click_here_%s', $adminLangId), '<a href="' . CommonHelper::generateUrl('SellerOrders', 'view', array($extendedChildData['opd_op_id'])) . '">#' . $extendedChildData['opd_order_id'] . '</a>'), 'warning') . '</div>'; */

                                echo '<div class="section--repeated no-print text-danger extend-order-section">' . HtmlHelper::getMessage(Labels::getLabel('LBL_This_order_is_extended_.To_check_or_change_status_of_this_order_click_on_order_id', $adminLangId) . '<a href="' . CommonHelper::generateUrl('SellerOrders', 'view', array($extendedChildData['opd_op_id'])) . '">#' . $extendedChildData['opd_order_id'] . '</a>', 'warning') . '</div>';
                                
                            } else {
                                /* [ RENTAL UPDATES */
                                /*
                                $securityLabelHtml = '<small class="text--small form-text text-muted">' . sprintf(Labels::getLabel("LBL_Complete_security_amount_is_%s_._Owner's_recommendation_is_%s", $adminLangId), CommonHelper::displayMoneyFormat($order['totalSecurityAmount']), CommonHelper::displayMoneyFormat($order['recommended_security_refund'])) . '</small>'; */

                                $securityLabelHtml = '<small class="text--small form-text text-muted">' . Labels::getLabel("LBL_Complete_security_amount_is", $adminLangId) . ' ' . CommonHelper::displayMoneyFormat($order['totalSecurityAmount']) . ' , ' . Labels::getLabel("LBL_Owner's_recommendation_is", $adminLangId) . ' ' . CommonHelper::displayMoneyFormat($order['recommended_security_refund']) . '</small>';
                                /* ] */

                                $frm->setFormTagAttribute('onsubmit', 'updateStatus(this); return(false);');
                                $frm->setFormTagAttribute('class', 'form web_form markAsShipped-js');
                                $frm->developerTags['colClassPrefix'] = 'col-md-';
                                $frm->developerTags['fld_default_col'] = 6;

                                $cmtFld = $frm->getField('comments');
                                $cmtFld->setWrapperAttribute('id', 'comments_wrapper');
                                $cmtFld->developerTags['col'] = 12;


                                $statusFld = $frm->getField('op_status_id');
                                $statusFld->setFieldTagAttribute('class', 'status-js fieldsVisibility-js');

                                $notiFld = $frm->getField('customer_notified');
                                $notiFld->setFieldTagAttribute('class', 'notifyCustomer-js');

                                $fldTracking = $frm->getField('tracking_number');
                                $fld = $frm->getField('opship_tracking_url');
                                if (null != $fld) {
                                    $fld->setFieldTagAttribute('pattern', '^(https?|ftp):\/\/[^\s\/$.?#]+\.[^\s\/$.?#]+[^\s]*(\/[^\s\/$.?#]+\.[^\s\/$.?#]+[^\s]*)?$');
                                    $fld->setFieldTagAttribute('placeholder', 'https://example.com');
                                    $fld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel("LBL_Example", $adminLangId) . ' : https://example.com' . '</small>';
                                }

                                /* RENTAL UPDATES */
                                if ($order['opd_sold_or_rented'] == applicationConstants::PRODUCT_FOR_RENT) {
                                    $fldSecRefType = $frm->getField('refund_security_type');
                                    $fldSecRefType->setFieldTagAttribute('completeamount', $order['totalSecurityAmount']);
                                    $fldSecRefType->developerTags['col'] = 4;

                                    $fldSecAmnt = $frm->getField('refund_security_amount');
                                    $fldSecAmnt->htmlAfterField = $securityLabelHtml;
                                    $fldSecAmnt->requirements()->setRange(0, $order['maxSecurityAmount']);
                                    $fldSecAmnt->developerTags['col'] = 4;

                                    $returnDateFld = $frm->getField('opd_mark_rental_return_date');
                                    $returnDateFld->developerTags['col'] = 4;

                                    if ($order['opd_mark_rental_return_date'] != '0000-00-00 00:00:00' && $order['opd_mark_rental_return_date'] != "") {
                                        $returnDateFld->value = $order['opd_mark_rental_return_date'];
                                        $returnDateFld->setFieldTagAttribute('disabled', 'disabled');
                                        if ($order['charge_total_amount'] > 0) {
                                            $returnDateFld->htmlAfterField = "<small class='note'>" . Labels::getLabel("LBL_Note:_Late_Charges_will_be_applied", $adminLangId) . ' ' . CommonHelper::displayMoneyFormat($order['charge_total_amount'], true, false) . "</small>";
                                        }
                                    } else {
                                        $returnDateFld->value = date('Y-m-d h:i:s');
                                        if (strtotime($order['opd_rental_end_date']) < strtotime(date('Y-m-d h:i:s'))) {
                                            $returnDateFld->htmlAfterField = "<small class='note'>" . Labels::getLabel("LBL_Note:_Late_Charges_May_be_apply", $adminLangId) . "</small>";
                                        }
                                    }


                                    if ($completedOrderStatus != $order['op_status_id']) {
                                        $fldSecRefType->setWrapperAttribute('class', 'div_refund_security');
                                        $fldSecAmnt->setWrapperAttribute('class', 'div_refund_security');
                                        $returnDateFld->setWrapperAttribute('class', 'div_refund_security');
                                    }
                                }
                                /* ] */
                                echo $frm->getFormHtml();
                            }
                            ?>
                        </div>
                    </section>
                <?php } ?>
            </div>
        </div>
    </div>
</div>
<?php if (FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>

    <?php if ((Shipping::FULFILMENT_PICKUP == $order['opshipping_fulfillment_type']) && (!empty($order['checklistPoints']) && array_key_exists(7, $order['checklistPoints']))) { ?>
        <div id="shipping-checklist--js" style="display: none;">
            <?php if (!empty($order['checklistPoints'][OrderStatus::ORDER_DELIVERED])) { ?>
                <table class="table table-bordered table-justified">
                    <thead>
                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $adminLangId); ?></th>
                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $adminLangId); ?></th>
                    </thead>
                    <tbody>

                        <?php
                        foreach ($order['checklistPoints'][OrderStatus::ORDER_DELIVERED] as $sku => $selectedChecklistPoints) {
                            $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                            ?>
                            <tr>
                                <td>
                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                </td>
                                <td>
                                    <span class="value"><?php echo $value; ?></span>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                    </tbody>
                </table>
            <?php } ?>
        </div>
    <?php } ?>

    <?php if (!empty($order['checklistPoints']) && array_key_exists(OrderStatus::ORDER_SHIPPED, $order['checklistPoints'])) { ?>
        <div id="shipping-checklist--js" style="display: none;">
            <?php if (!empty($order['checklistPoints'][OrderStatus::ORDER_SHIPPED])) { ?>
                <table class="table table-bordered table-justified">
                    <thead>
                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $adminLangId); ?></th>
                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $adminLangId); ?></th>
                    </thead>
                    <tbody>

                        <?php
                        foreach ($order['checklistPoints'][OrderStatus::ORDER_SHIPPED] as $sku => $selectedChecklistPoints) {
                            $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                            ?>
                            <tr>
                                <td>
                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                </td>
                                <td>
                                    <span class="value"><?php echo $value; ?></span>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                    </tbody>
                </table>
            <?php } ?>
        </div>
    <?php } ?>

    <?php if (!empty($order['checklistPoints']) && array_key_exists(OrderStatus::ORDER_RENTAL_RETURNED, $order['checklistPoints'])) { ?>
        <div id="rentalreturned-checklist--js" style="display: none;">
            <?php if (!empty($order['checklistPoints'][OrderStatus::ORDER_RENTAL_RETURNED])) { ?>
                <table class="table table-bordered table-justified">
                    <thead>
                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $adminLangId); ?></th>
                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $adminLangId) . ' (' . Labels::getLabel('LBL_SHIPPED', $adminLangId) . ')'; ?>
                        </th>
                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $adminLangId) . ' (' . Labels::getLabel('LBL_RENTAL_RETURNED', $adminLangId) . ')'; ?>
                        </th>
                    </thead>
                    <tbody>

                        <?php
                        foreach ($order['checklistPoints'][OrderStatus::ORDER_RENTAL_RETURNED] as $key => $selectedChecklistPoints) {

                            $shippedValue = "";
                            if (array_key_exists(OrderStatus::ORDER_SHIPPED, $order['checklistPoints'])) {
                                if ($order['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['cp_type'] == ChecklistPoint::CHECKLISTTYPE_CHECKBOXES) {
                                    $shippedValue = implode(', ', explode(PHP_EOL, $order['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['opcp_cp_value']));
                                } else {
                                    $shippedValue = $order['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['opcp_cp_value'];
                                }
                            }

                            $value = "";
                            if ($selectedChecklistPoints['cp_type'] == ChecklistPoint::CHECKLISTTYPE_CHECKBOXES) {
                                $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                            } else {
                                $value = $selectedChecklistPoints['opcp_cp_value'];
                            }
                            ?>
                            <tr>
                                <td>
                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                </td>
                                <td>
                                    <?php if (!empty($shippedValue)) { ?>
                                        <span class="value"><?php echo $shippedValue; ?></span>
                                    <?php } ?>
                                </td>
                                <td>
                                    <span class="value"><?php echo $value; ?></span>
                                </td>
                            </tr>
                            <?php
                        }
                        ?>
                    </tbody>
                </table>
            <?php } ?>
        </div>
    <?php } ?>

<?php } ?>

<div id="commsion--js" style="display: none;" data-title="<?php echo Labels::getLabel("LBL_Commission_Details", $adminLangId); ?>">
    <table class="table table-bordered table-justified">
        <tbody>
            <?php echo $commisionHtml; ?>
        </tbody>

    </table>
</div>
<div id="rental-price--js" style="display: none;">
    <table class="table table-bordered table-justified">
        <thead>
            <tr class="text-center">
                <th colspan="2"><?php echo Labels::getLabel("LBL_Commission_Details", $adminLangId); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php echo $commisionHtml; ?>
        </tbody>

    </table>
</div>
<?php if ($print) { ?>
    <script>
        window.print();
        window.onafterprint = function () {
            location.href = history.back();
        }
    </script>
<?php } ?>

<script>
    var canShipByPlugin = <?php echo (true === $canShipByPlugin ? 1 : 0); ?>;
    var orderShippedStatus = <?php echo OrderStatus::ORDER_SHIPPED; ?>;
    trackOrder = function (trackingNumber, courier, orderNumber) {
        $.bootstrapModal(function () {
            fcom.ajax(fcom.makeUrl('SellerOrders', 'orderTrackingInfo', [trackingNumber, courier, orderNumber]),
                '',
                function (res) {
                    $.bootstrapModal(res);
                    $(".medium-fb-width").parent('.popup').addClass('h-min-auto');
                });
        });
    };
</script>
<?php if ($order['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT && FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>
    <script>
        var PRODUCT_CATEGORY_ID = <?php echo $order['prodcat_id']; ?>;
        var SHIPPED_STATUS_ID = <?php echo OrderStatus::ORDER_SHIPPED; ?>;
        var DELIVERED_STATUS_ID = <?php echo OrderStatus::ORDER_DELIVERED; ?>;
        var RENTAL_RETURNED_STATUS_ID = <?php echo OrderStatus::ORDER_RENTAL_RETURNED; ?>;
        $("select[name='op_status_id']").change(function () {
            requiredChecklist = false;
            let selectedStatusId = $("select[name='op_status_id']").val();
            if (selectedStatusId == SHIPPED_STATUS_ID || selectedStatusId == DELIVERED_STATUS_ID || selectedStatusId ==
                RENTAL_RETURNED_STATUS_ID) {
                var data = {
                    selectedStatusId: selectedStatusId,
                    opId: $("input[name='op_id']").val(),
                    prodCatId: PRODUCT_CATEGORY_ID,
                    parentOpID: $("input[name='opd_extend_from_op_id']").val(),
                };
                fcom.ajax(fcom.makeUrl('SellerOrders', 'getChecklistPoints'), data, function (t) {
                    var response = $.parseJSON(t);
                    $("#checklist_points").remove();
                    if (response && Object.keys(response.checklistData).length > 0) {
                        requiredChecklist = true;
                        $("#comments_wrapper").closest('.row').after(response.html);
                    }
                });
            } else {
                $("#checklist_points").remove();
            }
        });
    </script>
<?php } ?>
<style>
    .disabled-input {
        color: rgba(0, 0, 0, 0.38) !important;
        background-color: rgba(0, 0, 0, 0.05) !important;
        box-shadow: none;
        cursor: initial;
        border: transparent !important;
    }

    .sub-heading {
        font-size: 60%;
        text-align: right;
    }

    #checklist_options .checklist-fld-body .field-set {
        display: inline-block;
    }

    #checklist_options .checklist-fld-body .field-wraper {
        display: inline-block;
        margin-left: 2rem;
    }

    #returned_checklist_points_modal .modal-content,
    #shipped_checklist_points_modal .modal-content {
        max-height: 660px;
    }

    #returned_checklist_points_modal .modal-body,
    #shipped_checklist_points_modal .modal-body {
        overflow: auto;
    }

    #checklist_options .field-wraper {
        align-content: center;
    }

    .table tr td {
        position: relative;
        max-width: 5rem;
    }

    .table .sku-heading {
        font-weight: 600;
        line-height: 0.5;
        background: #efefef;
    }

    .checklist-fld-body {
        padding: 0.5rem;
        display: flex;
    }

    .checklist-form-section {
        background-color: #f2f7ff;
        margin-top: 15px;
        padding: 0.5rem;
    }

    .checklist-form-section .form-heading {
        font-weight: 600;
    }
</style>