<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
    <?php
    $arr_flds = array(
        'op_invoice_number' => Labels::getLabel('LBL_Invoice_Number', $adminLangId),
        'buyer_name' => Labels::getLabel('LBL_Buyer', $adminLangId),
        'order_amount' => Labels::getLabel('LBL_Total_Amount', $adminLangId),
        'refundable_amount' => Labels::getLabel('LBL_Refundable_Amount', $adminLangId),
        'earning' => Labels::getLabel('LBL_Seller_Earning', $adminLangId),
        'commission' => Labels::getLabel('LBL_Commission', $adminLangId),
        'rental_details' => Labels::getLabel('LBL_Details', $adminLangId),
        'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
    );
    /* $tableClass = '';
    if (0 < count($chargesListing)) { */
    $tableClass = "table-justified";
    /* } */
    $tbl = new HtmlElement('table', array('class' => 'table ' . $tableClass));
    $th = $tbl->appendElement('thead')->appendElement('tr', array('class' => ''));
    foreach ($arr_flds as $val) {
        $e = $th->appendElement('th', array(), $val);
    }

    $sr_no = 0;
    foreach ($chargesListing as $sn => $row) {
        $sr_no++;
        $tr = $tbl->appendElement('tr', array('class' => ''));

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            if($row['op_upfront_percentage'] != 100 && $row['op_id'] > 0){
                $orderTotalAmount = OrderProduct::getOrderProductPaidAmount($row['op_id']);
            }else{
                $orderTotalAmount = CommonHelper::orderProductAmount($row, 'netamount', false, User::USER_TYPE_SELLER);
            }
            


            $netAmount = $orderTotalAmount;
            $shippingCharges = $row['shipping_charges'];
            if($row['op_upfront_percentage'] != 100 && $row['op_id'] > 0){
                $orderTotalAmount = OrderProduct::getOrderProductPaidAmount($row['op_id'])- ($row['opd_rental_security'] * $row['op_qty']) - $shippingCharges;
            }else{
                $orderTotalAmount = CommonHelper::orderProductAmount($row, 'netamount') - ($row['opd_rental_security'] * $row['op_qty']) - $shippingCharges;
            }
            $refunableAmount = ($orderTotalAmount * $row['ocrequest_refund_amount'] / 100) + $shippingCharges + ($row['opd_rental_security'] * $row['op_qty']);

            switch ($key) {
                case 'op_invoice_number':
                    $td->appendElement('plaintext', array(), '#' . $row['op_invoice_number'], true);
                    break;
                case 'action':
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_View_Order_Detail', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                            "href" => UrlHelper::generateUrl('SellerOrders', 'view', array($row['op_id']))
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['op_id']], false);
                    break;
                case 'buyer_name':
                    $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['user_id'] . ')'), $row['buyer_name'], true);
                    break;
                case 'refundable_amount':
                    // $breakpointsHtml = '<div style=\'min-width:300px;\'><span>'. Labels::getLabel('LBL_Security_Amont', $adminLangId) .' : '. CommonHelper::displayMoneyFormat($row['opd_rental_security'] * $row['op_qty']) .'</span><br><span>'. Labels::getLabel('LBL_Shipping_Charges', $adminLangId) .' :  '. CommonHelper::displayMoneyFormat($shippingCharges) .'</span><br /><span>'. Labels::getLabel('LBL_Rental_Amount', $adminLangId) .'('. $row['ocrequest_refund_amount'].'%) : '. CommonHelper::displayMoneyFormat($orderTotalAmount * $row['ocrequest_refund_amount'] / 100) .'</span></div>';
                    $breakpointsHtml = Labels::getLabel('LBL_Security_Amont', $adminLangId) . ' : ' . CommonHelper::displayMoneyFormat($row['opd_rental_security'] * $row['op_qty']) . "\n" . Labels::getLabel('LBL_Shipping_Charges', $adminLangId) . ' :  ' . CommonHelper::displayMoneyFormat($shippingCharges) . "\n" . Labels::getLabel('LBL_Rental_Amount', $adminLangId) . '(' . $row['ocrequest_refund_amount'] . '%) : ' . CommonHelper::displayMoneyFormat($orderTotalAmount * $row['ocrequest_refund_amount'] / 100);
                    $str = CommonHelper::displayMoneyFormat($refunableAmount) . ' <span><svg class="svg" data-toggle="tooltip" data-placement="right" title="' . $breakpointsHtml . '" data-html="true" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#info-circle"></use></svg></span>';
                    $td->appendElement('span', array(), $str, true);
                    break;
                case 'earning':
                    $str = CommonHelper::displayMoneyFormat($netAmount - $refunableAmount);
                    $td->appendElement('span', array(), $str, true);
                    break;
                case 'commission':
                    $commission = ($netAmount - $refunableAmount) * $row['op_commission_percentage'] / 100;
                    if ($commission > 0) {
                        $str = '<a href="javascript:void(0);" data-toggle="tooltip" data-placement="right" data-original-title="' . $row['op_commission_percentage'] . '%" >' . CommonHelper::displayMoneyFormat($commission) . '</a>';
                    } else {
                        $str = CommonHelper::displayMoneyFormat($commission);
                    }


                    $td->appendElement('span', array(), $str, true);
                    break;

                case 'rental_details':

                    $date = FatDate::format($row['opd_rental_start_date'], true);
                    $dateHtml = "";
                    if (strpos($date, ' ') !== false) {
                        list($formattedDate, $formattedTime) = explode(' ', $date);
                        $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                    } else {
                        $dateHtml = "<date class='date'>" . $date . "</date>";
                    }

                    $str = Labels::getLabel('LBL_Order_rental_start_date_is', $adminLangId) . ' ' . $dateHtml ;
                    $str .= '<br>' . Labels::getLabel('LBL_Order_Cancelled_Before', $adminLangId) . ' : ' . $row['ocrequest_hours_before_rental'] . ' ' . Labels::getLabel('LBL_hour(s)', $adminLangId) ;;
                    $td->appendElement('plaintext', array(), $str, true);
                    break;
                case 'order_amount':
                    $str = CommonHelper::displayMoneyFormat($netAmount);
                    $td->appendElement('span', array(), $str, true);
                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }
    }


    echo $tbl->getHtml();
    if (count($chargesListing) == 0) {
        $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
    }
?>
</div>
<?php
    $postedData['page'] = $page;
    echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmPenaltySrchPaging'));
    $pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
    $this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>
<script>
    $(function () {
        $('[data-toggle="tooltip"]').tooltip()
    })    
</script>