<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-6">

                            <h5><?php echo Labels::getLabel('LBL_Sales_Report', $adminLangId); ?>
                            </h5>
                            <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                        </div>
                    </div>
                </div>
                <?php if (empty($orderDate)) { ?>
                    <section class="card searchform_filter advance-search">
                        <div class="card-head">
                            <h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?>
                            </h4>
                        </div>
                        <div class="card-body extra togglewrap">
                            <?php
                            $frmSearch->setFormTagAttribute('onsubmit', 'searchSalesReport(this); return(false);');
                            $frmSearch->setFormTagAttribute('class', 'form web_form');
                            $frmSearch->developerTags['colClassPrefix'] = 'col-md-';
                            $frmSearch->developerTags['fld_default_col'] = 4;
                            $btn_submit = $frmSearch->getField('btn_submit');
                            $btn_submit->developerTags['noCaptionTag'] = false;
                            echo $frmSearch->getFormHtml();
                            ?>
                        </div>
                    </section>
                <?php } else {
                    echo $frmSearch->getFormHtml();
                } ?>
                <?php echo HtmlHelper::getMessage(Labels::getLabel('LBL_We_Have_Not_Considered_Impact_Of_Refunds_And_Cancellations_In_This_Report.', $adminLangId)); ?>
                <section class="card section">
                    <div class="card-head">
                        <h4>
                            <?php if (!empty($orderDate)) {
                                $url = UrlHelper::generateFullUrl('SalesReport');
                                ?>
                                <a class="btn-back" href="javascript:void(0)" onclick="redirectBack('<?php echo $url; ?>')">
                                    <svg class="svg" width="24" height="24">
                                        <use
                                            xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back">
                                        </use>
                                    </svg>
                                </a>
                            <?php } ?>
                            <?php echo Labels::getLabel('LBL_Sales_Report', $adminLangId); ?>
                        </h4>

                        <?php
                        $data = [
                            'adminLangId' => $adminLangId,
                            'statusButtons' => false,
                            'deleteButton' => false,
                            'otherButtons' => [
                                [
                                    'attr' => [
                                        'href' => 'javascript:void(0)',
                                        'onclick' => "exportReport('" . $orderDate . "')",
                                        'title' => Labels::getLabel('LBL_Export', $adminLangId)
                                    ],
                                    'label' => '<svg class="svg" width="18" height="18"><use xlink:href="'.CONF_WEBROOT_FRONT_URL.'images/admin/retina/sprite-actions.svg#export"></use></svg>'
                                ],
                            ]
                        ];
                        /* if (!empty($orderDate)) {
                            $url = UrlHelper::generateFullUrl('SalesReport');
                            $data['otherButtons'][] = [
                                'attr' => [
                                    'href' => 'javascript:void(0)',
                                    'onclick' => "redirectBack('" . $url . "')",
                                    'title' => Labels::getLabel('LBL_Back', $adminLangId)
                                ],
                                'label' => '<i class="fas fa-arrow-left"></i>'
                            ];
                        } */

                        $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        ?>
                    </div>
                    <div class="card-table">
                        <div id="listing"> <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>