<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$arr_flds = [
    'listserial' => [
        'title' => Labels::getLabel('LBL_#', $adminLangId),
        'attributes' => [
            'width' => '7%'
        ],
    ],
    // 'pnotification_type' => [
    //     'title' => Labels::getLabel('LBL_TYPE', $adminLangId),
    //         'attributes' => [
    //             'width' => '20%'
    //         ]
    // ],
    'notification_detail' => [
        'title' => Labels::getLabel('LBL_DETAIL', $adminLangId),
        'attributes' => [
            'width' => '53%'
        ]
    ],
    'pnotification_notified_on' => [
        'title' => Labels::getLabel('LBL_SCHEDULED_FOR', $adminLangId),
        'attributes' => [
            'width' => '15%'
        ]
    ],
    // 'notify_to' => [
    //     'title' => Labels::getLabel('LBL_NOTIFY_TO', $adminLangId),
    //     'attributes' => [
    //         'width' => '20%'
    //     ]
    // ],
    'pnotification_status' => [
        'title' => Labels::getLabel('LBL_STATUS', $adminLangId),
        'attributes' => [
            'width' => '10%'
        ]
    ],
    'action' => [
        'title' => Labels::getLabel('LBL_Action(s)', $adminLangId),
        'attributes' => [
            'width' => '15%'
        ]
    ]
];

if (!$canEdit) {
    unset($arr_flds['action']);
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');

foreach ($arr_flds as $key => $val) {
    $th->appendElement('th', $val['attributes'], $val['title']);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr', array());

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            /* case 'pnotification_type':
                $td->appendElement('plaintext', array(), $typeArr[$row[$key]], true);
                break; */
            case 'notification_detail':
                $body = $row['pnotification_description'];
                $htm = '<strong>' . $row['pnotification_title'] . '</strong><br>';
                $htm .= strlen($body) > 100 ? substr($body, 0, 100) . "..." : $body;
                $td->appendElement('plaintext', array(), $htm, true);
                break;
            case 'pnotification_notified_on':
                $td->appendElement('plaintext', array(), FatDate::format(
                    $row[$key],
                    true,
                    true,
                    FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get())
                ));
                break;
            /* case 'notify_to':
                $buyerHtm = $sellerHtm = '';
                if (0 < $row['pnotification_for_buyer']) {
                    $buyerHtm = '<span class="badge badge-success">' . Labels::getLabel('LBL_BUYERS', $adminLangId) . '</span>';
                }

                if (0 < $row['pnotification_for_seller']) {
                    $sellerHtm = '<span class="badge badge-info">' . Labels::getLabel('LBL_SELLERS', $adminLangId) . '</span>';
                }
                $td->appendElement('plaintext', array(), $buyerHtm . ' ' . $sellerHtm, true);
                break; */
            case 'pnotification_status':
                switch ($row[$key]) {
                    case PushNotification::STATUS_PENDING:
                        $class = 'badge-purple';
                        break;
                    case PushNotification::STATUS_PROCESSING:
                        $class = 'badge-warning';
                        break;
                    case PushNotification::STATUS_COMPLETED:
                        $class = 'badge-success';
                        break;
                    default:
                        $class = 'badge-primary';
                        break;
                }
                $htm = '<label class="label ' . $class . '">' . $statusArr[$row[$key]] . '</label>';
                $td->appendElement('plaintext', array(), $htm, true);
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [];
                    if (PushNotification::STATUS_PENDING == $row['pnotification_status']) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addNotificationForm(" . $row['pnotification_id'] . ")"
                        ];
                    } elseif (PushNotification::STATUS_PENDING != $row['pnotification_status']) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_View', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                            "onclick" => "addNotificationForm(" . $row['pnotification_id'] . ")"
                        ];
                    }
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_Clone', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#clone'></use></svg>",
                        "onclick" => "clone(" . $row['pnotification_id'] . ")"
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['pnotification_id']], false);
                }
                break;
        }
    }
}


echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}

$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, ['name' => 'frmSearchPaging']);
$pagingArr = [
    'pageCount' => $pageCount,
    'page' => $page,
    'pageSize' => $pageSize,
    'recordCount' => $recordCount,
    'adminLangId' => $adminLangId
];
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);