<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    /*'promotion_id'=>Labels::getLabel('LBL_Id',$adminLangId),*/
    'promotion_name' => Labels::getLabel('LBL_Name', $adminLangId),
    'user_name' => Labels::getLabel('LBL_User', $adminLangId),
    'promotion_type' => Labels::getLabel('LBL_Type', $adminLangId),
    'blocation_promotion_cost' => Labels::getLabel('LBL_CPC', $adminLangId),
    'promotion_budget' => Labels::getLabel('LBL_budget', $adminLangId),
    'impressions' => Labels::getLabel('LBL_Impressions', $adminLangId),
    'clicks' => Labels::getLabel('LBL_Clicks', $adminLangId),
    //'orders'=>Labels::getLabel('LBL_Orders',$adminLangId),
    'promotion_approved' => Labels::getLabel('LBL_Approved', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['select_all'], $arr_flds['action']);
}
$tbl = new HtmlElement(
    'table',
    array('width' => '100%', 'class' => 'table table-hovered table-justified', 'id' => 'promotions')
);

$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr');
    $tr->setAttribute("id", $row['promotion_id']);

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="promotion_ids[]" value=' . $row['promotion_id'] . '></label>', true);
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'promotion_name':
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
            case 'user_name':
                $userName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['user_id'] . ")'>" . $row['user_name'] . "</a>";

                $userDetail = '<strong>' . Labels::getLabel('LBL_N:', $adminLangId) . ' </strong>' . $userName . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_UN:', $adminLangId) . ' </strong>' . $row['credential_username'] . '<br/>';
                $td->appendElement('plaintext', array(), $userDetail, true);

                if (!empty($row['shop_name'])) {
                    if ($canViewShops) {
                        $shopName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['shop_id'] . ")'>" . $row['shop_name'] . "</a>";
                        /* $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Shops') . '", ' . $row['shop_id'] . ')'), '<strong>' . Labels::getLabel('LBL_Shop', $adminLangId) . ' </strong>' . $row['shop_name'], true); */
                        $td->appendElement('plaintext', array(), '<strong>' . Labels::getLabel('LBL_Shop:', $adminLangId) . ' </strong>' . $shopName, true);
                    } else {
                        $td->appendElement('plaintext', array(), '<strong>' . Labels::getLabel('LBL_Shop', $adminLangId) . ' </strong>' . $row['shop_name'], true);
                    }
                }
                break;
            case 'promotion_type':
                $td->appendElement('plaintext', array(), $typeArr[$row[$key]], true);
                break;
            case 'blocation_promotion_cost':
            case 'banner_promotion_cost':
                $cost = Promotion::getPromotionCostPerClick(FatUtility::int($row['promotion_type']), FatUtility::int($row['blocation_id']));
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($cost, true, true));
                break;
            case 'promotion_budget':
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$key], true, true));
                break;
            case 'promotion_approved':
                $statusHtml = HtmlHelper::getStatusHtml($row[$key], $yesNoArr[$row[$key]]);
                $td->appendElement('plaintext', [], $statusHtml, true);
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "promotionForm(" . $row['promotion_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deletepromotionRecord(" . $row['promotion_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['promotion_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), FatUtility::int($row[$key]));
                break;
        }
    }
    $sr_no--;
}


$frm = new Form('frmPromotionsListing', array('id' => 'frmPromotionsListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml(); 
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
</div>
<?php $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmPromotionSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
