<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
foreach ($images as $image) {
	$uploadedTime = AttachedFile::setTimeParam($image['afile_updated_at']);
	$imgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($image['afile_record_id'], 'THUMB', 0, $image['afile_id'], $image['afile_lang_id'], $image['afile_type']), CONF_WEBROOT_FRONTEND) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');

	if ($isDefaultLayout == applicationConstants::YES) {
		?>

		<li id="<?php echo $image['afile_id']; ?>" class="uploaded-list-item ui-sortable-handle">
			<div class="uploaded-stocks-item" data-ratio="1:1">
				<img class="uploaded-stocks-img" data-bs-toggle="tooltip" data-placement="top" src="<?php echo $imgUrl; ?>"
					title="<?php echo $image['afile_name']; ?>" alt="<?php echo $image['afile_name']; ?>"
					data-bs-original-title="">
				<?php if ($canEdit) { ?>
					<div class="uploaded-stocks-actions">
						<button type="button" class="btn-close" aria-label="Close"
							onclick="deleteImage(<?php echo $image['afile_id']; ?>, 0, 0);">
						</button>
					</div>
				<?php } ?>
			</div>
		</li>
	<?php } else { ?>
		<li id="<?php echo $image['afile_id']; ?>" class="uploaded-list-item ui-sortable-handle">
			<div class="media-lab">
				<div class="media-lab-thumb">
					<img src="<?php echo $imgUrl; ?>" title="<?php echo $image['afile_name']; ?>"
						alt="<?php echo $image['afile_name']; ?>">
					<?php if ($canEdit) { ?>
						<a class="deleteLink white btn-close btn-close-white" href="javascript:void(0);"
							title="<?php echo Labels::getLabel('MSG_Delete', $langId).' '.$image['afile_name']; ?>"
							onclick="deleteImage(<?php echo $image['afile_id']; ?>, 0, 1);"
							class="delete"><i class="ion-close-round"></i></a>
					<?php } ?>
				</div>
			</div>
		</li>
	<?php }
}

if ($isDefaultLayout == applicationConstants::YES) {
	for ($i = 0; $i < (4 - count($images)); $i++) {
		?>
		<li class="unsortableJs">
			<div class="uploaded-stocks-item" data-ratio="1:1">
				<img class="uploaded-stocks-img" data-bs-toggle="tooltip" data-placement="top"
					src="<?php echo CONF_WEBROOT_FRONTEND; ?>images/defaults/product_default_image.jpg" title="" alt="">
				<div class="uploaded-stocks-actions">
				</div>
			</div>
		</li>
		<?php
	}
}