<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
    <?php

    $arr_flds1 = array(
        'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
        // 'listserial' => Labels::getLabel('LBL_#', $adminLangId),
        'product_image' => Labels::getLabel('LBL_Images', $adminLangId),
        'product_identifier' => Labels::getLabel('LBL_Name', $adminLangId)
    );

    $arr_flds2 = array(
        'user_name' => Labels::getLabel('LBL_User', $adminLangId),
        //'attrgrp_name'=>Labels::getLabel('LBL_Attribute_Group',$adminLangId),
        'product_added_on' => Labels::getLabel('LBL_Date', $adminLangId),
        'product_approved' => Labels::getLabel('LBL_Status', $adminLangId),
        'product_active' => Labels::getLabel('LBL_Publish', $adminLangId),
        'action' => Labels::getLabel('LBL_Action(s)', $adminLangId)
    );
    $arr_flds = $arr_flds1 + $arr_flds2;
    if (!$canEdit) {
        unset($arr_flds['select_all']);
    }
    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
    $th = $tbl->appendElement('thead')->appendElement('tr');
    foreach ($arr_flds as $key => $val) {
        if ('select_all' == $key) {
            $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
        } else {
            $e = $th->appendElement('th', array(), $val);
        }
    }

    $sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
    foreach ($arr_listing as $sn => $row) {
        $tr = $tbl->appendElement('tr', array());

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'select_all':
                    $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="product_ids[]" value=' . $row['product_id'] . '></label>', true);
                    break;
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no);
                    break;
                case 'product_image':
                    $str = HtmlHelper::imageListCard(AttachedFile::FILETYPE_PRODUCT_IMAGE, $row['product_name'] ?? '', $row['product_id'], 0, $row['product_updated_on']);

                    $td->appendElement('plaintext', array(), $str, true);
                    // $str = '';
                    // $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_PRODUCT_IMAGE, $row['product_id'], 0, 0, false);
                    // $aspectRatioArr = AttachedFile::getRatioTypeArray($adminLangId);
                    // if (!empty($fileData)) {
                    //     $str = '<div class="product-image"><img class="" width="60" ';
                    //     $str .= 'src="' . UrlHelper::generateUrl('image', 'product', array($row['product_id'], 'THUMB', 0, 0, $adminLangId), CONF_WEBROOT_FRONT_URL) . '" alt="' . $row['product_name'] . '"></div>';
                    // }
                    // $td->appendElement('plaintext', array(), $str, true);
                    break;
                case 'product_identifier':
                    $td->appendElement('plaintext', array(), $row['product_name'] . '<br>', true);
                    $td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                    break;
                case 'user_name':
                    if ($canViewUsers) {
                        !empty($row[$key]) ? $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '",' . $row['product_seller_id'] . ')'), $row[$key]) : $td->appendElement('plaintext', array(), (!empty($row[$key]) ? $row[$key] : 'Admin'), true);
                    } else {
                        $td->appendElement('plaintext', array(), (!empty($row[$key]) ? $row[$key] : 'Admin'), true);
                    }
                    break;
                /* case 'attrgrp_name':
                    $td->appendElement('plaintext', array(), CommonHelper::displayNotApplicable($adminLangId, $row[$key]), true);
                    break; */
                case 'product':
                    $td->appendElement('plaintext', array(), ($row['product_seller_id']) ? 'Custom' : 'Catalog');
                    break;
                case 'product_approved':
                    $statusHtm = Product::getStatusHtml($adminLangId, $row[$key]);
                    $td->appendElement('plaintext', array(), $statusHtm, true);
                    break;
                case 'product_active':
                    $active = "";
                    if ($row['product_active']) {
                        $active = 'checked';
                    }
                    $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                    $statusClass = ($canEdit === false) ? 'disabled' : '';
                    $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                            <input ' . $active . ' type="checkbox" id="switch' . $row['product_id'] . '" value="' . $row['product_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                            </label>';
                    $td->appendElement('plaintext', array(), $str, true);
                    break;
                case 'product_added_on':
                    $date = FatDate::format($row[$key], true);
                    $dateHtml = "";
                    if (strpos($date, ' ') !== false) {
                        list($formattedDate, $formattedTime) = explode(' ', $date);
                        $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                    } else {
                        $dateHtml = "<date class='date'>" . $date . "</date>";
                    }
                    $td->appendElement('plaintext', array(), $dateHtml, true);
                    break;
                case 'action':
                    if ($canEdit) {
                        $actionArr = [
                            [
                                "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                "href" => UrlHelper::generateUrl('Products', 'singleForm', array($row['product_id']))
                            ],
                            [
                                "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                "onclick" => "deleteProduct(" . $row['product_id'] . ")"
                            ]
                        ];
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['product_id']], false);
                    }
                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }
        $sr_no--;
    }


    $frm = new Form('frmProdListing', array('id' => 'frmProdListing'));
    $frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
    $frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
    $frm->setFormTagAttribute('action', UrlHelper::generateUrl('Products', 'toggleBulkStatuses'));
    $frm->addHiddenField('', 'status');

    echo $frm->getFormTag();
    echo $frm->getFieldHtml('status');
    echo $tbl->getHtml();
    if (count($arr_listing) == 0) {
        $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
    }
    ?>
    </form>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array('name' => 'frmProductSearchPaging'));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);

