<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
if ($reportType == applicationConstants::PRODUCT_FOR_RENT) {
    $arrFlds = array(
        'title' => Labels::getLabel('LBL_Title', $adminLangId),
        'followers' => Labels::getLabel('LBL_WISHLIST', $adminLangId),
        'totRentalOrders' => Labels::getLabel('LBL_No._of_Rental_Orders', $adminLangId),
        'totRentedQty' => Labels::getLabel('LBL_Rented_Qty', $adminLangId),
        'refundedQty' => Labels::getLabel('LBL_Refunded_Qty', $adminLangId),
        'cancelledOrdersQty' => Labels::getLabel('LBL_Cancelled_Order_Qty', $adminLangId),
        'total' => Labels::getLabel('LBL_Total(A)', $adminLangId),
        'shipping' => Labels::getLabel('LBL_Shipping(B)', $adminLangId),
        'tax' => Labels::getLabel('LBL_Tax(C)', $adminLangId),
        'rentalSecurity' => Labels::getLabel('LBL_Security', $adminLangId) . '<br />' . Labels::getLabel('LBL_(D)', $adminLangId),
        //'sub_total' => Labels::getLabel('LBL_Total(A+B+C+D)', $adminLangId),
        'totalRefundedAmount' => Labels::getLabel('LBL_Refunded_Amount', $adminLangId) . '<br />' . Labels::getLabel('LBL_(E)', $adminLangId),
        'earning' => Labels::getLabel('LBL_Total', $adminLangId) . '<br />' . Labels::getLabel('LBL_(A+B+C+D-E)', $adminLangId),
        'cancelledOrderAmt' => Labels::getLabel('LBL_Cancelled_Order_Amount', $adminLangId),
        'commission' => Labels::getLabel('LBL_Commission', $adminLangId)
    );
} else {
    $arrFlds = array(
        'title' => Labels::getLabel('LBL_Title', $adminLangId),
        'followers' => Labels::getLabel('LBL_WISHLIST', $adminLangId),
        'price' => Labels::getLabel('LBL_Unit_Price', $adminLangId),
        'orders_count' => Labels::getLabel('LBL_No._of_Orders', $adminLangId),
        'sold_qty' => Labels::getLabel('LBL_Sold_Qty', $adminLangId) . '<br/>' . Labels::getLabel('LBL_(Sold_-_Refund_Qty)', $adminLangId),
        'refundedQty' => Labels::getLabel('LBL_Refunded_Qty', $adminLangId),
        'cancelledOrdersQty' => Labels::getLabel('LBL_Cancelled_Order_Qty', $adminLangId),
        'total' => Labels::getLabel('LBL_Total(A)', $adminLangId),
        'shipping' => Labels::getLabel('LBL_Shipping(B)', $adminLangId),
        'tax' => Labels::getLabel('LBL_Tax(C)', $adminLangId),
        'sub_total' => Labels::getLabel('LBL_Total(A+B+C)', $adminLangId),
        'totalRefundedAmount' => Labels::getLabel('LBL_Refunded_Amount', $adminLangId),
        'cancelledOrderAmt' => Labels::getLabel('LBL_Cancelled_Order_Amount', $adminLangId),
        'commission' => Labels::getLabel('LBL_Commission', $adminLangId)
    );
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arrFlds as $val) {
    $e = $th->appendElement('th', array(), $val, true);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');
    $subTotal = 0;
    foreach ($arrFlds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;

            case 'title':
                $name = "<span class='td-width'><strong>" . Labels::getLabel('LBL_Catalog_Name', $adminLangId) . ": </strong>" . $row['product_name'];
                if ($row['selprod_title'] != '') {
                    $name .= '<br/><strong>' . Labels::getLabel('LBL_Custom_Title', $adminLangId) . ': </strong>' . $row['selprod_title'];
                }
                if ($row['grouped_option_name'] != '') {
                    $groupedOptionNameArr = explode(',', $row['grouped_option_name']);
                    $groupedOptionValueArr = explode(',', $row['grouped_optionvalue_name']);
                    if (!empty($groupedOptionNameArr)) {
                        foreach ($groupedOptionNameArr as $key => $optionName) {
                            $name .= '<br/><strong>' . $optionName . ':</strong> ' . $groupedOptionValueArr[$key];
                        }
                    }
                }

                if ($row['brand_name'] != '') {
                    $name .= "<br/><strong>" . Labels::getLabel('LBL_Brand', $adminLangId) . ":  </strong>" . $row['brand_name'];
                }

                if ($row['shop_name'] != '') {
                    $name .= '<br/><strong>' . Labels::getLabel('LBL_Sold_By', $adminLangId) . ':  </strong>' . "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Shops') . "\", " . $row['shop_id'] . ")'>" . $row['shop_name'] . "</a>";
                }
                $name .= '</span>';
                $td->appendElement('plaintext', array(), $name, true);
                break;

            case 'price':
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row['selprod_price'], true, true));
                break;

            case 'followers':
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;

            case 'orders_count':
                $td->appendElement('plaintext', array(), $row['totOrders']);
                break;

            case 'sold_qty':
                $td->appendElement('plaintext', array(), $row['totSoldQty']);
                break;

            case 'total':
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row['total'], true, true));
                break;

            case 'shipping':
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row['shippingTotal'], true, true));
                break;

            case 'tax':
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row['taxTotal'], true, true));
                break;

            case 'sub_total':
                $securityAmount = (isset($row['rentalSecurity'])) ? $row['rentalSecurity'] : 0;
                $subTotal = $row['total'] + $row['shippingTotal'] + $row['taxTotal'] + $securityAmount;
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($subTotal, true, true));
                break;
            case 'earning':
                $securityAmount = (isset($row['rentalSecurity'])) ? $row['rentalSecurity'] : 0;
                $subTotal = ($row['total'] + $row['shippingTotal'] + $row['taxTotal'] + $securityAmount) - $row['totalRefundedAmount'];
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($subTotal, true, true));
                break;
            case 'commission':
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row['commission'], true, true));
                break;
            case 'totalRefundedAmount':
            case 'cancelledOrderAmt':
                $td->appendElement('plaintext', array(), CommonHelper::displayMoneyFormat($row[$key], true, true));
                break;

            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmProductsReportSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
