<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$arrFlds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'product_name' => Labels::getLabel('LBL_Product_Name', $adminLangId),
    'afile_physical_path' => Labels::getLabel('LBL_Path', $adminLangId),
    'afile_downloaded' => Labels::getLabel('LBL_Is_Downloaded', $adminLangId),
);
if ($canEdit) {
    $arrFlds['action'] = Labels::getLabel('LBL_Action(s)', $adminLangId);
}
$tbl = new HtmlElement(
    'table',
    array('width' => '100%', 'class' => 'table table-hovered table-justified')
);

$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arrFlds as $val) {
    $e = $th->appendElement('th', array(), $val, true);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');

    foreach ($arrFlds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'afile_downloaded':
                $lbl = Labels::getLabel('LBL_No', $adminLangId);
                if ($row[$key]) {
                    $lbl = Labels::getLabel('LBL_Yes', $adminLangId);
                }
                $td->appendElement('plaintext', array(), $lbl);
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "editProductTempImage(" . $row['afile_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['afile_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmProductsTempImagesPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);