<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="card-head">
    <h4><?php echo Labels::getLabel('LBL_CATEGORIES_LIST', $adminLangId); ?></h4>
    <div class="card-head-toolbar">
        <?php if ($canEdit) { ?>
            <a class="btn btn-icon btn-outline-gray" href="<?php echo commonHelper::generateUrl('ProductCategories', 'form', array(0)); ?>"
                title="<?php echo Labels::getLabel('LBL_Add_Category', $adminLangId); ?>">
                <svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                    fill="currentColor" viewBox="0 0 16 16">
                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16">
                    </path>
                    <path
                        d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4">
                    </path>
                </svg>
                <span><?php echo Labels::getLabel('LBL_New', $adminLangId); ?></span>
            </a>
        <?php } ?>
    </div>
</div>
<div class="card-body extra">
    <div class="accordion-categories">
        <?php
        if (count($arr_listing) > 0) {
            ?>
            <ul id="sorting-categories" class="sorting-categories">
                <?php foreach ($arr_listing as $sn => $row) { ?>
                    <li id="<?php echo $row['prodcat_id']; ?>"
                        class="sortableListsClosed <?php if ($row['subcategory_count'] == 0) { ?>no-children<?php } ?>">
                        <div>
                            <div class="sorting-bar">
                                <div class="sorting-title">
                                    <span>
                                        <?php echo $row['prodcat_name']; ?>
                                    </span>
                                    <a href="<?php echo commonHelper::generateUrl('Products', 'index', array($row['prodcat_id'])); ?>"
                                        class="badge badge-info badge-pill ms-2 clickable"
                                        title="<?php echo Labels::getLabel('LBL_Category_Products', $adminLangId); ?>"><?php echo CommonHelper::displayBadgeCount($row['category_products']); ?></a>
                                </div>
                                <div class="clickable">
                                    <div class="sorting-actions">
                                        <?php
                                        $active = "";
                                        if ($row['prodcat_active']) {
                                            $active = 'checked';
                                        }
                                        $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                                        $statusClass = ($canEdit === false) ? 'disabled' : '';
                                        ?>
                                        <label class="clickable switch switch-sm switch-icon <?php echo $statusClass; ?>">
                                            <input <?php echo $active; ?> type="checkbox"
                                                id="switch<?php echo $row['prodcat_id']; ?>"
                                                value="<?php echo $row['prodcat_id']; ?>" onclick="<?php echo $statusAct; ?>"
                                                class="switch-labels clickable" />
                                        </label>
                                        <?php if ($canEdit) { ?>
                                            <button onClick="goToProduct(<?php echo $row['prodcat_id']; ?>)"
                                                title="<?php echo Labels::getLabel('LBL_Add_Product', $adminLangId); ?>"
                                                class="actions-link clickable"><svg class="svg bi-plus-circle clickable"
                                                    xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor"
                                                    viewBox="0 0 16 16">
                                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16">
                                                    </path>
                                                    <path
                                                        d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4">
                                                    </path>
                                                </svg></button>
                                            <a href="<?php echo UrlHelper::generateUrl('ProductCategories', 'form', array($row['prodcat_id'])); ?>"
                                                <?php /* onClick="categoryForm(<?php echo $row['prodcat_id']; ?>)" */ ?>
                                                title="<?php echo Labels::getLabel('LBL_Edit', $adminLangId); ?>"
                                                class="actions-link clickable"><svg class="svg clickable" width="18" height="18">
                                                    <use
                                                        xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#edit">
                                                    </use>
                                                </svg></a> <button
                                                title="<?php echo Labels::getLabel('LBL_Delete', $adminLangId); ?>"
                                                onclick="deleteRecord(<?php echo $row['prodcat_id']; ?>)"
                                                class="actions-link clickable"><svg class="svg clickable" width="18" height="18">
                                                    <use
                                                        xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#delete">
                                                    </use>
                                                </svg></button>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <?php if ($row['subcategory_count'] > 0) { ?>
                                <span class="sortableListsOpener"> <i class="sort-icon clickable"  onclick="displaySubCategories(this)">
                                        <svg class="svg clickable" width="18" height="18">
                                            <use
                                                xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#plus">
                                            </use>
                                        </svg> </i>
                                </span>
                            <?php } ?>
                        </div>
                    </li>
                <?php } ?>
            </ul>
            <?php
        } else {
            $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
        }
        ?>
    </div>
</div>

<script type="text/javascript">
    $(function () {
        var optionsPlus = {
            insertZone: 0,
            listsClass:'sorting-categories',
            insertZonePlus: true,
            placeholderCss: {
                'background-color': '#e5f5ff',
            },
            hintCss: {
                'background-color': '#6dc5ff'
            },
            baseCss: {
                'list-style-type': 'none',
            },
            onDragStart: function (e, cEl) {
                var catId = $(cEl).attr('id');
                $("#" + catId).children().children().children('.sorting-title').css('margin-left', '25px');
                $("#" + catId).children('ul').css('list-style-type', 'none');
            },
            complete: function (cEl) {
                var catId = $(cEl).attr('id');
                
                $("#" + catId).children().children().children('.sorting-title').css('margin-left', '0px');
            },
            onChange: function (cEl) {
                $("#js-cat-section").addClass('overlay-blur');
                var catId = $(cEl).attr('id');
                var parentCatId = $(cEl).parent('ul').parent('li').attr('id');
                var catOrder = [];
                $($(cEl).parent().children()).each(function (i) {
                    catOrder[i + 1] = $(this).attr('id');
                });
                var data = "catId=" + catId + "&parentCatId=" + parentCatId + "&catOrder=" + JSON.stringify(
                    catOrder);

                if (typeof parentCatId != 'undefined') {
                    displaySubCategories(cEl, parentCatId, data);
                    $(cEl).parents('li').each(function () {
                        var rootCat = $(this).attr('id');
                        $("#" + rootCat).children('div').children('.sortableListsOpener').remove();
                        $("#" + rootCat).removeClass('sortableListsClosed').addClass(
                            'sortableListsOpen');
                        $("#" + rootCat).children('div').append(
                            '<span class="sortableListsOpener clickable" ><i class="sort-icon clickable"  onClick="hideItems(this)"><svg class="svg" width="18" height="18"><use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL ?>images/admin/retina/sprite-actions.svg#minus"></use></svg></i></span>'
                        );
                    });
                    $("#" + catId).parent('ul').addClass('append-ul');
                } else {
                    updateCatOrder(data);
                }
            },
            opener: {
                active: true,
                as: 'html', // if as is not set plugin uses background image
                close: '<i class="sort-icon clickable"><svg class="svg" onclick="hideItems(this)" width="18" height="18"><use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL ?>images/admin/retina/sprite-actions.svg#minus"></use></svg></i>',
                open: '<i class="sort-icon clickable"><svg class="svg" onclick="displaySubCategories(this)" width="18" height="18"><use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL ?>images/admin/retina/sprite-actions.svg#plus"></use></svg></i>',
                openerCss: {}
            },
            ignoreClass: 'clickable'
        };

        $('#sorting-categories').sortableLists(optionsPlus);

    });
</script>
<style>
    #sortableListsBase .sortableListsCurrent{
        box-sizing:content-box;
    }
    </style>