<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'prodcat_identifier' => Labels::getLabel('LBL_Identifier_Name', $adminLangId),
    'prodcat_active' => Labels::getLabel('LBL_Active', $adminLangId),
    'child_count' => Labels::getLabel('LBL_Subcategories', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified', 'id' => 'prodcat'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');
    $tr->setAttribute("id", $row['prodcat_id']);

    if ($row['prodcat_active'] == 0) {
        $tr->setAttribute("class", "inactive-tr");
    }
    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'prodcat_active':
                $active = "";
                if ($row['prodcat_active']) {
                    $active = 'checked';
                }
                $statucAct = ($canEdit === true) ? 'toggleStatus(event,this)' : '';
                $str = '<div class="checkbox-switch"><input ' . $active . ' type="checkbox" id="switch' . $row['prodcat_id'] . '" value="' . $row['prodcat_id'] . '" onclick="' . $statucAct . '"/><label for="switch' . $row['prodcat_id'] . '">Toggle</label></div>';
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'child_count':
                if ($row[$key] == 0) {
                    $td->appendElement('plaintext', array(), $row[$key], true);
                } else {
                    $td->appendElement('a', array('href' => UrlHelper::generateUrl('ProductCategories', 'index', array($row['prodcat_id'])), 'title' => Labels::getLabel('LBL_View_Categories', $adminLangId)), $row[$key]);
                }
                break;

            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "href" => UrlHelper::generateUrl('ProductCategories', 'form', array('general', $row['prodcat_id']))
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteRecord(" . $row['prodcat_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['prodcat_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
/* echo FatUtility::createHiddenFormFromData ( $postedData, array (
        'name' => 'frmUserSearchPaging','id'=>'pretend_search_form'
) ); */
echo isset($pagination) ? html_entity_decode($pagination) : '';
?>
<script>
    $(document).ready(function() {
        var pcat_id = $('#prodcat_parent').val();
        $('#prodcat').tableDnD({
            onDrop: function(table, row) {
                fcom.displayProcessing();
                var order = $.tableDnD.serialize('id');
                order += '&pcat_id=' + pcat_id;
                fcom.ajax(fcom.makeUrl('productCategories', 'update_order'), order, function(res) {
                    var ans = $.parseJSON(res);
                    if (ans.status == 1) {
                        fcom.displaySuccessMessage(ans.msg);
                    } else {
                        fcom.displayErrorMessage(ans.msg);
                    }
                });
            }
        });
    });
</script>