<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
if (count($attributes) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}

foreach ($attributes as $grp => $data) {
	?>
	<div class="form-border">
		<legend class="form-section-head"><?php echo $grp; ?></legend>
		<div class="table-responsive table-scrollable js-scrollable tablewrap">
			<table class="table table-hovered table-justified" width="100%">
				<thead>
					<tr>
						<th width="25%"><?php echo Labels::getLabel('LBL_Field_Name', $adminLangId); ?></th>
						<th width="30%"><?php echo Labels::getLabel('LBL_Field_Type', $adminLangId); ?></th>
						<th width="15%"><?php echo Labels::getLabel('LBL_For_Filters', $adminLangId); ?></th>
						<th width="10%"><?php echo Labels::getLabel('LBL_Postfix', $adminLangId); ?></th>
						<th width="20%"><?php echo Labels::getLabel('LBL_Action(s)', $adminLangId); ?></th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($data as $val) { ?>
						<tr>
							<td><?php echo $val['attr_name']; ?></td>
							<td><?php echo (!empty($attrTypes[$val['attr_type']])) ? $attrTypes[$val['attr_type']] : 'N/A'; ?>
							</td>
							<td><?php
							$yesNoArr = applicationConstants::getYesNoArr($adminLangId);
							echo $yesNoArr[$val['attr_display_in_filter']]; ?></td>
							<td><?php echo $val['attr_postfix']; ?></td>
							<td>
								<ul class="actions actions-tbl">
									<li class="actions-item">
										<a href="javascript:void(0)" class="actions-link zxc" title="Edit"
											onclick="editAttr(<?php echo $val['attr_id']; ?>)"><svg class='svg' width='18'
												height='18'>
												<use
													xlink:href='<?php echo CONF_WEBROOT_FRONT_URL ?>images/admin/retina/sprite-actions.svg#edit'>
												</use>
											</svg></a>
									</li>
									<li class="actions-item">
										<a href="javascript:void(0)" class="actions-link zxc" title="Delete"
											onclick="deleteAttr(<?php echo $val['attr_id']; ?>)"><svg class='svg' width='18'
												height='18'>
												<use
													xlink:href='<?php echo CONF_WEBROOT_FRONT_URL ?>images/admin/retina/sprite-actions.svg#delete'>
												</use>
											</svg></a>
									</li>
								</ul>
							</td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
<?php } ?>