<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
$prodCatFrm->setFormTagAttribute('class', 'form web_form');
$prodCatFrm->setFormTagAttribute('id', 'frmProdCategory');
$prodCatFrm->setFormTagAttribute('onsubmit', 'setupCategory(' . $productReq . '); return(false);');

$activeFld = $prodCatFrm->getField('prodcat_active');

$catFld = $prodCatFrm->getField('parent_category_name');
$catFld->addFieldTagAttribute('onmousedown', 'clearTxt(this)');

$activeFld->setOptionListTagAttribute('class', 'list-radio');
$activeFld->developerTags['rdLabelAttributes'] = array('class' => 'radio');
$activeFld->developerTags['rdHtmlAfterRadio'] = '';

$compFld = $prodCatFrm->getField('prodcat_comparison');

$compFld->setOptionListTagAttribute('class', 'list-radio');
$compFld->developerTags['rdLabelAttributes'] = array('class' => 'radio');
$compFld->developerTags['rdHtmlAfterRadio'] = '';

$statusFld = $prodCatFrm->getField('prodcat_status');
if (null != $statusFld) {
    $statusFld->setOptionListTagAttribute('class', 'list-radio');
    $statusFld->developerTags['rdLabelAttributes'] = array('class' => 'radio');
    $statusFld->developerTags['rdHtmlAfterRadio'] = '';
}

$iconLangFld = $prodCatFrm->getField('icon_lang_id');
$iconLangFld->addFieldTagAttribute('class', 'icon-language-js');

$iconFld = $prodCatFrm->getField('cat_icon');
$iconFld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$iconFld->addFieldTagAttribute('onChange', 'iconPopupImage(this)');
$iconFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_This_will_be_displayed_on_your_store_in_dimension_of', $adminLangId) . ' ' . $iconSizeArr['width'] . 'x' . $iconSizeArr['height'] . '</small>';

$bannerFld = $prodCatFrm->getField('cat_banner');
$bannerFld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$bannerFld->addFieldTagAttribute('onChange', 'bannerPopupImage(this)');
$bannerFld->htmlAfterField = '<small class="text--small form-text text-muted preferredDimensions-js" >' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' ' . $bannerSizeArr['width'] . 'x' . $bannerSizeArr['height'] . '</small>';

$bannerLangFld = $prodCatFrm->getField('banner_lang_id');
$bannerLangFld->addFieldTagAttribute('class', 'banner-language-js');

$screenFld = $prodCatFrm->getField('slide_screen');
$screenFld->addFieldTagAttribute('class', 'prefDimensions-js');

$btn = $prodCatFrm->getField('btn_submit');
$btn->setFieldTagAttribute('class', "btn btn-brand btn-wide");

$btn = $prodCatFrm->getField('btn_discard');
$btn->addFieldTagAttribute('onClick', "discardForm()");
$btn->setFieldTagAttribute('class', "btn btn-gray btn-wide ");

/* $fld = $prodCatFrm->getField('auto_update_other_langs_data');
if (null != $fld) {
    $fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
    $fld->developerTags['cbHtmlAfterCheckbox'] = '';
} */
?>
<div class="page">
    <div class="content content-space">
        <div class="page-title">
            <div class="row">
                <div class="col--first col-lg-6">
                    <span class="page__icon">
                        <i class="ion-android-star"></i></span>
                    <h5><?php echo Labels::getLabel('LBL_Category_Form', $adminLangId); ?> </h5>
                    <?php if ($productReq > 0) { ?>
                    <ul class="breadcrumb ">
                        <li>
                            <a href="<?php echo UrlHelper::generateUrl('') ?>">
                                <?php echo Labels::getLabel('LBL_Home', $adminLangId); ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?php echo UrlHelper::generateUrl('ProductCategories', 'requests') ?>">
                                <?php echo Labels::getLabel('LBL_Categories_Requests', $adminLangId); ?>
                            </a>
                        </li>
                    </ul>
                    <?php
                    } else {
                        $this->includeTemplate('_partial/header/header-breadcrumb.php');
                    }
                    ?>
                </div>
            </div>
        </div>
        <section class="card">
            <div class="card-head card-tabs">
                <ul class="nav-tabs nav-tabs-line tabs_nav">
                    <li class="nav-tabs-item">
                        <a class="nav-tabs-link active tabs_001" rel="tabs_001" href="javascript:void(0)">
                            <div class="tabs-head">
                                <div class="tabs-title">
                                    <span
                                        class="tab-heading"><?php echo Labels::getLabel('LBL_General', $adminLangId); ?></span>
                                    <?php /* <span
                                        class="tab-sub-heading"><?php echo Labels::getLabel('LBL_General', $adminLangId); ?></span>
                                    */ ?>
                                </div>
                            </div>
                        </a>
                    </li>
                    <?php if (FatApp::getConfig('CONF_USE_CUSTOM_FIELDS', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>
                    <li class="nav-tabs-item">
                        <a <?php if ($prodCatId > 0) { ?> rel="tabs_002" class="nav-tabs-link tabs_002"
                            <?php } else { ?> style="pointer-events: none;" <?php } ?> href="javascript:void(0)">
                            <div class="tabs-head">
                                <div class="tabs-title">
                                    <span class="tab-heading">
                                        <?php echo Labels::getLabel('LBL_Custom_fields', $adminLangId); ?>
                                        <svg data-toggle="tooltip" title="<?php echo Labels::getLabel('LBL_Custom_fields_tooltip_text', $adminLangId); ?>" class="tabs-icon svg" aria-hidden="true" width="18" height="18" >
                                            <use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#info-circle"></use>
                                        </svg>
                                    </span>
                                    <?php /* <span
                                        class="tab-sub-heading"><?php echo Labels::getLabel('LBL_Add_custom_fields', $adminLangId); ?>
                                    <i class="fa fa-info-circle"
                                        title="<?php echo Labels::getLabel('LBL_Custom_fields_tooltip_text', $adminLangId); ?>"></i>
                                    </span> */ ?>

                                </div>
                            </div>
                        </a>
                    </li>
                    <?php } ?>
                    <?php if (FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>
                    <li class="nav-tabs-item">
                        <a <?php if ($prodCatId > 0) { ?> rel="tabs_003" class="nav-tabs-link tabs_003"
                            <?php } else { ?> style="pointer-events: none;" <?php } ?> href="javascript:void(0)">
                            <div class="tabs-head">
                                <div class="tabs-title">
                                    <?php echo Labels::getLabel('LBL_Checklist', $adminLangId); ?>
                                        <svg data-toggle="tooltip" title="<?php echo Labels::getLabel('LBL_Please_Select_Checklist_Option', $adminLangId); ?>" class="tabs-icon svg" aria-hidden="true" width="18" height="18" >
                                            <use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#info-circle"></use>
                                        </svg>
                                        <span><?php echo Labels::getLabel('LBL_Add_Checklist', $adminLangId); ?></span>
                                </div>
                            </div>
                        </a>
                    </li>
                    <?php } ?>
                </ul>
            </div>
            <div class="card-body">
                <!-- TAB SECTION START HERE -->
                <div class="tabs_panel_wrap">
                    <div id="tabs_001" class="tabs_panel" style="display: block;">
                        <?php echo $prodCatFrm->getFormTag(); ?>
                        <div class="row justify-content-center">
                            <div class="col-md-12">
                                <h5>
                                    <?php echo Labels::getLabel('LBL_General', $adminLangId); ?>
                                </h5>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                        $fld = $prodCatFrm->getField('prodcat_identifier');
                                                        echo $fld->getCaption();
                                                        ?>
                                                    <span class="spn_must_field">*</span>
                                                </label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $prodCatFrm->getFieldHtml('prodcat_identifier'); ?>
                                                    <?php echo $prodCatFrm->getFieldHtml('prodcat_id'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                        $fld = $prodCatFrm->getField('prodcat_name[' . $siteDefaultLangId . ']');
                                                        echo $fld->getCaption();
                                                        ?>
                                                    <span class="spn_must_field">*</span></label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $prodCatFrm->getFieldHtml('prodcat_name[' . $siteDefaultLangId . ']'); ?>
                                                    <?php echo $prodCatFrm->getFieldHtml('prodcat_id'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                        $fld = $prodCatFrm->getField('parent_category_name');
                                                        echo $fld->getCaption();
                                                        ?></label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $prodCatFrm->getFieldHtml('parent_category_name'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                        $fld = $prodCatFrm->getField('prodcat_active');
                                                        echo $fld->getCaption();
                                                        ?></label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $prodCatFrm->getFieldHtml('prodcat_active'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php
                                        if (FatApp::getConfig("CONF_ENABLE_PRODUCT_COMPARISON", FatUtility::VAR_INT, 1)) {
                                            ?>
                                    <div class="col-md-4">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                                $fld = $prodCatFrm->getField('prodcat_comparison');
                                                                echo $fld->getCaption();
                                                                ?></label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $prodCatFrm->getFieldHtml('prodcat_comparison'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                    <?php
                                        $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
                                        if (!empty($translatorSubscriptionKey) && count($otherLangData) > 0) {
                                            ?>

                                    <div class="col-md-4">
                                        <div class="field-set">
                                            <div class="caption-wraper"><label class="form-label">&nbsp;</label>
                                            </div>
                                            <div class="field-wraper ">
                                                <div class="field_cover setting-block">
                                                    <?php
                                                    $autoTranslateFld = $prodCatFrm->getField('auto_update_other_langs_data');
                                                    echo $autoTranslateFld->getHtml(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <?php } ?>


                                    <?php if (null != $statusFld) { ?>
                                    <div class="col-md-4">
                                        <div class="field-set d-flex align-items-center">
                                            <div class="caption-wraper w-auto pr-4">
                                                <label class="form-label">
                                                    <?php echo $statusFld->getCaption(); ?>
                                                </label>
                                            </div>
                                            <div class="field-wraper w-auto">
                                                <div class="field_cover">
                                                    <?php echo $prodCatFrm->getFieldHtml('prodcat_status'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php } ?>
                                </div>
                                <div class="row">
                                    <div class="col-sm-12">
                                        <?php
                                            /* [ MEDIA INSTRUCTIONS START HERE */
                                            $tpl = new FatTemplate('', '');
                                            $tpl->set('adminLangId', $adminLangId);
                                            echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
                                            /* ] */
                                            ?>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="mb-4 form-section">
                                            <h5>
                                                <?php echo Labels::getLabel('LBL_Banner', $adminLangId); ?>
                                            </h5>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="field-set">
                                                        <div class="caption-wraper"><label class="form-label">
                                                                <?php
                                                                    $fld = $prodCatFrm->getField('banner_lang_id');
                                                                    echo $fld->getCaption();
                                                                    ?>
                                                            </label></div>
                                                        <div class="field-wraper">
                                                            <div class="field_cover">
                                                                <?php echo $prodCatFrm->getFieldHtml('banner_lang_id'); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="field-set">
                                                        <div class="caption-wraper"><label class="form-label">
                                                                <?php
                                                                    $fld = $prodCatFrm->getField('slide_screen');
                                                                    echo $fld->getCaption();
                                                                    ?>
                                                            </label></div>
                                                        <div class="field-wraper">
                                                            <div class="field_cover screen-type-banner--js"
                                                                data-type="banner">
                                                                <?php echo $prodCatFrm->getFieldHtml('slide_screen'); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="field-set">
                                                        <div class="caption-wraper"><label class="form-label">
                                                            </label></div>
                                                        <div class="field-wraper">
                                                            <div class="field_cover">
                                                                <?php
                                                                    echo $prodCatFrm->getFieldHtml('banner_file_type');
                                                                    echo $prodCatFrm->getFieldHtml('cat_banner');
                                                                    ?>
                                                                <?php
                                                                    foreach ($mediaLanguages as $key => $data) {
                                                                        foreach ($screenArr as $key1 => $screen) {
                                                                            echo $prodCatFrm->getFieldHtml('cat_banner_image_id[' . $key . '_' . $key1 . ']');
                                                                        }
                                                                    }
                                                                    ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-12" id="banner-image-listing"
                                                    style="min-height: 136px;"></div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-md-6">
                                        <div class="mb-4 form-section">
                                            <h5>
                                                <?php echo Labels::getLabel('LBL_Icon', $adminLangId); ?>
                                            </h5>
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <div class="field-set">
                                                        <div class="caption-wraper"><label class="form-label">
                                                                <?php
                                                                    $fld = $prodCatFrm->getField('icon_lang_id');
                                                                    echo $fld->getCaption();
                                                                    ?>
                                                            </label></div>
                                                        <div class="field-wraper">
                                                            <div class="field_cover">
                                                                <?php echo $prodCatFrm->getFieldHtml('icon_lang_id'); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="field-set">
                                                        <div class="caption-wraper"><label class="form-label">
                                                            </label></div>
                                                        <div class="field-wraper">
                                                            <div class="field_cover">
                                                                <?php
                                                                    echo $prodCatFrm->getFieldHtml('icon_file_type');
                                                                    echo $prodCatFrm->getFieldHtml('cat_icon');
                                                                    ?>
                                                                <?php
                                                                    foreach ($mediaLanguages as $key => $data) {
                                                                        echo $prodCatFrm->getFieldHtml('cat_icon_image_id[' . $key . ']');
                                                                    }
                                                                    ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4" id="icon-image-listing"
                                                    style="min-height: 136px;"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>






                                <?php
                                    if (!empty($otherLangData)) {
                                        foreach ($otherLangData as $langId => $data) {
                                            ?>
                                <div class="custom-accordion accordians_container accordians_container-categories"
                                    defaultLang="<?php echo $siteDefaultLangId; ?>" language="<?php echo $langId; ?>"
                                    id="accordion-language_<?php echo $langId; ?>" onClick="translateData(this)">
                                    <div class="custom-accordion-block accordian_panel">
                                        <button class="accordian-btn btn btn-secondary dropdown-toggle accordianhead"
                                            id="collapse_<?php echo $langId; ?>">
                                            <?php
                                                                echo $data . " ";
                                                                echo Labels::getLabel('LBL_Language_Data', $adminLangId);
                                                                ?>
                                        </button>
                                        <div class="custom-accordion-body accordian_body accordiancontent form-section "
                                            style="display: none;">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <div class="field-set">
                                                        <div class="caption-wraper">
                                                            <label class="form-label">
                                                                <?php
                                                                                    $fld = $prodCatFrm->getField('prodcat_name[' . $langId . ']');
                                                                                    echo $fld->getCaption();
                                                                                    ?>
                                                            </label>
                                                        </div>
                                                        <div class="field-wraper">
                                                            <div class="field_cover">
                                                                <?php echo $prodCatFrm->getFieldHtml('prodcat_name[' . $langId . ']'); ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php
                                        }
                                    }
                                    ?>
                                <?php if (0 < $productReq) { ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <?php echo $prodCatFrm->getFieldHtml('btn_submit'); ?>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>

                        <?php if (1 > $productReq) { ?>
                        <div class="row justify-content-center">
                            <div class="col-md-12 text--right">
                                <h4></h4>
                                <div class="card-head-toolbar">
                                    <?php echo $prodCatFrm->getFieldHtml('btn_discard'); ?>
                                    <?php echo $prodCatFrm->getFieldHtml('btn_submit'); ?>
                                </div>
                            </div>
                        </div>

                        <?php } ?>



                        <?php
                        echo $prodCatFrm->getFieldHtml('banner_min_width');
                        echo $prodCatFrm->getFieldHtml('banner_min_height');
                        echo $prodCatFrm->getFieldHtml('logo_min_width');
                        echo $prodCatFrm->getFieldHtml('logo_min_height');
                        echo $prodCatFrm->getFieldHtml('prodcat_parent');
                        ?>
                        </form>
                        <?php
                        echo $prodCatFrm->getExternalJS();

                        $catAutocompleteArr = [];
                        foreach ($categories as $catId => $catName) {
                            $catAutocompleteArr[] = array(
                                'id' => $catId,
                                'label' => strip_tags(html_entity_decode($catName, ENT_QUOTES, 'UTF-8'))
                            );
                        }
                        ?>
                    </div>
                    <div id="tabs_002" class="tabs_panel" style="display: none;">
                        <div class="row justify-content-between">
                            <div class="col-md-4">
                                <h6>
                                    <?php echo Labels::getLabel('LBL_Custom_fields_form', $adminLangId); ?>
                                </h6>
                                <div id="custom-fields-form-js"></div>
                            </div>
                            <div class="col-md-8">
                                <h6>
                                    <?php echo Labels::getLabel('LBL_Custom_fields', $adminLangId); ?>
                                </h6>
                                <div id="custom-fields-listing-js"></div>
                            </div>
                        </div>
                    </div>
                    <div id="tabs_003" class="tabs_panel" style="display: none;">
                        <div class="row">
                            <div class="col-md-8">
                                <div id="category-checkist-listing-js"></div>
                            </div>
                            <div class="col-md-4">
                                <h5>
                                    <?php echo Labels::getLabel('LBL_Checklist_Fields_Form', $adminLangId); ?>
                                </h5>
                                <div id="category-checkist-form-js"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- TAB SECTION END HERE -->
            </div>
        </section>
    </div>

</div>
<script>
$('input[name=banner_min_width]').val('<?php echo $bannerSizeArr['width'] ?>');
$('input[name=banner_min_height]').val('<?php echo $bannerSizeArr['height'] ?>');
$('input[name=logo_min_width]').val('<?php echo $iconSizeArr['width'] ?>');
$('input[name=logo_min_height]').val('<?php echo $iconSizeArr['height'] ?>');

$(document).ready(function() {
    var catAutocompleteArr = <?php echo json_encode($catAutocompleteArr); ?>;
    $('input[name=\'parent_category_name\']').autocomplete({
        minLength: 0,
        'classes': {
            "ui-autocomplete": "custom-ui-autocomplete"
        },
        source: catAutocompleteArr,
        select: function(event, ui) {
            $('input[name=\'prodcat_parent\']').val(ui.item.id);
        }
    }).focus(function() {
        $(this).autocomplete('search', $(this).val())
    });

    $('input[name=\'parent_category_name\']').change(function() {
        if ($(this).val() == '') {
            $("input[name='prodcat_parent']").val(0);
        }
    });

});

function clearTxt(obj) {
    $(obj).val('');
}
</script>
<?php if ($prodCatId > 0) { ?>
<script>
$(document).ready(function() {
    categoryImages(<?php echo $prodCatId; ?>, 'icon', 1, 0);
    categoryImages(<?php echo $prodCatId; ?>, 'banner', 1, 0)
});
</script>
<?php } ?>

<script>
var bannerPrefferedDimention = {
    1: '<?php echo Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' ' . $bannerSizeArr['width'] . 'x' . $bannerSizeArr['height'] ?>',
    2: '<?php echo Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' 1024x576' ?>',
    3: '<?php echo Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' 640x360'  ?>',
};
</script>