<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$typeIconArr = Plugin::getTypeIconArr() ?>
<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <h5><?php echo Labels::getLabel('LBL_PLUGINS', $adminLangId); ?>
                    </h5>
                    <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                </div>
                <div class="grid-layout tabs_nav_container vertical">
                    <div class="grid-layout-left">
                        <div class="card">
                            <div class="card-body p-0">
                                <div class="settings-inner">
                                    <ul class="settings-nav">
                                        <?php $count = 1;
                                        foreach ($plugins as $formType => $tabName) {
                                            $tabsId = 'tabs_' . $count; ?>
                                            <li class="settings-inner-item">
                                                <a class="settings-inner-link <?php echo ($activeTab == $formType) ? 'active' : '' ?>"
                                                    rel=<?php echo $tabsId; ?> href="javascript:void(0)"
                                                    onClick="searchPlugin(<?php echo $formType; ?>);"
                                                    data-formtype="<?php echo $formType; ?>">
                                                    <i class="settings-inner-icn">
                                                        <svg class="svg" width="18" height="18">
                                                            <use
                                                                xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-settings.svg#<?php echo $typeIconArr[$formType] ?>">
                                                            </use>
                                                        </svg>
                                                    </i>
                                                    <h6 class="settings-inner-title">
                                                        <?php echo $tabName; ?>
                                                    </h6>
                                                </a>
                                            </li>
                                            <?php $count++;
                                        } ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="grid-layout-right" id="pluginsListing">
                        <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>