<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-12">
                            <h5><?php echo Labels::getLabel('LBL_Pickup_Addresses', $adminLangId); ?></h5>
                            <div class="breadcrumb-wrap">
                            <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                                <a href="javascript:void(0)" class="btn btn-icon btn-outline-brand js-add-pickup-addr" onclick="addAddressForm(0, '<?php echo $adminLangId; ?>')" title="<?php echo Labels::getLabel('LBL_Add_Keyword', $adminLangId); ?>" data-bs-toggle="tooltip" data-placement="top" data-bs-original-title="<?php echo Labels::getLabel('LBL_Add_Keyword', $adminLangId); ?>">
                                    <svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                        <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                        <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                    </svg>
                                    <span><?php echo Labels::getLabel('Lbl_New', $adminLangId) ?></span>        
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <section class="card section">
                    <div class="card-head">
                        <h4 class="label-js">
                            <a href="javascript:void(0);" onclick="searchAddresses()" 
                            class="js-pickup-addr btn-back d-none" title="<?php echo Labels::getLabel('LBL_Back_To_pickup_Addresses', $adminLangId); ?>">
                                <svg class="svg" width="24" height="24">
                                    <use xlink:href="<?php echo CONF_WEBROOT_FRONTEND; ?>images/admin/retina/sprite-actions.svg#back">
                                    </use>
                                </svg>
                            </a>
                            <?php echo Labels::getLabel('LBL_PICKUP_ADDRESSES_LIST', $adminLangId); ?>
                        </h4>
                        <?php
                        if ($canEdit) {
                            $data = [
                                'adminLangId' => $adminLangId,
                                'statusButtons' => false,
                                'deleteButton' => false,
                                'otherButtons' => [
                                    /* [
                                        'attr' => [
                                            'href' => 'javascript:void(0)',
                                            'onclick' => 'addAddressForm(0,' . $adminLangId . ')',
                                            'class' => 'js-add-pickup-addr',
                                            'title' => Labels::getLabel('LBL_Add_Pickup_Address', $adminLangId)
                                        ],
                                        'label' => '<svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                    <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                </svg>'
                                    ], */
                                    /* [
                                        'attr' => [
                                            'href' => 'javascript:void(0)',
                                            'onclick' => 'searchAddresses()',
                                            'class' => 'js-pickup-addr d-none',
                                            'title' => Labels::getLabel('LBL_Back_To_pickup_Addresses', $adminLangId)
                                        ],
                                        'label' => '<i class="fas fa-arrow-left"></i>'
                                    ], */
                                ]
                            ];

                            $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        }
                        ?>
                    </div>
                    <div class="card-table">
                        <div id="listing"> <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?></div>
                    </div>
                </section>
            </div>
        </div> 
    </div>
</div>