<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div class='page'>
    <div class='content content-space'>
        <div class="row">
            <div class="col-lg-12 col-md-12 space">
                <div class="page-title">
                    <div class="row">
                        <div class="col--first col-lg-6">

                            <h5><?php echo Labels::getLabel('LBL_Manage_Orders', $adminLangId); ?> </h5>
                            <?php
                            $breadcrumbData = [];
                            if ($isRentalOrder) {
                                $breadcrumbData['hrefRental'] = '/rental';
                            }
                            $this->includeTemplate('_partial/header/header-breadcrumb.php', $breadcrumbData);
                            ?>
                        </div>
                    </div>
                </div>
                <section class="card searchform_filter advance-search">
                    <div class="card-head">
                        <h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?></h4>
                    </div>
                    <div class="card-body extra togglewrap">
                        <?php
                        $frmSearch->setFormTagAttribute('onsubmit', 'searchOrders(this,1); return(false);');
                        $frmSearch->setFormTagAttribute('class', 'form web_form');
                        $frmSearch->developerTags['colClassPrefix'] = 'col-md-';
                        $frmSearch->developerTags['fld_default_col'] = 12;

                        $keywordFld = $frmSearch->getField('keyword');
                        $keywordFld->developerTags['col'] = 4;
                        $keywordFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Search_in_Order_Id,_Customer_Name,_Customer_Username_and_Customer_Email_Id', $adminLangId) . '</small>';

                        $buyerFld = $frmSearch->getField('buyer');
                        $buyerFld->developerTags['col'] = 4;
                        $buyerFld->htmlAfterField = '<small class="text--small form-text text-muted"></small>';

                        $statusFld = $frmSearch->getField('order_payment_status');
                        $statusFld->developerTags['col'] = 4;

                        $dateFromFld = $frmSearch->getField('date_from');
                        $dateFromFld->setFieldTagAttribute('class', 'calender field--calender');
                        $dateFromFld->developerTags['col'] = 2;

                        $dateToFld = $frmSearch->getField('date_to');
                        $dateToFld->setFieldTagAttribute('class', 'calender field--calender');
                        $dateToFld->developerTags['col'] = 2;

                        $priceFromFld = $frmSearch->getField('price_from');
                        $priceFromFld->developerTags['col'] = 2;

                        $priceToFld = $frmSearch->getField('price_to');
                        $priceToFld->developerTags['col'] = 2;

                        $submitBtnFld = $frmSearch->getField('btn_submit');
                        $submitBtnFld->developerTags['col'] = 4;

                        $btn_clear = $frmSearch->getField('btn_clear');
                        $btn_clear->addFieldTagAttribute('onclick', 'clearOrderSearch()');
                        echo $frmSearch->getFormHtml();
                        ?>
                    </div>
                </section>

                <section class="card section">
                    <div class="card-head">
                        <h4><?php echo Labels::getLabel('LBL_Customers_Orders_List', $adminLangId); ?> </h4>
                        <?php
                        $data = [
                            'adminLangId' => $adminLangId,
                            'statusButtons' => false,
                            'deleteButton' => false,
                            'otherButtons' => [
                                [
                                    'attr' => [
                                        'href' => 'javascript:void(0)',
                                        'onclick' => 'deletedOrders("' . $deletedOrderAction . '")',
                                        'title' => Labels::getLabel('LBL_Deleted_Orders', $adminLangId)
                                    ],
                                    'label' => '<svg class="svg" width="18" height="18"><use xlink:href="' . CONF_WEBROOT_FRONT_URL . 'images/admin/retina/sprite-actions.svg#archive"></use></svg>'
                                ],
                            ]
                        ];

                        $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        ?>
                    </div>
                    <div class="card-table">
                        <div id="ordersListing">
                            <?php echo Labels::getLabel('LBL_Processing...', $adminLangId); ?>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
</div>