<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="card-head">
    <h4><?php echo Labels::getLabel('LBL_Navigations', $adminLangId); ?> </h4>
    <?php
    if ($canEdit) {
        $data = [
            'adminLangId' => $adminLangId,
            'deleteButton' => false
        ];

        $this->includeTemplate('_partial/action-buttons.php', $data, false);
    }
    ?>
</div>
<div class="card-table">
    <div class="table-responsive table-scrollable js-scrollable tablewrap">
        <?php
        $arr_flds = array(
            'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
            'listserial' => Labels::getLabel('LBL_#', $adminLangId),
            'nav_identifier' => Labels::getLabel('LBL_Title', $adminLangId),
            'nav_active' => Labels::getLabel('LBL_Status', $adminLangId),
            'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
        );
        if (!$canEdit) {
            unset($arr_flds['select_all'], $arr_flds['action']);
        }
        $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
        $th = $tbl->appendElement('thead')->appendElement('tr');
        foreach ($arr_flds as $key => $val) {
            if ('select_all' == $key) {
                $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
            } else {
                $e = $th->appendElement('th', array(), $val);
            }
        }

        $sr_no = 0;
        foreach ($arr_listing as $sn => $row) {
            $sr_no++;
            $tr = $tbl->appendElement('tr', array());
            foreach ($arr_flds as $key => $val) {
                $td = $tr->appendElement('td');
                switch ($key) {
                    case 'select_all':
                        $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="nav_ids[]" value=' . $row['nav_id'] . '></label>', true);
                        break;
                    case 'listserial':
                        $td->appendElement('plaintext', array(), $sr_no);
                        break;
                    case 'nav_identifier':
                        if ($row['nav_name'] != '') {
                            $td->appendElement('plaintext', array(), $row['nav_name'], true);
                            $td->appendElement('br', array());
                            $td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                        } else {
                            $td->appendElement('plaintext', array(), $row[$key], true);
                        }
                        break;
                    case 'nav_active':
                        $active = "";
                        if ($row['nav_active']) {
                            $active = 'checked';
                        }
                        $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                        $statusClass = ($canEdit === false) ? 'disabled' : '';
                        $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                         <input ' . $active . ' type="checkbox" id="switch' . $row['nav_id'] . '" value="' . $row['nav_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                        </label>';
                        $td->appendElement('plaintext', array(), $str, true);
                        break;
                    case 'action':
                        $actionArr = [];
                        if ($canEdit) {
                            $actionArr[] = [
                                "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                "onclick" => "addFormNew(" . $row['nav_id'] . ")"
                            ];
                        }

                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Pages', $adminLangId),
                            "icon" => '<svg class="svg" width="16" height="16" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M2 18H9V20H2V18ZM2 11H11V13H2V11ZM2 4H22V6H2V4ZM20.674 13.0251L21.8301 12.634L22.8301 14.366L21.914 15.1711C21.9704 15.4386 22 15.7158 22 16C22 16.2842 21.9704 16.5614 21.914 16.8289L22.8301 17.634L21.8301 19.366L20.674 18.9749C20.2635 19.3441 19.7763 19.6295 19.2391 19.8044L19 21H17L16.7609 19.8044C16.2237 19.6295 15.7365 19.3441 15.326 18.9749L14.1699 19.366L13.1699 17.634L14.086 16.8289C14.0296 16.5614 14 16.2842 14 16C14 15.7158 14.0296 15.4386 14.086 15.1711L13.1699 14.366L14.1699 12.634L15.326 13.0251C15.7365 12.6559 16.2237 12.3705 16.7609 12.1956L17 11H19L19.2391 12.1956C19.7763 12.3705 20.2635 12.6559 20.674 13.0251ZM18 17C18.5523 17 19 16.5523 19 16C19 15.4477 18.5523 15 18 15C17.4477 15 17 15.4477 17 16C17 16.5523 17.4477 17 18 17Z"></path></svg>',
                            "onclick" => "pages(" . $row['nav_id'] . ")"
                        ];
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['nav_id']], false);
                        break;
                    default:
                        $td->appendElement('plaintext', array(), $row[$key], true);
                        break;
                }
            }
        }

        $frm = new Form('frmNavListing', array('id' => 'frmNavListing'));
        $frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
        $frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
        $frm->setFormTagAttribute('action', UrlHelper::generateUrl('Navigations', 'toggleBulkStatuses'));
        $frm->addHiddenField('', 'status');

        echo $frm->getFormTag();
        echo $frm->getFieldHtml('status');
        echo $tbl->getHtml();
        if (count($arr_listing) == 0) {
            $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
        }
        ?>
        </form>
    </div>
</div>