<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    // 'listserial' => '',
    'user_profile' => Labels::getLabel('LBL_By_User', $adminLangId),
    'message_text' => Labels::getLabel('LBL_Message', $adminLangId),
    'message_date' => Labels::getLabel('LBL_Date', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));

$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr');

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                /*$img = '<img src="'.UrlHelper::generateUrl('Image','user',array($row['message_sent_by'],'THUMB',true),CONF_WEBROOT_FRONT_URL).'" />';
                                $td->appendElement('plaintext', array(), $img ,true); */
                break;

            case 'message_text': 
                $messageText =  $row[$key];
                $attachedFile = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_MESSAGE_ATTACHMENTS, $row['message_id']);
                if (!empty($attachedFile)) {
                    foreach ($attachedFile as $val) {
                        $messageText .= '<br/><a class="link-brand link-underline" href="'. UrlHelper::generateUrl('Messages', 'downloadAttachedFileMsg', array(CommonHelper::encryptId($val['afile_id']),  $row['thread_id'])).'">'.$val['afile_name'].'</a>';
                    }
                }

                $td->appendElement('plaintext', array(), $messageText, true);
                
                break;
            case 'user_profile':

                $div_profile = $td->appendElement('div', array('class' => 'user-profile'));
                $div_about_me = $div_profile->appendElement('div', array('class' => 'avtar avtar-sm'));
                if ($row['message_from_shop_name'] != '' && $row['message_from_shop_id'] > 0) {
                    $userImgUpdatedOn = Shop::getAttributesById($row['message_from_shop_id'], 'shop_updated_on');
                    $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);
                    $div_about_me->appendElement('img', array('src' => UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'shopLogo', array($row['message_from_shop_id'], $adminLangId, 'MINI'), CONF_WEBROOT_FRONT_URL)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'));
                } else {
                    $userImgUpdatedOn = User::getAttributesById($row['message_sent_by'], 'user_updated_on');
                    $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);
                    $div_about_me->appendElement('img', array('src' => UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Image', 'user', array($row['message_sent_by'], 'MINI', true), CONF_WEBROOT_FRONT_URL)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'));
                }

                $div_profile_data = $div_profile->appendElement('div', array('class' => 'user-profile-data'));
                

                // $div_profile_data->appendElement('plaintext', array(), '<span>' . $row["message_date"] . '</span>', true);

                $sentByUserName = "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['message_sent_by'] . ")'>" . $row['message_sent_by_username'] . "</a>";

                if ($row['message_from_shop_name'] != '') {
                    $div_profile_data->appendElement('plaintext', array(), '<span>' . $row['message_from_shop_name'] . ' (' . $sentByUserName . ')' . '</span>', true);

                } else {
                    $div_profile_data->appendElement('plaintext', array(), '<span>' . $sentByUserName . '</span>', true);
                }
                // $div_profile_data->appendElement('plaintext', array(), '<p id="' . $row["message_id"] . '">' . nl2br($row["message_text"]) . '</p>', true);

                break;
            case 'action':
                if (!empty($canEditMessages)) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "messageForm(" . $row['message_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteRecord(" . $row['message_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['message_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
/* echo FatUtility::createHiddenFormFromData ( $postedData, array (
        'name' => 'frmShipDurationSrchPaging'
) ); */
/* $pagingArr=array('pageCount'=>$pageCount,'page'=>$page,'recordCount'=>$recordCount,'adminLangId'=>$adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr,false); */
