<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'mshipapi_sduration_id' => Labels::getLabel('LBL_Duration', $adminLangId),
    'mshipapi_volume_upto' => Labels::getLabel('LBL_Volume(cc)', $adminLangId),
    'mshipapi_weight_upto' => Labels::getLabel('LBL_Weight(gm)', $adminLangId),
    'mshipapi_zip' => Labels::getLabel('LBL_Postal_Code', $adminLangId),
    'mshipapi_state_id' => Labels::getLabel('LBL_State', $adminLangId),
    'mshipapi_country_id' => Labels::getLabel('LBL_Country', $adminLangId),
    'mshipapi_cost' => Labels::getLabel('LBL_Cost', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));

$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no, true);
                break;
            case 'mshipapi_state_id':
                $td->appendElement('plaintext', array(), $row['state_name'], true);
                break;
            case 'mshipapi_country_id':
                $td->appendElement('plaintext', array(), $row['country_name'], true);
                break;
            case 'mshipapi_sduration_id':
                $td->appendElement('plaintext', array(), $row['sduration_name'], true);
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" =>  "manualShippingForm(" . $row['mshipapi_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteRecord(" . $row['mshipapi_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['mshipapi_id']], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmManualShippingSrchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
