<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); /* CommonHelper::printArray(json_encode( array_values($dashboardInfo['signupsChartData']) ));die; */ ?>
<script type="text/javascript">
    $SalesChartKey = <?php echo json_encode(array_keys($dashboardInfo['salesChartData'])); ?>;
    $SalesChartVal = <?php echo json_encode(array_values($dashboardInfo['salesChartData'])); ?>;

    $RentalChartKey = <?php echo json_encode(array_keys($dashboardInfo['rentalChartData'])); ?>;
    $RentalChartVal = <?php echo json_encode(array_values($dashboardInfo['rentalChartData'])); ?>;

    $signupsKey = <?php echo json_encode(array_keys($dashboardInfo['signupsChartData'])); ?>;
    $signupsVal = <?php echo json_encode(array_values($dashboardInfo['signupsChartData'])); ?>;
    $SalesEarningsKey = <?php echo json_encode(array_keys($dashboardInfo['salesEarningsChartData'])); ?>;
    $SalesEarningsVal = <?php echo json_encode(array_values($dashboardInfo['salesEarningsChartData'])); ?>;

    $RentalEarningsKey = <?php echo json_encode(array_keys($dashboardInfo['rentalEarningsChartData'])); ?>;
    $RentalEarningsVal = <?php echo json_encode(array_values($dashboardInfo['rentalEarningsChartData'])); ?>;

    $affiliateSignupsKey = <?php echo json_encode(array_keys($dashboardInfo['affiliateSignupsChartData'])) ?>;
    $affiliateSignupsVal = <?php echo json_encode(array_values($dashboardInfo['affiliateSignupsChartData'])) ?>;
    $productsKey = <?php echo json_encode(array_keys($dashboardInfo['productsChartData'])) ?>;
    $productsVal = <?php echo json_encode(array_values($dashboardInfo['productsChartData'])) ?>;
</script>
<script type="text/javascript" src="https://www.google.com/jsapi"></script>
<?php if ($canView) { ?>

    <!--main panel start here-->
    <div class="page">
        <div class="content content-space dashboard-grids">
            <div class="commerce-grid">
                <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                    <div class="card card-flush commerce-card card-commerce-bg"
                        style="background-image: url(../images/admin/bg/card-commerce-bg-1.png)">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title"> <?php echo Labels::getLabel('LBL_Order_Sales', $adminLangId); ?>
                                </h3>
                            </div>
                        </div>
                        <div class="card-body">
                            <img src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/stats_icon_1.svg" alt=""
                                class="commerce-card-icon">

                            <h3 class="counter"><?php echo $dashboardInfo["stats"]["totalSales"][4]["totalsales"] ?? 0; ?></h3>
                            <p class="commerce-card-stats">
                                <?php echo Labels::getLabel('LBL_This_Month', $adminLangId); ?>-
                                <strong class="badge badge-success font-bold">
                                    <?php echo CommonHelper::displayMoneyFormat($dashboardInfo["stats"]["totalSales"][2]["totalsales"]); ?>
                                </strong>
                            </p>
                            <?php if ($objPrivilege->canViewOrders(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                <a href="<?php echo UrlHelper::generateUrl('orders'); ?>" class="stats__link">

                                </a>
                            <?php } ?>

                        </div>
                    </div>
                <?php } ?>
                <div class="card card-flush commerce-card card-commerce-bg"
                    style="background-image: url(../images/admin/bg/card-commerce-bg-2.png)">
                    <div class="card-head">
                        <div class="card-head-label">
                            <h3 class="card-head-title"> <?php echo Labels::getLabel('LBL_Order_Rentals', $adminLangId); ?>
                            </h3>
                        </div>
                    </div>
                    <div class="card-body">
                        <img src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/stats_icon_1.svg" alt=""
                            class="commerce-card-icon">
                        <h3 class="counter"><?php echo $dashboardInfo["stats"]["totalRental"][4]["totalsales"] ?? 0; ?></h3>
                        <p class="commerce-card-stats">
                            <?php echo Labels::getLabel('LBL_This_Month', $adminLangId); ?>-
                            <strong class="badge badge-success font-bold">
                                <?php echo CommonHelper::displayMoneyFormat($dashboardInfo["stats"]["totalRental"][2]["totalsales"]); ?>
                            </strong>
                        </p>
                        <?php if ($objPrivilege->canViewOrders(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <a href="<?php echo CommonHelper::generateUrl('orders', 'rental'); ?>" class="stats__link"></a>
                        <?php } ?>

                    </div>
                </div>
                <?php if (FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
                    <div class="card card-flush commerce-card card-commerce-bg"
                        style="background-image: url(../images/admin/bg/card-commerce-bg-4.png)">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title"> <?php echo Labels::getLabel('LBL_Sales_Earnings', $adminLangId); ?>
                                </h3>
                            </div>
                        </div>
                        <div class="card-body">
                            <img src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/stats_icon_2.svg" alt=""
                                class="commerce-card-icon">

                            <h3 class="counter"><?php echo $dashboardInfo["stats"]["totalSales"][4]["totalcommission"] ?? 0; ?>
                            </h3>
                            <p class="commerce-card-stats">
                                <?php echo Labels::getLabel('LBL_This_Month', $adminLangId); ?>-
                                <strong class="badge badge-success font-bold">
                                    <?php echo CommonHelper::displayMoneyFormat($dashboardInfo["stats"]["totalSales"][2]["totalcommission"]) ?>
                                </strong>
                            </p>
                            <?php if ($objPrivilege->canViewSalesReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                                <a href="<?php echo UrlHelper::generateUrl('salesReport'); ?>" class="stats__link"></a>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
                <div class="card card-flush commerce-card card-commerce-bg"
                    style="background-image: url(../images/admin/bg/card-commerce-bg-4.png)">
                    <div class="card-head">
                        <div class="card-head-label">
                            <h3 class="card-head-title">
                                <?php echo Labels::getLabel('LBL_Rental_Earnings', $adminLangId); ?>
                            </h3>
                        </div>
                    </div>
                    <div class="card-body">
                        <img src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/stats_icon_2.svg" alt=""
                            class="commerce-card-icon">

                        <?php //echo "<pre>"; print_r($dashboardInfo); echo "</pre>"; exit; 
                            ?>

                        <h3 class="counter"><?php echo $dashboardInfo["stats"]["totalRental"][4]["totalcommission"] ?? 0; ?>
                        </h3>
                        <p class="commerce-card-stats">
                            <?php echo Labels::getLabel('LBL_This_Month', $adminLangId); ?>-
                            <strong class="badge badge-success font-bold">
                                <?php echo CommonHelper::displayMoneyFormat($dashboardInfo["stats"]["totalRental"][2]["totalcommission"]) ?>
                            </strong>
                        </p>
                        <?php if ($objPrivilege->canViewSalesReport(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <a href="<?php echo CommonHelper::generateUrl('rentalsReport'); ?>" class="stats__link"></a>
                        <?php } ?>
                    </div>
                </div>
                <div class="card card-flush commerce-card card-commerce-bg"
                    style="background-image: url(../images/admin/bg/card-commerce-bg-1.png)">
                    <div class="card-head">
                        <div class="card-head-label">
                            <h3 class="card-head-title"><?php echo Labels::getLabel('LBL_New_Users', $adminLangId); ?></h3>
                        </div>
                    </div>

                    <div class="card-body">
                        <img src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/stats_icon_3.svg" alt=""
                            class="commerce-card-icon">

                        <h3 class="counter"><?php echo $dashboardInfo["stats"]["totalUsers"]['-1'] ?? 0; ?></h3>
                        <p class="commerce-card-stats">
                            <?php echo Labels::getLabel('LBL_This_Month', $adminLangId); ?>-
                            <strong class="badge badge-success font-bold">
                                <?php echo $dashboardInfo["stats"]["totalUsers"]['30']; ?>
                            </strong>
                        </p>
                        <?php if ($objPrivilege->canViewUsers(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <a href="<?php echo UrlHelper::generateUrl('users'); ?>" class="stats__link"></a>
                        <?php } ?>
                    </div>
                </div>
                <div class="card card-flush commerce-card card-commerce-bg"
                    style="background-image: url(../images/admin/bg/card-commerce-bg-2.png)">
                    <div class="card-head">
                        <div class="card-head-label">
                            <h3 class="card-head-title"> <?php echo Labels::getLabel('LBL_New_Shops', $adminLangId); ?></h3>
                        </div>
                    </div>
                    <div class="card-body">
                        <img src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/stats_icon_4.svg" alt=""
                            class="commerce-card-icon">

                        <h3 class="counter"><?php echo $dashboardInfo["stats"]["totalShops"]['-1'] ?? 0 ?></h3>
                        <p class="commerce-card-stats">
                            <?php echo Labels::getLabel('LBL_This_Month', $adminLangId); ?>-
                            <strong class="badge badge-success font-bold">
                                <?php echo $dashboardInfo["stats"]["totalShops"]['30'] ?>
                            </strong>
                        </p>
                        <?php if ($objPrivilege->canViewShops(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                            <a href="<?php echo UrlHelper::generateUrl('shops'); ?>" class="stats__link"></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
            <?php $dNoneClass = (!FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) ? 'd-none' : '';
            $activeClass = (!FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) ? 'active' : ''; ?>
            <div class="gap"></div>
            <div class="row">
                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-head card-tabs">
                            <div class="card-head-label">
                                <h3 class="card-head-title"><?php echo Labels::getLabel('LBL_Statistics', $adminLangId); ?>
                                </h3>
                            </div>
                            <div class="card-head-toolbar">
                                <ul class="nav-tabs nav-tabs-line nav">
                                    <li class="nav-tabs-item <?php echo $dNoneClass; ?>">
                                        <a class="nav-tabs-link active" rel="tabs_1" data-chart="true"
                                            href="javascript:void(0)">
                                            <?php echo Labels::getLabel('LBL_Sales', $adminLangId); ?></a>
                                    </li>
                                    <li class="nav-tabs-item <?php echo $dNoneClass; ?>"><a class="nav-tabs-link"
                                            rel="tabs_2" data-chart="true" href="javascript:void(0)">
                                            <?php echo Labels::getLabel('LBL_Sales_Earnings', $adminLangId); ?></a></li>
                                    <!-- [ RENTAL UPDATES -->
                                    <li class="nav-tabs-item "><a class="nav-tabs-link <?php echo $activeClass; ?>"
                                            rel="tabs_6" data-chart="true" href="javascript:void(0)">
                                            <?php echo Labels::getLabel('LBL_Rental', $adminLangId); ?></a></li>
                                    <li class="nav-tabs-item "><a class="nav-tabs-link" rel="tabs_7" data-chart="true"
                                            href="javascript:void(0)">
                                            <?php echo Labels::getLabel('LBL_Rental_Earnings', $adminLangId); ?></a></li>
                                    <!-- ] -->
                                    <li class="nav-tabs-item "><a class="nav-tabs-link" rel="tabs_3" data-chart="true"
                                            href="javascript:void(0)">
                                            <?php echo Labels::getLabel('LBL_Buyer/Seller_Signups', $adminLangId); ?></a>
                                    </li>
                                    <?php /* <li><a rel="tabs_4" data-chart="true" href="javascript:void(0)">
<?php echo Labels::getLabel('LBL_Affiliate_Signups', $adminLangId); ?></a></li>
                               */ ?>
                                    <li class="nav-tabs-item "><a class="nav-tabs-link" rel="tabs_5" data-chart="true"
                                            href="javascript:void(0)">
                                            <?php echo Labels::getLabel('LBL_Products', $adminLangId); ?></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-body">
                            <!--tab1 start here-->
                            <div id="tabs_1" class="tabs_panel <?php echo $dNoneClass; ?>"
                                style="width:100%;height:100%; display:block;">
                                <div id="monthlysales--js" class="ct-chart graph--sales"></div>
                            </div>
                            <!--tab1 end here-->
                            <!--tab2 start here-->

                            <div id="tabs_2" class="tabs_panel <?php echo $dNoneClass; ?>" style="width:100%;height:100%">
                                <div id="monthlysalesearnings--js" class="ct-chart graph--sales">
                                </div>
                            </div>
                            <!--tab2 end here-->
                            <!--tab3 start here-->

                            <div id="tabs_3" class="tabs_panel" style="width:100%;height:100%">
                                <div id="monthly-signups--js" class="ct-chart graph--sales"></div>
                            </div>
                            <!--tab3 end here-->
                            <!-- tab4 [ -->

                            <?php /* <div id="tabs_4" class="tabs_panel" style="width:100%;height:100%">
<div id="monthly-affiliate-signups--js" class="ct-chart graph--sales"></div>
</div> */ ?>
                            <!-- ] -->
                            <!-- tab5 [ -->

                            <div id="tabs_5" class="tabs_panel" style="width:100%;height:100%">
                                <div id="monthly-products--js" class="ct-chart graph--sales">
                                </div>
                            </div>
                            <!-- ] -->

                            <!-- tab6 [ -->
                            <div id="tabs_6" class="tabs_panel" style="width:100%;height:100%;">
                                <div id="monthly-rental--js" class="ct-chart graph--sales"></div>
                            </div>
                            <!-- ] -->

                            <!-- tab7 [ -->

                            <div id="tabs_7" class="tabs_panel" style="width:100%;height:100%">
                                <div id="monthly-rental-earnings--js" class="ct-chart graph--sales">
                                </div>
                            </div>
                            <!-- ] -->

                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title"> <?php echo Labels::getLabel('LBL_Traffic', $adminLangId); ?>
                                </h3>
                            </div>
                            <div class="card-head-toolbar">
                                <!-- <div class="dropdown dropdown-inline">
                                    <button type="button"
                                        class="btn btn-hover-brand btn-elevate-hover btn-icon btn-sm btn-icon-md btn-circle"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <svg class="svg icn-svg" xmlns="http://www.w3.org/2000/svg" width="24px"
                                            height="24px" viewBox="0 0 24 24">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="5" y="5" width="5" height="5" rx="1" fill="currentColor"></rect>
                                                <rect x="14" y="5" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3"></rect>
                                                <rect x="5" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3"></rect>
                                                <rect x="14" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3">
                                                </rect>
                                            </g>
                                        </svg>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right dropdown-menu-anim">
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="traficSource('today')">
                                                <?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="traficSource('Weekly')">
                                                <?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javavoiipt:void(0)" onClick="traficSource('Monthly')">
                                                <?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="traficSource('Yearly')">
                                                <?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></a></li>
                                    </ul>
                                </div> -->
                                <select class="form-select form-select-sm" onchange="traficSource(this.value); return;">
                                    <option value="today"><?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></option>
                                    <option value="Weekly"><?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></option>
                                    <option value="Monthly"><?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></option>
                                    <option value="Yearly" selected><?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="graph-container">
                                <div id="piechart" class="ct-chart  graph--traffic"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="gap"></div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title">
                                    <?php echo Labels::getLabel('LBL_Visitors_Statistics', $adminLangId); ?>
                                </h3>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="graph-container">
                                <div id="visitsGraph" class="ct-chart  graph--visitor"></div>
                            </div>
                            <?php if ($dashboardInfo['visitsCount']) { ?>
                                <ul class="list-stats list-stats-double">
                                    <li class="list-stats-item">
                                        <span class="label"><?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></span>
                                        <span class="value"><?php echo $dashboardInfo['visitsCount']['today'] ?></span>
                                    </li>
                                    <li class="list-stats-item">
                                        <span class="label"><?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></span>
                                        <span class="value"><?php echo $dashboardInfo['visitsCount']['weekly'] ?></span>
                                    </li>
                                    <li class="list-stats-item">
                                        <span class="label"><?php echo Labels::getLabel('LBL_last_Month', $adminLangId); ?></span>
                                        <span class="value"><?php echo $dashboardInfo['visitsCount']['lastMonth'] ?></span>
                                    </li>
                                    <li class="list-stats-item">
                                        <span class="label"><?php echo Labels::getLabel('LBL_Last_3_Months', $adminLangId); ?></span>
                                        <span class="value"><?php echo $dashboardInfo['visitsCount']['last3Month'] ?></span>
                                    </li>
                                </ul>
                            <?php } ?>

                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title">
                                    <?php echo Labels::getLabel('LBL_Conversions_Statistics', $adminLangId); ?>
                                </h3>
                            </div>
                            <!--ul class="actions right">
                                        <li class="droplink">
                                            <a href="javascript:void(0)"><i class="ion-android-more-vertical icon"></i></a>
                                            <div class="dropwrap">
                                                <ul class="linksvertical">
                                                    <li><a href="javascript:void(0)"><?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></a></li>
                                                    <li><a href="javascript:void(0)"><?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></a></li>
                                                    <li><a href="javascript:void(0)"><?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></a></li>
                                                    <li><a href="javascript:void(0)"><?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></a></li>
                                                </ul>
                                            </div>
                                        </li>
                                    </ul-->
                        </div>
                        <div class="card-body">
                            <div class="graph-container">
                                <div id="conversionStats" class="ct-chart graph--conversion"></div>
                            </div>
                            <ul class="list-stats list-stats-double">
                                <li class="list-stats-item"><span class="label">
                                        <?php echo Labels::getLabel('LBL_Added_To_Cart', $adminLangId); ?>
                                    </span>
                                    <span class="value">
                                        <?php echo $dashboardInfo['conversionStats']['added_to_cart']['%age']; ?>% </span>
                                </li>
                                <li class="list-stats-item"><span class="label">
                                        <?php echo Labels::getLabel('LBL_Reached_Checkout', $adminLangId); ?></span>
                                    <span class="value">
                                        <?php echo $dashboardInfo['conversionStats']['reached_checkout']['%age']; ?>%
                                    </span>
                                </li>
                                <li class="list-stats-item"><span class="label">
                                        <?php echo Labels::getLabel('LBL_Purchased', $adminLangId); ?></span>
                                    <span class="value">
                                        <?php echo $dashboardInfo['conversionStats']['purchased']['%age']; ?>% </span>
                                </li>
                                <li class="list-stats-item"><span class="label">
                                        <?php echo Labels::getLabel('LBL_Cancelled', $adminLangId); ?></span>
                                    <span class="value">
                                        <?php echo $dashboardInfo['conversionStats']['cancelled']['%age']; ?>% </span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
            <div class="gap"></div>
            <div class="row">
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title">
                                    <?php echo Labels::getLabel('LBL_Top_Products', $adminLangId); ?>
                                </h3>
                            </div>
                            <div class="card-head-toolbar">
                                <!-- <div class="dropdown dropdown-inline">
                                    <button type="button"
                                        class="btn btn-hover-brand btn-elevate-hover btn-icon btn-sm btn-icon-md btn-circle"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <svg class="svg icn-svg" xmlns="http://www.w3.org/2000/svg" width="24px"
                                            height="24px" viewBox="0 0 24 24">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="5" y="5" width="5" height="5" rx="1" fill="currentColor"></rect>
                                                <rect x="14" y="5" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3">
                                                </rect>
                                                <rect x="5" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3">
                                                </rect>
                                                <rect x="14" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3">
                                                </rect>
                                            </g>
                                        </svg>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right dropdown-menu-anim">
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topProducts('Today')">
                                                <?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topProducts('Weekly')">
                                                <?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topProducts('Monthly')">
                                                <?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topProducts('Yearly')">
                                                <?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></a></li>
                                    </ul>
                                </div> -->
                                <select class="form-select form-select-sm" onchange="topProducts(this.value); return;">
                                    <option value="Today"><?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></option>
                                    <option value="Weekly"><?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></option>
                                    <option value="Monthly"><?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></option>
                                    <option value="Yearly" selected><?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="card-table">
                            <div class="scrollbar">
                                <ul class="list-stats list-stats-inline topProducts">
                                    <?php
                                    $count = 1;
                                    if (count($dashboardInfo['topProducts']) > 0) {
                                        foreach ($dashboardInfo['topProducts'] as $row) {
                                            if ($count > 11) {
                                                break;
                                            }
                                            ?>
                                            <li class="list-stats-item list-stats-flush">
                                                <span class="label">
                                                    <?php echo $row['product_name']; ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo $row['sold']; ?>
                                                    <?php echo Labels::getLabel('LBL_Sold', $adminLangId); ?>
                                                </span>
                                            </li>
                                            <?php
                                            $count++;
                                        }
                                    } else {
                                        ?>
                                        <li class="list-stats-item list-stats-flush">
                                            <?php
                                            $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
                                            ?>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title">
                                    <?php echo Labels::getLabel('LBL_Top_Search_Items', $adminLangId); ?>
                                </h3>
                            </div>
                            <div class="card-head-toolbar">
                                <!-- <div class="dropdown dropdown-inline">
                                    <button type="button"
                                        class="btn btn-hover-brand btn-elevate-hover btn-icon btn-sm btn-icon-md btn-circle"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <svg class="svg icn-svg" xmlns="http://www.w3.org/2000/svg" width="24px"
                                            height="24px" viewBox="0 0 24 24">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="5" y="5" width="5" height="5" rx="1" fill="currentColor"></rect>
                                                <rect x="14" y="5" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3"></rect>
                                                <rect x="5" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3"></rect>
                                                <rect x="14" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3">
                                                </rect>
                                            </g>
                                        </svg>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right dropdown-menu-anim">
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="getTopSearchKeyword('today')">
                                                <?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="getTopSearchKeyword('Weekly')">
                                                <?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="getTopSearchKeyword('Monthly')">
                                                <?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="getTopSearchKeyword('Yearly')">
                                                <?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></a></li>
                                    </ul>
                                </div> -->
                                <select class="form-select form-select-sm" onchange="getTopSearchKeyword(this.value); return;">
                                    <option value="Today"><?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></option>
                                    <option value="Weekly"><?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></option>
                                    <option value="Monthly"><?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></option>
                                    <option value="Yearly" selected><?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="card-table">
                            <div class="scrollbar">
                                <ul class="list-stats list-stats-inline topSearchKeyword">
                                    <?php
                                    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
                                    ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="card">
                        <div class="card-body p-0">
                            <ul class="social-stats">
                                <li class="social-stats-item">
                                    <div class="social-stats-social social-stats-social-fb">
                                        <div class="social-stats-icon">
                                            <img width="40"
                                                src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/social_1.svg" alt=""
                                                class="">
                                        </div>
                                        <div class="social-stats-detail">
                                            <h3 class="h3">
                                                <?php echo isset($dashboardInfo['socialVisits']['rows']['Facebook']['%age']) ? $dashboardInfo['socialVisits']['rows']['Facebook']['%age'] : 0; ?>%
                                            </h3>
                                            <p>
                                                <?php echo isset($dashboardInfo['socialVisits']['rows']['Facebook']['visit']) ? $dashboardInfo['socialVisits']['rows']['Facebook']['visit'] : 0; ?>
                                                <?php echo Labels::getLabel('LBL_Visitors', $adminLangId); ?>
                                            </p>
                                        </div>
                                    </div>

                                </li>
                                <li class="social-stats-item">
                                    <div class="social-stats-social social-stats-social-tw">
                                        <div class="social-stats-icon"> <img width="40"
                                                src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/social_4.svg" alt="">
                                        </div>
                                        <div class="social-stats-detail">
                                            <h3 class="h3">
                                                <?php echo isset($dashboardInfo['socialVisits']['rows']['LinkedIn']['%age']) ? $dashboardInfo['socialVisits']['rows']['LinkedIn']['%age'] : 0; ?>%
                                            </h3>
                                            <p>
                                                <?php echo isset($dashboardInfo['socialVisits']['rows']['LinkedIn']['visit']) ? $dashboardInfo['socialVisits']['rows']['LinkedIn']['visit'] : 0; ?>
                                                <?php echo Labels::getLabel('LBL_Visitors', $adminLangId); ?>
                                            </p>
                                        </div>
                                    </div>

                                </li>
                                <li class="social-stats-item">
                                    <div class="social-stats-social social-stats-social-li">
                                        <div class="social-stats-icon">
                                            <img width="40"
                                                src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/social_2.svg" alt="">
                                        </div>
                                        <div class="social-stats-detail">
                                            <h3 class="h3">
                                                <?php echo isset($dashboardInfo['socialVisits']['rows']['Twitter']['%age']) ? $dashboardInfo['socialVisits']['rows']['Twitter']['%age'] : 0; ?>%
                                            </h3>
                                            <p>
                                                <?php echo isset($dashboardInfo['socialVisits']['rows']['Twitter']['visit']) ? $dashboardInfo['socialVisits']['rows']['Twitter']['visit'] : 0; ?>
                                                <?php echo Labels::getLabel('LBL_Visitors', $adminLangId); ?>
                                            </p>
                                        </div>
                                    </div>
                                </li>
                                <li class="social-stats-item">
                                    <div class="social-stats-social social-stats-social-gp">
                                        <div class="social-stats-icon">
                                            <img width="40"
                                                src="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/social_6.svg" alt="">
                                        </div>
                                        <div class="social-stats-detail">
                                            <h3 class="h3">
                                                <?php echo isset($dashboardInfo['socialVisits']['rows']['Instagram']['%age']) ? $dashboardInfo['socialVisits']['rows']['Instagram']['%age'] : 0; ?>%
                                            </h3>
                                            <p>
                                                <?php echo isset($dashboardInfo['socialVisits']['rows']['Instagram']['visit']) ? $dashboardInfo['socialVisits']['rows']['Instagram']['visit'] : 0; ?>
                                                <?php echo Labels::getLabel('LBL_Visitors', $adminLangId); ?>
                                            </p>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>


            <div class="gap"></div>
            <div class="row">
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title">
                                    <?php echo Labels::getLabel('LBL_Top_Referrers', $adminLangId); ?>
                                </h3>
                            </div>
                            <div class="card-head-toolbar">
                                <!-- <div class="dropdown dropdown-inline">
                                    <button type="button"
                                        class="btn btn-hover-brand btn-elevate-hover btn-icon btn-sm btn-icon-md btn-circle"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <svg class="svg icn-svg" xmlns="http://www.w3.org/2000/svg" width="24px"
                                            height="24px" viewBox="0 0 24 24">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="5" y="5" width="5" height="5" rx="1" fill="currentColor"></rect>
                                                <rect x="14" y="5" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3">
                                                </rect>
                                                <rect x="5" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3">
                                                </rect>
                                                <rect x="14" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3">
                                                </rect>
                                            </g>
                                        </svg>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right dropdown-menu-anim">
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topReferers('today')">
                                                <?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topReferers('Weekly')">
                                                <?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topReferers('Monthly')">
                                                <?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topReferers('Yearly')">
                                                <?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></a></li>
                                    </ul>
                                </div> -->
                                <select class="form-select form-select-sm" onchange="topReferers(this.value); return;">
                                    <option value="Today"><?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></option>
                                    <option value="Weekly"><?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></option>
                                    <option value="Monthly"><?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></option>
                                    <option value="Yearly" selected><?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="card-table">
                            <div class="scrollbar">
                                <ul class="list-stats list-stats-inline topReferers">
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title">
                                    <?php echo Labels::getLabel('LBL_Top_Countries', $adminLangId); ?>
                                </h3>
                            </div>

                            <div class="card-head-toolbar">
                                <!-- <div class="dropdown dropdown-inline">
                                    <button type="button"
                                        class="btn btn-hover-brand btn-elevate-hover btn-icon btn-sm btn-icon-md btn-circle"
                                        data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <svg class="svg icn-svg" xmlns="http://www.w3.org/2000/svg" width="24px"
                                            height="24px" viewBox="0 0 24 24">
                                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                                <rect x="5" y="5" width="5" height="5" rx="1" fill="currentColor"></rect>
                                                <rect x="14" y="5" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3"></rect>
                                                <rect x="5" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3"></rect>
                                                <rect x="14" y="14" width="5" height="5" rx="1" fill="currentColor"
                                                    opacity="0.3"></rect>
                                            </g>
                                        </svg>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-right dropdown-menu-anim">
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topCountries('today')">
                                                <?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topCountries('Weekly')">
                                                <?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topCountries('Monthly')">
                                                <?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></a></li>
                                        <li class="dropdown-menu-item"><a class="dropdown-menu-link"
                                                href="javascript:void(0)" onClick="topCountries('Yearly')">
                                                <?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></a></li>
                                    </ul>
                                </div> -->
                                <select class="form-select form-select-sm" onchange="topCountries(this.value); return;">
                                    <option value="Today"><?php echo Labels::getLabel('LBL_Today', $adminLangId); ?></option>
                                    <option value="Weekly"><?php echo Labels::getLabel('LBL_Weekly', $adminLangId); ?></option>
                                    <option value="Monthly"><?php echo Labels::getLabel('LBL_Monthly', $adminLangId); ?></option>
                                    <option value="Yearly" selected><?php echo Labels::getLabel('LBL_Yearly', $adminLangId); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="card-table">
                            <div class="scrollbar">
                                <ul class="list-stats list-stats-inline topCountries ">
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="gap"></div>
            <div class="row">
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-head">
                            <div class="card-head-label">
                                <h3 class="card-head-title">
                                    <?php echo Labels::getLabel('LBL_Latest_Orders', $adminLangId); ?>
                                </h3>
                            </div>
                            <?php /* if ($objPrivilege->canViewOrders(AdminAuthentication::getLoggedAdminId(), true)) { ?>
                       <a class="themebtn btn-default btn btn-brand btn-sm" target='_new'
                           href="<?php echo UrlHelper::generateUrl('Orders'); ?>">
                           <?php echo Labels::getLabel('LBL_View_All', $adminLangId); ?></a>
                       <?php } */ ?>

                        </div>
                        <div class="card-table" id="latest-orders-js"> </div>
                    </div>
                </div>
            </div>
            <div class="gap"></div>
            <div class="row">
                <div class="col-sm-12">
                    <div class="card">
                        <div class="card-head card-tabs">
                            <div class="card-head-toolbar">
                                <ul class="nav-tabs nav-tabs-line">
                                    <li class="nav-tabs-item "><a class="nav-tabs-link active" rel="tabs_01"
                                            href="javascript:void(0)" onClick="searchStatistics('statistics', this)"><i
                                                class="icon ion-arrow-graph-up-right"></i>
                                            <?php echo Labels::getLabel("LBL_Statistics", $adminLangId); ?></a></li>
                                    <li class="nav-tabs-item "><a class="nav-tabs-link" rel="tabs_02"
                                            href="javascript:void(0)" onClick="searchStatistics('sellerproducts', this)"><i
                                                class="icon ion-bag"></i>
                                            <?php echo Labels::getLabel("LBL_Product_Inventories", $adminLangId); ?></a>
                                    </li>
                                    <li class="nav-tabs-item "><a class="nav-tabs-link" rel="tabs_03"
                                            href="javascript:void(0)" onClick="searchStatistics('shops', this)"><i
                                                class="icon ion-ios-cart"></i>
                                            <?php echo Labels::getLabel("LBL_Shops", $adminLangId); ?></a></li>
                                    <li class="nav-tabs-item "><a class="nav-tabs-link" rel="tabs_04"
                                            href="javascript:void(0)" onClick="searchStatistics('signups', this)"><i
                                                class="icon ion-android-person"></i>
                                            <?php echo Labels::getLabel("LBL_Buyer/Seller_Signups", $adminLangId); ?></a>
                                    </li>
                                    <li class="nav-tabs-item "><a class="nav-tabs-link" rel="tabs_05"
                                            href="javascript:void(0)" onClick="searchStatistics('advertisers', this)"><i
                                                class="icon ion-android-person"></i>
                                            <?php echo Labels::getLabel("LBL_Advertiser_Signups", $adminLangId); ?></a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="card-table">
                            <div class="tabs_panel_wrap">
                                <div id="tabs_01" class="tabs_panel data_panel"></div>
                                <!-- ] -->
                                <!-- Seller Products[ -->

                                <div id="tabs_02" class="tabs_panel"></div>
                                <!-- ] -->
                                <!--Shops List[ -->

                                <div id="tabs_03" class="tabs_panel"></div>
                                <!--] -->
                                <!-- Buyer/Seller List[ -->

                                <div id="tabs_04" class="tabs_panel"></div>
                                <!-- ] -->
                                <!-- Advertisers List[ -->

                                <div id="tabs_05" class="tabs_panel"></div>
                                <!-- ] -->
                                <!-- Affiliates List[ -->
                                <?php /* <span class="togglehead" rel="tabs_06">
<?php echo Labels::getLabel("LBL_Affiliates", $adminLangId); ?></span>
                           <div id="tabs_06" class="tabs_panel"></div> */ ?>
                                <!-- ] -->
                            </div>

                        </div>
                    </div>

                </div>
            </div>

        </div>
    </div>
<?php } else { ?>
    <div class="page">
        <div class="content content-space">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-stretch mb-0">
                        <div class="card-body">
                            <div class="block-empty">
                                <img width="100" class="block-empty-img" src="<?php echo CONF_WEBROOT_FRONT_URL . 'public/images/retina/empty/data-not-found.svg'; ?>" alt="">
                                <h3 class="block-empty-title"><?php echo Labels::getLabel('MSG_UNAUTHORISED_ACCESS!', $adminLangId); ?></h3>
                                <p><?php echo CommonHelper::replaceStringData(Labels::getLabel('MSG_PLEASE_CONTACT_ADMIN_{BUSINESS-EMAIL}', $adminLangId), ['{BUSINESS-EMAIL}' => '<a target="_blank" href="mailto: ' . FatApp::getConfig("CONF_SITE_OWNER_EMAIL") . '">' . FatApp::getConfig("CONF_SITE_OWNER_EMAIL")]) . '</a>'; ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<script type="text/javascript">
    var dataCurrency = '<?php echo CommonHelper::getCurrencySymbol(true); ?>';
    var w = $('.tabs_panel_wrap').width();
    //callback function
    google.load('visualization', '1', {
        'packages': ['corechart', 'bar']
    });
    //set callback
    google.setOnLoadCallback(createChart);

    function createChart() {
        <?php /* if($configuredAnalytics){ */ ?>

        // Conversions Statistics
        var dataConversion = google.visualization.arrayToDataTable([
            <?php echo html_entity_decode($dashboardInfo['conversionChatData'], ENT_QUOTES, 'UTF-8'); ?>
        ]);
        var optionConversion = {
            width: $('#conversionStats').width(),
            height: 240,
            'color': '#AEC785',
            legend: {
                position: "none"
            },
        };
        <?php if ($layoutDirection == 'rtl') { ?>
            optionConversion['hAxis'] = {
                direction: '-1'
            };
            optionConversion['series'] = [{
                targetAxisIndex: 1
            }];
        <?php } ?>

        var conversion = new google.visualization.ColumnChart(document.getElementById('conversionStats'));
        <?php /* } */ ?>

        <?php /* if($configuredAnalytics){ */ ?>

        conversion.draw(dataConversion, optionConversion);
        <?php /* } */ ?>
    }

    <?php if (!FatApp::getConfig("CONF_ALLOW_SALE", FatUtility::VAR_INT, 0)) { ?>
        $(document).ready(function () {
            $('.nav-tabs li a.active').click();
        });
    <?php } ?>
</script>