<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'coupon_identifier' => Labels::getLabel('LBL_Coupon_Title', $adminLangId),
    'coupon_code' => Labels::getLabel('LBL_Coupon_Code', $adminLangId),
    'coupon_type' => Labels::getLabel('LBL_Coupon_Type', $adminLangId),
    'coupon_discount_value' => Labels::getLabel('LBL_Coupon_Discount', $adminLangId),
    'coupon_start_date' => Labels::getLabel('LBL_Available', $adminLangId),
    'coupon_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);

if (!$canEdit) {
    unset($arr_flds['action']);
}

$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');
    /* if($row['coupon_active'] != applicationConstants::ACTIVE) {
        $tr->setAttribute ("class","fat-inactive");
    } */
    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'coupon_identifier':
                if ($row['coupon_title'] != '') {
                    $td->appendElement('plaintext', array(), $row['coupon_title'], true);
                    $td->appendElement('br', array());
                    $td->appendElement('plaintext', array(), '(' . $row[$key] . ')', true);
                } else {
                    $td->appendElement('plaintext', array(), $row[$key], true);
                }
                break;
            case 'coupon_type':
                $td->appendElement('plaintext', array(), $discountTypeArr[$row[$key]], true);
                break;
            case 'coupon_discount_value':
                $discountValue = ($row['coupon_discount_in_percent'] == ApplicationConstants::PERCENTAGE) ? $row[$key] . ' %' : CommonHelper::displayMoneyFormat($row[$key]);
                $td->appendElement('plaintext', array(), $discountValue);
                break;
            case 'coupon_start_date':
                $couponStartDate = FatDate::format($row[$key]);
                $dateHtmlForStartDate = "";
                if (strpos($couponStartDate, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $couponStartDate);
                    $dateHtmlForStartDate = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtmlForStartDate = "<date class='date'>" . $couponStartDate . "</date>";
                }

                $couponEndDate = FatDate::format($row['coupon_end_date']);
                $dateHtmlForEndDate = "";
                if (strpos($couponEndDate, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $couponEndDate);
                    $dateHtmlForEndDate = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtmlForEndDate = "<date class='date'>" . $couponEndDate . "</date>";
                }

                $dispDate = $dateHtmlForStartDate . '<br>' . $dateHtmlForEndDate;

                $td->appendElement('plaintext', array(), $dispDate, true);
                break;
            case 'coupon_active':
                $isExpired = false;
                $isExpired = ($row['coupon_end_date'] != "0000-00-00" && strtotime($row['coupon_end_date']) < strtotime(date('Y-m-d'))) ? true : false;
                if ($isExpired) {
                    $td->appendElement('plaintext', array(), Labels::getLabel("LBL_Expired", $adminLangId), true);
                } else {
                    $active = "";
                    if ($row['coupon_active']) {
                        $active = 'checked';
                    }
                    $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(event,this,' . applicationConstants::NO . ')';
                    $statusClass = ($canEdit === false) ? 'disabled' : '';
                    $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">                 
                     <input ' . $active . ' type="checkbox" id="switch' . $row['coupon_id'] . '" value="' . $row['coupon_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                    </label>';
                    $td->appendElement('plaintext', array(), $str, true);
                }
                break;
            case 'action':
                if ($canEdit) {
                    if ($row['coupon_type'] != DiscountCoupons::TYPE_SELLER_PACKAGE) {
                        $linkFuncName = 'addCouponLinkProductForm';
                    } else {
                        $linkFuncName = 'addCouponLinkPlanForm';
                    }
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addCouponFormNew(" . $row['coupon_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Links', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#link'></use></svg>",
                            "onclick" => "$linkFuncName(" . $row['coupon_id'] . ")"
                        ]
                    ];
                }
                if ($canView) {
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_History', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#history'></use></svg>",
                        "onclick" => "couponHistory(" . $row['coupon_id'] . ")"
                    ];
                }
                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['coupon_id']], false);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmCouponSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
