<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$couponMediaFrm->setFormTagAttribute('class', 'form web_form form_horizontal');
$couponMediaFrm->developerTags['colClassPrefix'] = 'col-md-';
$couponMediaFrm->developerTags['fld_default_col'] = 12;
$fld = $couponMediaFrm->getField('coupon_image');
$fld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$fld->addFieldTagAttribute('onChange', 'popupImage(this)');
$langFld = $couponMediaFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'language-js');

$preferredDimensionsStr = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_This_will_be_displayed_on_your_store_in_ratio_of', $adminLangId).' 60*60' . '</small>';

$htmlAfterField = $preferredDimensionsStr;
$htmlAfterField .= '<div id="image-listing"></div>';
$fld->htmlAfterField = $htmlAfterField;

$recordId = (int) $coupon_id;

$tabsButtons = [
	[
		'attr' => [
			'onclick' => 'addCouponForm(' . $coupon_id . ');',
			'title' => Labels::getLabel('LBL_General', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_General', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => (0 < $recordId) ? 'addCouponLangForm("' . $recordId . '","' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . '")' : '',
			'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => (0 < $recordId) ? 'couponMediaForm("' . $recordId . '")' : '',
			'title' => Labels::getLabel('LBL_Media', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Media', $adminLangId),
		'isActive' => true
	],
];

$formTitle = Labels::getLabel('LBL_Coupon_Media_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<div class="">
	<div id="cropperBox-js"></div>
	<?php
	$tpl = new FatTemplate('', '');
	$tpl->set('adminLangId', $adminLangId);
	echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
	echo $couponMediaFrm->getFormHtml(); ?>
</div>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>