<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmProduct->setFormTagAttribute('class', 'form web_form form_horizontal');
$frmProduct->developerTags['colClassPrefix'] = 'col-md-';
$frmProduct->developerTags['fld_default_col'] = 12;
$fld = $frmProduct->getField('product_name');
$fld->setWrapperAttribute('class', 'ui-front');
$recordId = (int) $coupon_id;
$formTitle = Labels::getLabel('LBL_Coupon_Setup', $adminLangId);

$tabsButtons = [
	[
		'attr' => [
			'onclick' => 'couponLinkProductForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Products', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Products', $adminLangId),
		'isActive' => true
	],
	[
		'attr' => [
			'onclick' => 'couponLinkCategoryForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Categories', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Categories', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => 'couponLinkUserForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Users', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Users', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => 'couponLinkShopForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Shops', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Shops', $adminLangId),
		'isActive' => false
	],
	[
		'attr' => [
			'onclick' => 'couponLinkBrandForm(' . $recordId . ');',
			'title' => Labels::getLabel('LBL_Link_Brands', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Link_Brands', $adminLangId),
		'isActive' => false
	],
];
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php echo $frmProduct->getFormHtml(); ?>
<div id="coupon_products_list" class="col-xs-9 box-scroller"></div>

<script type="text/javascript">
	$("document").ready(function () {

		reloadCouponProduct(<?php echo $coupon_id; ?>);

		$('input[name=\'product_name\']').autocomplete({
			'classes': {
				"ui-autocomplete": "custom-ui-autocomplete"
			},
			'source': function (request, response) {
				$.ajax({
					url: fcom.makeUrl('Products', 'autoComplete'),
					data: { keyword: request['term'], fIsAjax: 1 },
					dataType: 'json',
					type: 'post',
					success: function (json) {
						response($.map(json, function (item) {
							return { label: item['name'], value: item['name'], id: item['id'] };
						}));
					},
				});
			},
			'select': function (event, ui) {
				updateCouponProduct(<?php echo $coupon_id; ?>, ui.item.id);
				$('input[name=\'product_name\']').val('');
				return false;
			}
		});

	});
</script>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>