<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'form web_form form_horizontal');
$frm->setFormTagAttribute('onsubmit', 'setupCoupon(this); return(false);');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;

$minOrder_fld = $frm->getField('coupon_min_order_value');
$minOrder_fld->setWrapperAttribute('id', 'coupon_minorder_div');

$ctype_fld = $frm->getField('coupon_type');
$ctype_fld->addFieldTagAttribute('onChange', 'callCouponTypePopulate(this.value); ');

$coupon_max_discount_value_fld = $frm->getField('coupon_max_discount_value');
$coupon_max_discount_value_fld->setWrapperAttribute('id', 'coupon_max_discount_value_div');

$discountValueFld = $frm->getField('coupon_discount_value');
$discountValueFld->addFieldTagAttribute('class', 'discountValue-js');

$coupon_discount_in_percent_fld = $frm->getField('coupon_discount_in_percent');
$coupon_discount_in_percent_fld->addFieldTagAttribute('onChange', 'callCouponDiscountIn(this.value, ' . applicationConstants::PERCENTAGE . ', ' . applicationConstants::FLAT . '); ');
$coupon_discount_in_percent_fld->addFieldTagAttribute('class', 'discountType-js');

$cvalid_fld = $frm->getField('coupon_valid_for');
$cvalid_fld->setWrapperAttribute('id', 'coupon_validfor_div');

$recordId = (int) $coupon_id;

$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'addCouponForm('.$coupon_id.');',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'addCouponLangForm("'.$recordId.'","'.FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1).'")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'couponMediaForm("'.$recordId.'")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => false
    ],
];

$formTitle = Labels::getLabel('LBL_Coupon_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php echo $frm->getFormHtml(); ?>
<script type="text/javascript">
    $(document).ready(function () {
        callCouponTypePopulate(<?php echo $coupon_type; ?>);
        callCouponDiscountIn(<?php echo $couponDiscountIn; ?>, <?php echo applicationConstants::PERCENTAGE; ?>, <?php echo applicationConstants::FLAT; ?>);
    });
    $(document).on('keyup', '.discountValue-js', function () {
        if ($('.discountType-js option:selected').val() == "<?php echo applicationConstants::PERCENTAGE; ?>" && $(this).val() > 100) {
            $(this).val(100);
            return false;
        }
    });
</script>
<?php 
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>
