<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$layout = Language::getLayoutDirection($langId);
if (count($productSpecifications) > 0) { ?>
    <div class="row" dir="<?php echo $layout; ?>">
        <div class="col-md-12">
            <div class="table-responsive table-scrollable js-scrollable tablewrap">
                <?php
                $arr_flds = array(
                    'prod_spec_name' => Labels::getLabel('LBL_Specification_Name', $adminLangId),
                    'prod_spec_file' => Labels::getLabel('LBL_Specification_File', $adminLangId),
                    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId)
                );

                $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-bordered table-justified'));
                $th = $tbl->appendElement('thead')->appendElement('tr');
                foreach ($arr_flds as $key => $val) {
                    if ($key == 'prodspec_name' || $key == 'prod_spec_value' || $key == 'prod_spec_group') {
                        $e = $th->appendElement('th', array('width' => '27%'), $val);
                    } else {
                        $e = $th->appendElement('th', array(), $val);
                    }
                }


                foreach ($productSpecifications as $keyData => $specification) {
                    $tr = $tbl->appendElement('tr');
                    foreach ($arr_flds as $key => $val) {
                        $td = $tr->appendElement('td');
                        switch ($key) {
                            case 'prod_spec_file':
                                $fileHtml = '';
                                $fileData = [];
                                if (FatUtility::int($specification['prod_spec_file_index']) > 0) {
                                    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_PRODUCT_REQUEST_SPECIFICATION_FILE, $preqId, $specification['prod_spec_file_index'], $adminLangId);
                                }

                                if (!empty($fileData)) {
                                    $fileArr = explode('.', $fileData['afile_name']);
                                    //$fileType = strtolower($fileArr[1]);
                                    $fileTypeIndex = count($fileArr) - 1;
                                    $fileType = strtolower($fileArr[$fileTypeIndex]);
                                    $imageTypes = array('gif', 'jpg', 'jpeg', 'png', 'svg', 'bmp', 'tiff');

                                    $attachmentUrl = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_REQUEST_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id']), CONF_WEBROOT_FRONT_URL);

                                    $fileHtml = '';
                                    if (in_array($fileType, $imageTypes)) {
                                        $imageUrl = CommonHelper::generateFullUrl('image', 'productSpecFile', array(AttachedFile::FILETYPE_PRODUCT_REQUEST_SPECIFICATION_FILE, $fileData['afile_record_id'], $fileData['afile_record_subid'], $fileData['afile_lang_id'], 50, 50), CONF_WEBROOT_FRONT_URL);

                                        $fileHtml = "<a href='" . $attachmentUrl . "' target='_blank' title='" . $fileData['afile_name'] . "'><img src='" . $imageUrl . "' class='img-thumbnail image-small' /> </a>";
                                    } else if ($fileData['afile_id'] != -1) {
                                        $fileHtml = "<a href='" . $attachmentUrl . "' title='" . $fileData['afile_name'] . "' download><svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#icon-download'></use></svg></a>";
                                    } else {
                                        $fileHtml = Labels::getLabel('LBL_File_does_not_exist', $adminLangId);
                                    }
                                }
                                $td->appendElement('plaintext', array(), $fileHtml, true);
                                break;

                            case 'action':
                                $actionArr = [
                                    [
                                        "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                                        "onclick" =>  'prodSpecificationMediaSection(' . $langId . ',' . $keyData . ')'
                                    ],
                                    [
                                        "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                                        "onclick" => 'deleteProdSpec(' . $keyData . ',' . $langId . ', 1)'
                                    ]
                                ];
                                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$keyData], false);
                                break;
                            default:
                                $td->appendElement('plaintext', array(), $specification[$key], true);
                                break;
                        }
                    }

                }
                echo $tbl->getHtml();
                ?>
            </div>
        </div>
    </div>
<?php } ?>