<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'dragdrop' => '',
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'currency_code' => Labels::getLabel('LBL_Currency', $adminLangId),
    'currency_symbol_left' => Labels::getLabel('LBL_Symbol_Left', $adminLangId),
    'currency_symbol_right' => Labels::getLabel('LBL_Symbol_Right', $adminLangId),
    'currency_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['dragdrop']);
    unset($arr_flds['select_all']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified', 'id' => 'currencyList'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = 0;
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr', array());
    $tr->setAttribute("id", $row['currency_id']);

    foreach ($arr_flds as $key => $val) {
        if ($key == 'currency_active') {
            $td = $tr->appendElement('td', array('width' => "20%"));
        } else {
            $td = $tr->appendElement('td');
        }

        switch ($key) {
            case 'dragdrop':
                if ($row['currency_active'] == applicationConstants::ACTIVE) {
                    $td->appendElement('svg', array('width'=>'16','height'=>'16'),"<use xlink:href='".CONF_WEBROOT_FRONT_URL."images/admin/retina/sprite.svg#drag-move-2'></use>",true);
                    $td->setAttribute("class", 'dragHandle');
                }
                break;
            case 'select_all':
                if ($row['currency_id'] != $defaultCurrencyId) {
                    $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="currency_ids[]" value=' . $row['currency_id'] . '></label>', true);
                }
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'currency_symbol_left':
                $td->appendElement('plaintext', array(), CommonHelper::displayNotApplicable($adminLangId, $row[$key]), true);
                break;
            case 'currency_symbol_right':
                $td->appendElement('plaintext', array(), CommonHelper::displayNotApplicable($adminLangId, $row[$key]), true);
                break;
            case 'currency_active':
                if ($row['currency_id'] == $defaultCurrencyId) {
                    $str = Labels::getLabel('LBL_Can_not_deactive_default_currency', $adminLangId);
                } else {
                    $active = "";
                    if ($row['currency_active']) {
                        $active = 'checked';
                    }
                    $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(this,' . applicationConstants::NO . ')';
                    $statusClass = ($canEdit === false) ? 'disabled' : '';
                    $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                    <input ' . $active . ' type="checkbox" id="switch' . $row['currency_id'] . '" value="' . $row['currency_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                    </label>';
                }

                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'currency_code':
                if ($row['currency_name'] != '') {
                    $default = ($row['currency_id'] == $defaultCurrencyId) ? '<span class="badge badge-info">' . Labels::getLabel('LBL_DEFAULT', $adminLangId) . '</span>' : '';
                    $td->appendElement('plaintext', array(), $row['currency_name'], true);
                    $td->appendElement('br', array());
                    $td->appendElement('plaintext', array(), '(' . $row[$key] . ') ' . $default, true);
                } else {
                    $td->appendElement('plaintext', array(), $row[$key], true);
                }
                break;
            case 'action':
                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "editCurrencyForm(" . $row['currency_id'] . ")"
                        ]
                    ];
                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId,'id'=>$row['country_id']??0], false);
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}


$frm = new Form('frmCurrencyListing', array('id' => 'frmCurrencyListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('CurrencyManagement', 'toggleBulkStatuses'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
</div>
<script>
$(document).ready(function() {
    $('#currencyList').tableDnD({
        onDrop: function(table, row) {
            fcom.displayProcessing();
            var order = $.tableDnD.serialize('id');
            fcom.ajax(fcom.makeUrl('CurrencyManagement', 'updateOrder'), order, function(res) {
                var ans = $.parseJSON(res);
                if (ans.status == 1) {
                    fcom.displaySuccessMessage(ans.msg);
                } else {
                    fcom.displayErrorMessage(ans.msg);
                }
            });
        },
        dragHandle: ".dragHandle",
    });
});
</script>