<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$blockLangFrm->setFormTagAttribute('class', 'form web_form layout--' . $formLayout);
$blockLangFrm->setFormTagAttribute('dir', $formLayout);
$blockLangFrm->developerTags['colClassPrefix'] = 'col-md-';
$blockLangFrm->developerTags['fld_default_col'] = 12;
$langFld = $blockLangFrm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "addBlockLangForm(" . $blockId . ", this.value);");
$recordId = (int) $blockId;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'addBlockForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false,
        'isPrimary' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'addBlockLangForm("' . $recordId . '","' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . '")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'blockMedia("' . $recordId . '")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => false
    ],
];
$formTitle = Labels::getLabel('LBL_Content_Block_with_icon_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>

<?php
$translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
if (!empty($translatorSubscriptionKey) && $langId != $siteDefaultLangId) {
    ?>
    <div class="row justify-content-end">
        <div class="col-auto mb-4">
            <input class="btn btn-brand" type="button"
                value="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $adminLangId); ?>"
                onClick="addBlockLangForm(<?php echo $blockId; ?>, <?php echo $langId; ?>, 1)">
        </div>
    </div>
<?php } ?>

<?php
echo $blockLangFrm->getFormTag();
echo $blockLangFrm->getFormHtml(false);
echo '</form>';
?>


<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>