<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$imagesFrm->setFormTagAttribute('class', 'form web_form mt-5x');
$imagesFrm->setFormTagAttribute('id', 'imageFrm');
$imagesFrm->developerTags['colClassPrefix'] = 'col-md-';
$imagesFrm->developerTags['fld_default_col'] = 6;

$langFld = $imagesFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'language-js');

$imgFld = $imagesFrm->getField('block_image');
$imgFld->addFieldTagAttribute('onChange', 'popupImage(this)');
$imgFld->htmlBeforeField = '<span class="filename"></span>';
$imgFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Please_keep_image_dimensions_greater_than_100_x_100', $adminLangId) . '</small>';
$recordId = (int) $blockId;
$frm = $imagesFrm;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'addBlockForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false,
        'isPrimary' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'addBlockLangForm("' . $recordId . '","' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . '")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'blockMedia("' . $recordId . '")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => true
    ],
];
$formTitle = Labels::getLabel('LBL_Content_Block_with_icon_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>


<div id="mediaForm-js">
    <?php echo $imagesFrm->getFormHtml(); ?>
</div>
<div id="cropperBox-js"></div>
<div id="imageupload_div" class="padd15"></div>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>