$(document).ready(function () {
    $(document).on("keypress", "input.zip-js", function (e) {
        var regex = new RegExp("^[a-zA-Z0-9]+$");
        var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
        if (regex.test(str)) {
            return true;
        }

        e.preventDefault();
        return false;
    });
    $('[data-toggle="tooltip"]').tooltip();
});

$(document).on("submit", "form", function () {
    moveErrorAfterIti();
});

$(document).on("keyup", "form .iti input[data-intl-tel-input-id]", function () {
    moveErrorAfterIti();
});

$(document).on("blur", "form .iti input[data-intl-tel-input-id]", function () {
    moveErrorAfterIti();
});

function moveErrorAfterIti() {
    if (0 < $(".iti .errorlist").length) {
        $(".iti .errorlist").detach().insertAfter(".iti");
    }
}

(function ($) {
    var screenHeight = $(window).height() - 100;
    window.onresize = function (event) {
        var screenHeight = $(window).height() - 100;
    };

    $.extend(fcom, {
        processingCounter: 0,
        processingClass: "processingJs",
        getLoader: function (addAsNew = false) {
            // $(document.body).css({ cursor: "wait" });
            return '<div class="processing loaderJs" ><div class="spinner spinner--sm spinner--brand"></div></div>';
        },
        getPageLoader: function () {
            return '<div class="page-loader"><span> Loading... <i class="loader-line"></i></span></div>';
        },
        waitAndRedirect: function (msg, url, time) {
            var time = time || 3000;
            var url = url || fcom.makeUrl();
            $.systemMessage(msg);
            setTimeout(function () {
                location.href = url;
            }, time);
        },
        scrollToTop: function (obj) {
            if (typeof obj == undefined || obj == null) {
                $("html, body").animate(
                    {
                        scrollTop: $("html, body").offset().top - 100,
                    },
                    "slow"
                );
            } else {
                $("html, body").animate(
                    {
                        scrollTop: $(obj).offset().top - 100,
                    },
                    "slow"
                );
            }
        },
        resetEditorInstance: function () {
            if (extendEditorJs == true) {
                var editors = oUtil.arrEditor;
                for (x in editors) {
                    eval("delete window." + editors[x]);
                }
                oUtil.arrEditor = [];
            }
        },
        resetEditorWidth: function (width = "100%") {
            if (typeof oUtil != "undefined") {
                oUtil.arrEditor.forEach(function (input) {
                    var oEdit1 = eval(input);
                    $("#idArea" + oEdit1.oName).attr("width", width);
                });
            }
        },
        setEditorLayout: function (lang_id) {
            if (extendEditorJs == true) {
                var editors = oUtil.arrEditor;
                layout = langLbl["language" + lang_id];
                for (x in editors) {
                    $("#idContent" + editors[x])
                        .contents()
                        .find("body")
                        .css("direction", layout);
                }
            }
        },
        displayProcessing: function () {
            fcom.processingCounter++;
            $.mbsmessage.info(
                langLbl.processing,
                -1,
                fcom.processingClass +
                    " " +
                    fcom.processingClass +
                    "-" +
                    fcom.processingCounter
            );
        },
        closeProcessing: function (counter) {
            var cls = fcom.processingClass;
            if (typeof counter !== "undefined") {
                cls += "-" + counter;
            }
            $("." + cls).remove();
        },

        displaySuccessMessage: function (msg) {
            $.mbsmessage.close();
            $.mbsmessage.success(msg);
        },

        displayErrorMessage: function (msg) {
            $.mbsmessage.close();
            $.mbsmessage.error(msg);
            fcom.removeLoader();
        },

        displayInfoMessage: function (msg) {
            $.mbsmessage.close();
            $.mbsmessage.info(msg);
        },

        getModalBody: function () {
            return '<div class="modal fade" id="modalBoxJs"  data-bs-backdrop="static" data-bs-keyboard="false" data-backdrop="static" data-keyboard="false" tabindex="-1" role="dialog" aria-labelledby="modalBoxJsLabel" aria-hidden="true"><div class="modal-dialog modal-dialog-centered modal-lg" role="document"><div class="modal-content"><div class="modal-header"><h6 class="modal-title"></h6><button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button></div><div class="modal-body"><div class="table-processing loaderJs"><div class="spinner spinner--sm spinner--brand"></div></div></div><div class="modal-footer"></div></div></div></div>';
        },
        removeLoader: function (cls) {
            $(document.body).css({ cursor: "default" });
            $(".loaderJs").remove();
            $(".submitBtnJs").removeClass("loading");
        },
        getRowSpinner: function () {
            return '<div class="spinner spinner--v2 spinner--sm spinner--brand"></div>';
        },
        updateFaceboxContent: function (t, cls, popupView) {
            if (typeof cls == "undefined" || cls == "undefined") {
                cls = "";
            }
            $.bootstrapModal(t, popupView, cls);
            $.mbsmessage.close();
            fcom.resetBootstrapModalHeight();
        },
        resetBootstrapModalHeight: function () {
            facebocxHeight = screenHeight;
            var fbContentHeight =
                parseInt($("#facebox .content").height()) + parseInt(150);
            setTimeout(function () {
                $("#facebox .content").css(
                    "max-height",
                    parseInt(facebocxHeight) -
                        parseInt(facebocxHeight) / 4 +
                        "px"
                );
            }, 700);
            $("#facebox .content").css("overflow-y", "auto");
            if (fbContentHeight > screenHeight - parseInt(100)) {
                $("#facebox .content").css("display", "block");
            } else {
                $("#facebox .content").css("max-height", "");
            }
        },
    });
    var autoOpenSideBar = true;
    $(document).on("hidden.bs.modal", "#modalBoxJs", function () {
        if (autoOpenSideBar) {
            $.bootstrapModal.show();
        }
    });
    loadCropperSkeleton = function (reopenSideBarOnClose = true) {
        autoOpenSideBar = reopenSideBarOnClose;
        $("#modalBoxJs").remove();
        $("body").append(fcom.getModalBody());
        $("#modalBoxJs").modal("show");
        $.bootstrapModal.close();
    };

    $(document).bind("reveal.facebox", function () {
        fcom.resetBootstrapModalHeight();
    });

    $(window).on("orientationchange", function () {
        fcom.resetBootstrapModalHeight();
    });

    $(document).bind("loading.facebox", function () {
        $.bootstrapModal.settings.loadingImage =
            SITE_ROOT_URL + "img/facebox/loading.gif";
        $.bootstrapModal.settings.closeImage =
            SITE_ROOT_URL + "img/facebox/closelabel.png";
        $("#facebox .content").addClass("fbminwidth");
    });

    $(document).bind("afterClose.facebox", fcom.resetEditorInstance);
    $(document).bind("afterClose.facebox", function () {
        $("html").css("overflow", "");
    });

    $.systemMessage = function (data, cls, autoClose = true) {
        if ("" == data || typeof data == "undefined") {
            return;
        }
        if (typeof autoClose == "undefined" || autoClose == "undefined") {
            autoClose = false;
        }

        initialize();
        $.systemMessage.loading();
        $.systemMessage.fillSysMessage(data, cls, autoClose);
    };

    $.extend($.systemMessage, {
        settings: {
            closeimage: siteConstants.webroot + "images/facebox/close.gif",
        },
        loading: function () {
            $(".alert").show();
        },
        fillSysMessage: function (data, cls, autoClose) {
            $(".alert").removeClass("alert--success");
            $(".alert").removeClass("alert--danger");
            $(".alert").removeClass("alert--process");

            if (cls) $(".system_message").addClass(cls);
            $(".system_message .content").html(data);
            $(".system_message").fadeIn();
            if (true == autoClose && CONF_AUTO_CLOSE_SYSTEM_MESSAGES == 1) {
                var time = CONF_TIME_AUTO_CLOSE_SYSTEM_MESSAGES * 2000;
                setTimeout(function () {
                    $.systemMessage.close();
                }, time);
            }
            /* setTimeout(function() {
             $('.system_message').hide('fade', {}, 500)
             }, 5000); */
        },
        close: function () {
            $(document).trigger("close.sysmsgcontent");
        },
    });

    function initialize() {
        $(".alert .close").click($.systemMessage.close);
    }

    $(document).bind("close.sysmsgcontent", function () {
        $(".alert").fadeOut();
    });

    if ($.datepicker) {
        var old_goToToday = $.datepicker._gotoToday;
        $.datepicker._gotoToday = function (id) {
            old_goToToday.call(this, id);
            this._selectDate(id);
            $(id).blur();
            return;
        };
    }

    refreshCaptcha = function (elem) {
        $(elem).attr(
            "src",
            siteConstants.webroot + "helper/captcha?sid=" + Math.random()
        );
    };

    clearCache = function () {
        fcom.displayProcessing();
        fcom.ajax(fcom.makeUrl("Home", "clear", "", "", 1), "", function (t) {
            window.location.reload();
        });
    };

    SelectText = function (element) {
        var doc = document,
            text = doc.getElementById(element),
            range,
            selection;
        if (doc.body.createTextRange) {
            range = document.body.createTextRange();
            range.moveToElementText(text);
            range.select();
        } else if (window.getSelection) {
            selection = window.getSelection();
            range = document.createRange();
            range.selectNodeContents(text);
            selection.removeAllRanges();
            selection.addRange(range);
        }
    };
    getSlugUrl = function (obj, str, extra, pos) {
        if (pos == undefined) pos = "pre";
        var str = str
            .toString()
            .toLowerCase()
            .replace(/\s+/g, "-") /* // Replace spaces with - */
            .replace(/[^\w\-\/]+/g, "") /* // Remove all non-word chars */
            .replace(/\-\-+/g, "-") /* // Replace multiple - with single - */
            .replace(/^-+/, "") /* // Trim - from start of text */
            .replace(/-+$/, "");
        if (extra && pos == "pre") {
            str = extra + "/" + str;
        }
        if (extra && pos == "post") {
            str = str + "/" + extra;
        }

        $(obj)
            .next()
            .html(SITE_ROOT_URL + str);
    };

    redirectfunc = function (url, id, nid, newTab) {
        newTab = typeof newTab != "undefined" ? newTab : true;
        if (nid > 0) {
            fcom.displayProcessing();
            markRead(nid, url, id);
        } else {
            var target = newTab ? ' target="_blank" ' : " ";
            var form = '<input type="hidden" name="id" value="' + id + '">';
            $(
                "<form" +
                    target +
                    'action="' +
                    url +
                    '" method="POST">' +
                    form +
                    "</form>"
            )
                .appendTo($(document.body))
                .submit();
        }
    };

    markRead = function (nid, url, id) {
        if (nid.length < 1) {
            return false;
        }
        var data = "record_ids=" + nid + "&status=" + 1 + "&markread=1";
        fcom.updateWithAjax(
            fcom.makeUrl("Notifications", "changeStatus"),
            data,
            function (t) {
                var form = '<input type="hidden" name="id" value="' + id + '">';
                $(
                    '<form action="' +
                        url +
                        '" method="POST">' +
                        form +
                        "</form>"
                )
                    .appendTo($(document.body))
                    .submit();
            }
        );
    };

    /* $(document).click(function(event) {
     $('ul.dropdown-menu').hide();
     }); */

    autofillLangData = function (autoFillBtn, frm) {
        var actionUrl = autoFillBtn.data("action");

        var defaultLangField = $("input.defaultLang", frm);
        if (1 > defaultLangField.length) {
            fcom.displayErrorMessage(langLbl.unknownPrimaryLanguageField);
            return false;
        }
        var proceed = true;
        var stringToTranslate = "";
        defaultLangField.each(function (index) {
            if ("" != $(this).val()) {
                if (0 < index) {
                    stringToTranslate += "&";
                }
                stringToTranslate += $(this).attr("name") + "=" + $(this).val();
            } else {
                $(this).focus();
                fcom.displayErrorMessage(langLbl.primaryLanguageField);
                proceed = false;
                return false;
            }
        });
        if (true == proceed) {
            fcom.displayProcessing();
            fcom.ajax(actionUrl, stringToTranslate, function (t) {
                var res = $.parseJSON(t);
                $.each(res, function (langId, values) {
                    $.each(values, function (selector, value) {
                        $(
                            "input.langField_" +
                                langId +
                                "[name='" +
                                selector +
                                "']"
                        ).val(value);
                    });
                });
                $.systemMessage.close();
            });
        }
    };
    $('[data-toggle="tooltip"]').tooltip();
})(jQuery);

function getSlickSliderSettings(slidesToShow, slidesToScroll, layoutDirection) {
    slidesToShow =
        typeof slidesToShow != "undefined" ? parseInt(slidesToShow) : 4;
    slidesToScroll =
        typeof slidesToScroll != "undefined" ? parseInt(slidesToScroll) : 1;
    layoutDirection =
        typeof layoutDirection != "undefined" ? layoutDirection : "ltr";

    if (layoutDirection == "rtl") {
        return {
            slidesToShow: slidesToShow,
            slidesToScroll: slidesToScroll,
            infinite: false,
            arrows: true,
            rtl: true,
            prevArrow:
                '<a data-role="none" class="slick-prev" aria-label="previous"></a>',
            nextArrow:
                '<a data-role="none" class="slick-next" aria-label="next"></a>',
            responsive: [
                {
                    breakpoint: 1050,
                    settings: {
                        slidesToShow: slidesToShow - 1,
                    },
                },
                {
                    breakpoint: 990,
                    settings: {
                        slidesToShow: 3,
                    },
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: 2,
                    },
                },
                {
                    breakpoint: 400,
                    settings: {
                        slidesToShow: 1,
                    },
                },
            ],
        };
    } else {
        return {
            slidesToShow: slidesToShow,
            slidesToScroll: slidesToScroll,
            infinite: false,
            arrows: true,
            prevArrow:
                '<a data-role="none" class="slick-prev" aria-label="previous"></a>',
            nextArrow:
                '<a data-role="none" class="slick-next" aria-label="next"></a>',
            responsive: [
                {
                    breakpoint: 1050,
                    settings: {
                        slidesToShow: slidesToShow - 1,
                    },
                },
                {
                    breakpoint: 990,
                    settings: {
                        slidesToShow: 3,
                    },
                },
                {
                    breakpoint: 767,
                    settings: {
                        slidesToShow: 2,
                    },
                },
                {
                    breakpoint: 400,
                    settings: {
                        slidesToShow: 1,
                    },
                },
            ],
        };
    }
}
(function () {
    Slugify = function (str, str_val_id, is_slugify) {
        var str = str
            .toString()
            .toLowerCase()
            .replace(/\s+/g, "-") /* // Replace spaces with - */
            .replace(/[^\w\-]+/g, "") /*  // Remove all non-word chars */
            .replace(/\-\-+/g, "-") /* // Replace multiple - with single - */
            .replace(/^-+/, "") /* // Trim - from start of text */
            .replace(/-+$/, "");
        if ($("#" + is_slugify).val() == 0) $("#" + str_val_id).val(str);
    };

    callChart = function (dv, $labels, $series, $position) {
        new Chartist.Bar(
            "#" + dv,
            {
                labels: $labels,

                series: [$series],
            },
            {
                stackBars: false,

                axisY: {
                    position: $position,
                    labelInterpolationFnc: function (value) {
                        return value / 1000 + "k";
                    },
                },
            }
        ).on("draw", function (data) {
            if (data.type === "bar") {
                data.element.attr({
                    style: "stroke-width: 25px",
                });
            }
        });
    };

    $(document).on("click", ".group__head-js", function () {
        if ($(this).parents(".group-js").hasClass("is-active")) {
            $(this).siblings(".group__body-js").slideUp();
            $(".group-js").removeClass("is-active");
        } else {
            $(".group-js").removeClass("is-active");
            $(this).parents(".group-js").addClass("is-active");
            $(".group__body-js").slideUp();
            $(this).siblings(".group__body-js").slideDown();
        }
    });

    if ($(window).width() < 767) {
        $("html").removeClass("sticky-demo-header");
    }
})();
function isJson(str) {
    try {
        var json = JSON.parse(str);
    } catch (e) {
        return false;
    }
    return json;
}

$(document).on("change", "input[type='file']", fileSizeValidation);

function fileSizeValidation() {
    const fsize = this.files[0].size;
    if (fsize > langLbl.allowedFileSize) {
        if (0 < $("#facebox").length) {
            $(document).trigger("close.facebox");
        }
        var msg = langLbl.fileSizeExceeded;
        var msg = msg.replace(
            "{size-limit}",
            bytesToSize(langLbl.allowedFileSize)
        );
        $.mbsmessage.error(msg);
        $(this).val("");
        $("#uploadFileName").text("Select File To Upload");
        return false;
    }
    return true;
}

function bytesToSize(bytes) {
    var sizes = ["Bytes", "KB", "MB", "GB", "TB"];
    if (bytes == 0) return "0 Byte";
    var i = parseInt(Math.floor(Math.log(bytes) / Math.log(1024)));
    return Math.round(bytes / Math.pow(1024, i), 2) + " " + sizes[i];
}

var gCaptcha = false;
function googleCaptcha() {
    $("body").addClass("captcha");
    var inputObj = $("form input[name='g-recaptcha-response']");
    var submitBtn = inputObj.closest("form").find('input[type="submit"]');
    submitBtn.attr("disabled", "disabled");
    var checkToken = setInterval(function () {
        if (true === gCaptcha) {
            submitBtn.removeAttr("disabled");
            clearInterval(checkToken);
        }
    }, 500);

    /*Google reCaptcha V3  */
    setTimeout(function () {
        if (0 < inputObj.length && "undefined" !== typeof grecaptcha) {
            grecaptcha.ready(function () {
                grecaptcha
                    .execute(langLbl.captchaSiteKey, {
                        action: inputObj.data("action"),
                    })
                    .then(function (token) {
                        inputObj.val(token);
                        gCaptcha = true;
                    });
            });
        } else if ("undefined" === typeof grecaptcha) {
            $.mbsmessage.error(langLbl.invalidGRecaptchaKeys);
        }
    }, 200);
}

var map;
var marker;
var geocoder;
var infowindow;
// Initialize the map.
function initMap(lat = 40.72, lng = -73.96, elementId = "map") {
    var lat = parseFloat(lat);
    var lng = parseFloat(lng);
    var latlng = { lat: lat, lng: lng };
    var address = "";
    if (1 > $("#" + elementId).length) {
        return;
    }
    map = new google.maps.Map(document.getElementById(elementId), {
        zoom: 12,
        center: latlng,
    });
    geocoder = new google.maps.Geocoder();
    infowindow = new google.maps.InfoWindow();

    // address = document.getElementById('geo_postal_code').value;
    /*address = {lat: parseFloat(lat), lng: parseFloat(lat)};
    geocodeAddress(geocoder, map, infowindow, { 'location': latlng });*/
    geocodeAddress(geocoder, map, infowindow, { 'location': latlng });


    var sel = document.getElementById("geo_country_code");
    var country = sel.options[sel.selectedIndex].text;
    if (country != null || country != "") {
        address = country;
    }

    var sel = document.getElementById("geo_state_code");
    var state = sel.options[sel.selectedIndex].text;
    if (state != null || state != "") {
        address = address + " " + state;
    }

    var zip = document.getElementById("geo_postal_code");
    if (zip != null) {
        address = address + " " + zip.value;
    }

    marker = new google.maps.Marker({
        position: latlng,
        map: map,
        title: address,
        draggable: true,
    });

    google.maps.event.addListener(marker, "dragend", function () {
        geocoder.geocode(
            { latLng: marker.getPosition() },
            function (results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    geocodeSetData(results);
                }
            }
        );
    });

    //geocodeAddress(geocoder, map, infowindow, { 'address': address });

    document
        .getElementById("geo_postal_code")
        .addEventListener("blur", function () {
            var sel = document.getElementById("geo_country_code");
            var country = sel.options[sel.selectedIndex].text;

            address = document.getElementById("geo_postal_code").value;
            address = country + " " + address;

            geocodeAddress(geocoder, map, infowindow, { address: address });
        });

    document
        .getElementById("geo_state_code")
        .addEventListener("change", function () {
            var sel = document.getElementById("geo_country_code");
            var country = sel.options[sel.selectedIndex].text;

            var sel = document.getElementById("geo_state_code");
            var state = sel.options[sel.selectedIndex].text;

            address = country + " " + state;

            geocodeAddress(geocoder, map, infowindow, { address: address });
        });

    document
        .getElementById("geo_country_code")
        .addEventListener("change", function () {
            var sel = document.getElementById("geo_country_code");
            var country = sel.options[sel.selectedIndex].text;

            geocodeAddress(geocoder, map, infowindow, { address: country });
        });

    /* for (i = 0; i < document.getElementsByClassName('addressSelection-js').length; i++) {
        document.getElementsByClassName('addressSelection-js')[i].addEventListener("change", function(e) {
            address = e.target.options[e.target.selectedIndex].text;
            geocodeAddress(geocoder, map, infowindow, {'address': address});
            });
    } */
}

function geocodeAddress(geocoder, resultsMap, infowindow, address) {
    geocoder.geocode(address, function (results, status) {
        if (status === google.maps.GeocoderStatus.OK) {
            resultsMap.setCenter(results[0].geometry.location);
            if (marker && marker.setMap) {
                marker.setMap(null);
            }
            marker = new google.maps.Marker({
                map: resultsMap,
                position: results[0].geometry.location,
                draggable: true,
            });
            geocodeSetData(results);
            google.maps.event.addListener(marker, "dragend", function () {
                geocoder.geocode(
                    { latLng: marker.getPosition() },
                    function (results, status) {
                        if (status == google.maps.GeocoderStatus.OK) {
                            geocodeSetData(results);
                        }
                    }
                );
            });
        } else {
            /*console.log('Geocode was not successful for the following reason: ' + status);*/
        }
    });
}
/*
function geocodeSetData(results) {
  document.getElementById("lat").value = marker.getPosition().lat();
  document.getElementById("lng").value = marker.getPosition().lng();
  if (results[0]) {
    infowindow.setContent(results[0].formatted_address);
    infowindow.open(map, marker);
    var address_components = results[0].address_components;
    var data = {};
    data["formatted_address"] = results[0].formatted_address;
    if (0 < address_components.length) {
      var addressComponents = address_components;
      for (var i = 0; i < addressComponents.length; i++) {
        var key = address_components[i].types[0];
        var value = address_components[i].long_name;
        data[key] = value;
        if ("country" == key) {
          data["country_code"] = address_components[i].short_name;
          data["country"] = value;
        } else if ("administrative_area_level_1" == key) {
          data["state_code"] = address_components[i].short_name;
          data["state"] = value;
        } else if ("administrative_area_level_2" == key) {
          data["city"] = value;
        } else if ("locality" == key) {
          data["city"] = value;
        }
      }
    }
    $("#geo_postal_code").val(data.postal_code);
    if (data.hasOwnProperty("city")) {
      $("#geo_city").val(data.city);
    } else {
      $("#geo_city").val(data.state);
} */

function geocodeSetData(results) {
    document.getElementById("lat").value = marker.getPosition().lat();
    document.getElementById("lng").value = marker.getPosition().lng();
    if (results[0]) {
        infowindow.setContent(results[0].formatted_address);
        infowindow.open(map, marker);
        var address_components = results[0].address_components;
        var data = {};
        /* data['lat'] = pos.lat();
        data['lng'] = pos.lng(); */
        data["formatted_address"] = results[0].formatted_address;
        if ($('#ga-autoComplete').length > 0) {
            $('#ga-autoComplete').val(data["formatted_address"]);
        }
        if (0 < address_components.length) {
            var addressComponents = address_components;
            for (var i = 0; i < addressComponents.length; i++) {
                var key = address_components[i].types[0];
                var value = address_components[i].long_name;
                data[key] = value;
                if ("country" == key) {
                    data["country_code"] = address_components[i].short_name;
                    data["country"] = value;
                } else if ("administrative_area_level_1" == key) {
                    data["state_code"] = address_components[i].short_name;
                    data["state"] = value;
                } else if ("administrative_area_level_2" == key) {
                    data["city"] = value;
                } else if ("locality" == key) {
                    data["city"] = value;
                }
            }
        }
        $("#geo_postal_code").val(data.postal_code);
        if (data.hasOwnProperty("city")) {
            $("#geo_city").val(data.city);
        } else {
            $("#geo_city").val(data.state);
        }

        $("#geo_country_code option").each(function () {
            if (this.text == data.country) {
                $("#geo_country_code").val(this.value);
                var state = 0;
                $("#geo_state_code option").each(function () {
                    if (
                        this.value == data.state_code ||
                        this.text == data.state
                    ) {
                        return (state = this.value);
                    }
                });
                if (state != 0) {
                    //  getStatesByCountryCode(this.value, state, '#geo_state_code', 'state_code');
                }
                return false;
            }
        });
    }

    /* $("#geo_country_code option").each(function () {
        if (this.text == data.country) {
            $("#geo_country_code").val(this.value);
            var state = 0;
            $("#geo_state_code option").each(function () {
                if (this.value == data.state_code || this.text == data.state) {
                    return (state = this.value);
                }
            });
            getStatesByCountryCode(
                this.value,
                state,
                "#geo_state_code",
                "state_code"
            );
            return false;
        }
    }); */
}

function getStatesByCountryCode(
    countryCode,
    stateCode,
    dv,
    idCol = "state_id"
) {
    fcom.ajax(
        fcom.makeUrl("Configurations", "getStatesByCountryCode", [
            countryCode,
            stateCode,
            idCol,
        ]),
        "",
        function (res) {
            $(dv).empty();
            $(dv).append(res).change();
        }
    );
}

function initAutocomplete() {
    var el = document.getElementById('ga-autoComplete');
    var options = { types: [] };
    var autocomplete = new google.maps.places.Autocomplete(el, options);
    google.maps.event.addListener(autocomplete, "place_changed", function () {
        var place = autocomplete.getPlace();
        var lat = place["geometry"]["location"].lat();
        var lng = place["geometry"]["location"].lng();
        initMap(lat, lng);
    });    
  }
  
function searchLocation() {
    let customAddresss = ($('#ga-autoComplete').val()).trim();
    console.log(!customAddresss);
    if (!customAddresss) {
        fcom.displayErrorMessage(langLbl.enterLocation);
        return "";
    }
    $('#lat').val('');
    $('#lng').val('');
    geocodeAddress(geocoder, map, infowindow, {address: customAddresss});
}

function loadGeoLocation() {
    if (!CONF_ENABLE_GEO_LOCATION) {
        return;
    }

    if (typeof navigator.geolocation == "undefined") {
        fcom.displayErrorMessage(langLbl.geoLocationNotSupported);
        return false;
    }

    navigator.geolocation.getCurrentPosition(
        function (position) {
        var lat = position.coords.latitude;
        var lng = position.coords.longitude;
        codeLatLng(lat, lng, getGeoAddress);
        },
        function (error) {
            if (1 == error.code) {
                fcom.displayErrorMessage(error.message);
            }
        }
    );
}


$(document).on("click", 'input[name="sprodata_is_for_sell"]', function () {
    if ($(this).prop("checked") == true) {
        $(".salefld--js").removeClass("hideSaleFlds");
    } else {
        $(".salefld--js").addClass("hideSaleFlds");
    }
});

callCouponDiscountInConfig = function (val) {
    if (val == DISCOUNT_IN_PERCENTAGE) {
        $("#max_value_div").show();
    }
    if (val == DISCOUNT_IN_FLAT) {
        $("#max_value_div").hide();
    }
    if (
        $(".discountType-js option:selected").val() == DISCOUNT_IN_PERCENTAGE &&
        $(".discountValue-js").val() > 100
    ) {
        $(".discountValue-js").val(100);
        return false;
    }
};

$(document).on("click", "#showPass", function () {
    var passInput = $("#password");
    if ("" == passInput.val()) {
        return;
    }

    if (passInput.attr("type") === "password") {
        passInput.attr("type", "text");
        $(this).addClass("field-password-show");
    } else {
        passInput.attr("type", "password");
        $(this).removeClass("field-password-show");
    }
});

// Method to initialize MutationObserver
function initializeMutationObserver(targetId, callback) {
    const targetNode = $(`#${targetId}`)[0]; // Get the raw DOM element
    if (targetNode) {
        const observer = new MutationObserver(function () {
            callback(); // Call the passed callback function on DOM changes
        });
        // Observe changes to child nodes
        observer.observe(targetNode, {
            childList: true, // Monitor additions/removals of child elements
        });

        return observer; // Return observer instance for future use if needed
    }
    return null;
}

/*ScrollHint table*/

$(document).ready(function () {
    new ScrollHint(".js-scrollable", {
        i18n: {
            scrollable: langLbl.scrollable,
        },
    });
});
$(document).ajaxComplete(function () {
    new ScrollHint(".js-scrollable:not(.scroll-hint)", {
        i18n: {
            scrollable: langLbl.scrollable,
        },
    });

    if (
        0 < $("div.block-empty").length &&
        0 < $("div.scroll-hint-icon-wrap").length
    ) {
        $("div.block-empty")
            .siblings(".js-scrollable.scroll-hint")
            .children("div.scroll-hint-icon-wrap")
            .remove();
    }
});

