(function ($) {
    var displayInPopup = false;
    $.bootstrapModal = function (data, popupView = '', dialogClassParm = "", modalClassParm = "", bodyClass = "") {
        modalClass = 'fixed-right ' + modalClassParm;
        var dialogClass = 'modal-dialog-vertical ' + dialogClassParm;
        var bodyClass = 'pd-0 ' + bodyClass;

        /* !! is used to convert variable type in to bool. */
        displayInPopup = !!popupView;
        if (true == popupView) {
            modalClass = modalClassParm;
            dialogClass = 'modal-dialog-centered ' + dialogClassParm;
        }
        init(modalClass, dialogClass);
        if (data.ajax) { fillBootstrapModalFromAjax(data.ajax); }
        else if (data.image) { fillBootStrapModalFromImage(data.image); }
        else if (data.div) { fillBootstrapModalFromHref(data.div); }
        else if ($.isFunction(data)) { data.call($); }
        else { $.bootstrapModal.reveal(data, bodyClass); }
    };

    $.extend($.bootstrapModal, {
        element: Date.now(),
        reveal: function (data, bodyClass) {
            if ($(data).hasClass("loaderJs") && 0 < $("." + $.bootstrapModal.element + " .loaderContainerJs").length) {
                $("." + $.bootstrapModal.element + " .loaderContainerJs").prepend(data);
                return;
            }

            if (0 == $(data).find(".modal-body").length && false === $(data).hasClass("modal-body")) {
                data = '<div class="modal-body">' + data + "</div>";
            }

            var contentBody = "." + $.bootstrapModal.element + " .contentBodyJs";
            $(contentBody).html(data);
            var headerHtm = '<div class="modal-header">';
            var closeBtnHtm = '<button type="button" class="btn-close faceboxJs" data-bs-dismiss="modal" aria-label="' + langLbl.close + '"></button>';

            if (1 > $(contentBody).find(".modal-header").length) {
                $(contentBody).prepend(headerHtm + closeBtnHtm + "</div>");
            }
            else if (0 < $(contentBody).find(".modal-header").length && 1 > $("body ." + $.bootstrapModal.element + " .contentBodyJs .modal-header").find(".close").length) {
                $("body ." + $.bootstrapModal.element + " .contentBodyJs .modal-header").append(closeBtnHtm);
            }

            if ("undefined" != typeof bodyClass && 0 == $(data).find(bodyClass).length) {
                $(contentBody + " .modal-body").addClass(bodyClass);
            }

            $.bootstrapModal.show();
        },
        close: function () {
            $("." + $.bootstrapModal.element).modal("hide");
            return
        },
        show: function () {
            $("." + $.bootstrapModal.element).modal("show");
            return
        },
        isAdded: function () {
            return (0 < $("." + $.bootstrapModal.element).length);
        },
        remove: function () {
            $("." + $.bootstrapModal.element + ', .modal-backdrop').remove();
        },
        isSideBarView: function () {
            return !!$(".fixed-right." + $.bootstrapModal.element).length;
        },
    });

    function init(modalClass, dialogClass) {
        if (1 > $("body").find("." + $.bootstrapModal.element).length) {
            var content = '<div class="modal-dialog ' + dialogClass + ' " role="document"><div class="modal-content contentBodyJs"></div></div>';
            var htm = '<div class="modal ' + modalClass + ' fade ' + $.bootstrapModal.element + '" tabindex="-1" role="dialog">' + content + "</div>";
            $("body").append(htm)
        } else if (true === displayInPopup && true === $("." + $.bootstrapModal.element).hasClass('fixed-right')) {
            $("." + $.bootstrapModal.element).removeClass('fixed-right');
            $("." + $.bootstrapModal.element+' .modal-dialog').removeClass('modal-dialog-vertical');
        } else if (false === displayInPopup && false === $("." + $.bootstrapModal.element).hasClass('fixed-right')) {
            $("." + $.bootstrapModal.element).addClass('fixed-right');
        }

        /* Cannot worked if wider class not sent in case of other tabs data. */
        // $("body ." + $.facebox.element + " .modal-dialog").attr('class', 'modal-dialog ' + dialogClass);

        if (dialogClass != '' && ['modal-sm', 'modal-md', 'modal-lg'].some(cls => dialogClass.includes(cls))) {
            var modalDialog = $("body ." + $.bootstrapModal.element + " .modal-dialog");
    
            // Remove existing size-related classes
            modalDialog.removeClass('modal-sm modal-md modal-lg');
    
            // Extract size-related classes from dialogClass
            var sizeClasses = dialogClass.split(' ').filter(cls => ['modal-sm', 'modal-md', 'modal-lg'].includes(cls));
    
            // Add back valid size class, if any
            if (sizeClasses.length > 0) {
                modalDialog.addClass(sizeClasses[0]);
            }
    
            // Add all other classes except size-related ones
            var otherClasses = dialogClass.split(' ').filter(cls => !['modal-sm', 'modal-md', 'modal-lg'].includes(cls));
            otherClasses.forEach(cls => modalDialog.addClass(cls));
        }else if (dialogClass != '' && !$("body ." + $.bootstrapModal.element + " .modal-dialog").hasClass(dialogClass)) {
            $("body ." + $.bootstrapModal.element + " .modal-dialog").addClass(dialogClass);
        }
    }

    function fillBootstrapModalFromHref(href) {
        if (href.match(/#/)) {
            var url = window.location.href.split("#")[0];
            var target = href.replace(url, "");
            if (target == "#") return;
            $.bootstrapModal.reveal($(target).html())
        }
        else if (href.match($.bootstrapModal.settings.imageTypesRegexp)) {
            fillBootStrapModalFromImage(href)
        }
        else {
            fillBootstrapModalFromAjax(href)
        }
    }

    function fillBootStrapModalFromImage(href) {
        var image = new Image();
        image.onload = function () {
            $.bootstrapModal.reveal('<div class="image"><img src="' + image.src + '" /></div>')
        };
        image.src = href
    }

    function fillBootstrapModalFromAjax(href) {
        $.bootstrapModal.jqxhr = $.get(href, function (data) {
            $.bootstrapModal.reveal(data);
        })
    }

    $(document).bind("close.facebox", function () {
        $.bootstrapModal.close()
    });

    $(document).on("hidden.bs.modal", "." + $.bootstrapModal.element, function () {
        $.bootstrapModal.close()
    });
    let submitInterval;
    $(document).on("click", ".submitBtnJs", function () {

        if(submitInterval != undefined){ 
            clearInterval(submitInterval); 
            submitInterval = undefined;
        }          
        submitInterval = setTimeout(function(){
            if ($('.' + $.bootstrapModal.element).hasClass("show")) {
                var form = $('.' + $.bootstrapModal.element + ' form');
                if (true === extendEditorJs) {
                    var onSubmit = form.attr('onsubmit');
                    if ('undefined' != typeof onSubmit) {
                        onSubmit = onSubmit.replace("return(false);", "");
                        eval(onSubmit);
                    }
                } else {
                    form.submit();
                }               
            }
        }, 800);         
    });

    /* $('.' + $.facebox.element).on("scroll", function () {
        console.log("Scrolling");
    });
    $(document).on("shown.bs.modal", "." + $.facebox.element, function () {
        $(this).on("scroll", function () {
        });
    }); */


    /* Submit Form on Enter Key Press. For sidebar forms. */
    $(document).on("keyup", ".modalFormJs, .modalLangFormJs", function (e) {   
        if (1 >= $(this).find(':input:not([type=hidden]),select,textarea').length) {
            return;
        }
        e.stopImmediatePropagation();      
        if (e.keyCode === 13 && !$(e.target).is('textarea') && (false === displayInPopup)) {
            $('.' + $.bootstrapModal.element + " .submitBtnJs").click();
        }
    });
})(jQuery);