<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$defaultDimenssion = $dimensions;

$frm->setFormTagAttribute('class', 'web_form');
$frm->setFormTagAttribute('onsubmit', 'setupBanners(this); return(false);');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;

$fld = $frm->getField('auto_update_other_langs_data');
if (null != $fld) {
	$fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
	$fld->developerTags['cbHtmlAfterCheckbox'] = '';
}

$bannerLangFld = $frm->getField('banner_lang_id');
$bannerLangFld->addFieldTagAttribute('class', 'banner-language-js');



$checkBannerPos = 0;

$bannerDim = $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['width'] . ' X ' . $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['height'];
$bannerFld = $frm->getField('banner');
$bannerFld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$bannerFld->addFieldTagAttribute('onChange', 'bannerPopupImage(this, ' . $checkBannerPos . ')');
$bannerFld->htmlAfterField = '<small class="text--small form-text text-muted preferredDimensions-js">' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' ' . $bannerDim . '</small>';


$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
$recordId = (int) $collection_id;

if ($collection_layout_type != Collections::TYPE_PENDING_REVIEWS1) {

    $recordId = (int) $collection_id;

    $tabsButtons = [
        [
            'attr' => [
                'onclick' => 'collectionForm(' . $collection_type . ', ' . $collection_layout_type . ', ' . $recordId . ', 0)',
                'title' => Labels::getLabel('LBL_General', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_General', $adminLangId),
            'isPrimary' => true
        ]
    ];

    if (!in_array($collection_type, Collections::COLLECTION_WITHOUT_RECORDS) && $collection_layout_type != Collections::TYPE_PRODUCT_LAYOUT5 && $collection_layout_type != Collections::TYPE_CATEGORY_LAYOUT4) {

        array_push($tabsButtons, [
            'attr' => [
                'onclick' => (0 < $recordId) ? 'recordForm(' . $recordId . ', ' . $collection_type . ')' : '',
                'title' => Labels::getLabel('LBL_Link_Records', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Link_Records', $adminLangId),
        ]);
    }

    if ($collection_type == Collections::COLLECTION_TYPE_CONTENT_BLOCK_WITH_ICON) {
        for ($recordIndex = 1; $recordIndex <= $recordLimit; $recordIndex++) {
            array_push($tabsButtons, [
                'attr' => [
                    'onclick' => (0 < $recordId) ? 'addRecordForm(' . $recordId . ', ' . $collection_type . ', ' . $recordIndex . ')' : '',
                    'title' => Labels::getLabel('LBL_Step_' . $recordIndex, $adminLangId),
                ],
                'label' => Labels::getLabel('LBL_Step_' . $recordIndex, $adminLangId),
            ]);
        }
    }

    if ($collection_layout_type == Collections::TYPE_PRODUCT_LAYOUT5) {
        if (!empty($subCollectionsList)) {
            foreach ($subCollectionsList as $subCollection) {
                array_push($tabsButtons, [
                    'attr' => [
                        'onclick' => (0 < $recordId) ? 'tabsForm(' . $recordId . ', ' . $subCollection['collection_id'] . ', ' . Collections::COLLECTION_TYPE_SUB_COLLECTION . ')' : '',
                        'title' => $subCollection['collection_name'],
                    ],
                    'label' => $subCollection['collection_name'],
                ]);
            }
        }
        if (count($subCollectionsList) < $recordLimit) {
            array_push($tabsButtons, [
                'attr' => [
                    'onclick' => 'tabsForm(' . $recordId . ')',
                    'title' => Labels::getLabel('LBL_Tab_+', $adminLangId),
                ],
                'label' => Labels::getLabel('LBL_Tab_+', $adminLangId),
            ]);
        }
    }

    if ($collection_type == Collections::COLLECTION_TYPE_BANNER) {
        array_push($tabsButtons, [
            'attr' => [
                'onclick' => 'banners(' . $recordId . ')',
                'title' => Labels::getLabel('LBL_Banners', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Banners', $adminLangId),
			
        ]);
    }
    if ($collection_type == Collections::COLLECTION_TYPE_CMS) {
        array_push($tabsButtons, [
            'attr' => [
                'onclick' => 'singleBannerForm(' . $recordId . ')',
                'title' => Labels::getLabel('LBL_Banner', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Banner', $adminLangId),
			'isActive' => true,
        ]);
    }
    $mediaLayoutArr = Collections::LAYOUT_WITH_MEDIA ; 
	if($collection_layout_type == Collections::TYPE_BLOG_LAYOUT1 && applicationConstants::getActiveTheme() != applicationConstants::THEME_HEAVY_EQUIPMENT){
		$mediaLayoutArr = array_diff($mediaLayoutArr, [$collection_layout_type]);
	}
	if (in_array($collection_layout_type, $mediaLayoutArr)) {
        array_push($tabsButtons, [
            'attr' => [
                'onclick' => 'collectionMediaForm(' . $recordId . ')',
                'title' => Labels::getLabel('LBL_Media', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Media', $adminLangId),
			
        ]);
    }
}
$formTitle = Labels::getLabel('LBL_Collection', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>

					
					<div class="tabs_panel_wrap form" id="banners_list-js">
						<div id="cropperBox-js"></div>
						<div id="mediaForm-js">

							<?php if ($collection_type != Collections::COLLECTION_TYPE_CMS) { ?>
								<div class="sectionhead" style=" padding-bottom:20px">
									<h4><?php echo Labels::getLabel('LBL_Banner_Setup', $adminLangId); ?>
									</h4>
									<a href="javascript:void(0)" class="themebtn btn-default btn btn-brand btn-sm"
										onClick="reloadBannersList(<?php echo $collection_id; ?>)"
										;><?php echo Labels::getLabel('LBL_Back', $adminLangId); ?></a>
								</div>
							<?php } ?>
							<div class="tabs_panel">
								<?php echo $frm->getFormTag(); ?>
								<div class="mb-4 ">
									<h5><?php echo Labels::getLabel('LBL_Banner', $adminLangId); ?></h5>
									<div class="row">
										<div class="col-md-12">
											<?php
											/* [ MEDIA INSTRUCTIONS START HERE */
											$tpl = new FatTemplate('', '');
											$tpl->set('adminLangId', $adminLangId);
											echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
											/* ] */
											?>
										</div>
										<div class="col-md-4">
											<div class="field-set">
												<div class="caption-wraper"><label class="form-label">
														<?php
														$fld = $frm->getField('banner_lang_id');
														echo $fld->getCaption();
														?>
													</label></div>
												<div class="field-wraper">
													<div class="field_cover">
														<?php echo $frm->getFieldHtml('banner_lang_id'); ?>
													</div>
												</div>
											</div>
										</div>
										<div class="col-md-6">
											<div class="field-set">
												<div class="caption-wraper"><label class="form-label">
													</label></div>
												<div class="field-wraper">
													<div class="field_cover">
														<?php

														echo $frm->getFieldHtml('banner');

														echo $frm->getFieldHtml('banner_image_id');
														?>
													</div>
												</div>
											</div>
										</div>
										<div class="col-md-6" id="banner-image-listing">

										</div>
									</div>
								</div>

								<?php
								echo $frm->getFieldHtml('collection_layout_type');
								echo $frm->getFieldHtml('banner_min_width');
								echo $frm->getFieldHtml('banner_min_height');
								echo $frm->getFieldHtml('collection_id');
								?>
								
								</form>
								<?php echo $frm->getExternalJS(); ?>
							</div>
						</div>
					</div>
				

<script>
	var width = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['width']; ?>;
	var height = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['height']; ?>;
	var aspectRatio = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['width']; ?> / <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['height']; ?>;

	$('input[name=banner_min_width]').val(width);
	$('input[name=banner_min_height]').val(height);


	$(document).on('change', '.prefDimensions-js', function () {
		var screenDesktop = <?php echo applicationConstants::SCREEN_DESKTOP ?>;
		var screenIpad = <?php echo applicationConstants::SCREEN_IPAD ?>;
		if ($(this).val() == screenDesktop) {
			width = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['width']; ?>;
			height = <?php echo $defaultDimenssion[applicationConstants::SCREEN_DESKTOP]['height']; ?>;
		} else if ($(this).val() == screenIpad) {
			width = <?php echo $defaultDimenssion[applicationConstants::SCREEN_IPAD]['width']; ?>;
			height = <?php echo $defaultDimenssion[applicationConstants::SCREEN_IPAD]['height']; ?>;
		} else {
			width = <?php echo $defaultDimenssion[applicationConstants::SCREEN_MOBILE]['width']; ?>;
			height = <?php echo $defaultDimenssion[applicationConstants::SCREEN_MOBILE]['height']; ?>;
		}
		$('.preferredDimensions-js').html(langLbl.preferredDimensions + ' ' + width + ' * ' + height);
		$('input[name=banner_min_width]').val(width);
		$('input[name=banner_min_height]').val(height);
		aspectRatio = width / height;
	});
	$("document").ready(function () {
		$(".prefDimensions-js").trigger('change');
		$('select[name="banner_position"]').trigger('change');
	});

	bannerImages('<?php echo $collection_id; ?>');
</script>

<?php
$displayFooterButtons = false;
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>