<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'form web_form form_horizontal');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;
$fld = $frm->getField('collection_records');
$fld->setWrapperAttribute('class', 'ui-front');

$actionName = 'autocomplete';
$hideSelectField = 'hide-addrecord-field--js';
switch ($collection_type) {
    case Collections::COLLECTION_TYPE_PRODUCT:
        $controllerName = 'Collections';
        $actionName = 'autoCompleteSelprods';
        $hideSelectField = '';
        break;
    case Collections::COLLECTION_TYPE_CATEGORY:
        $controllerName = 'ProductCategories';
        $hideSelectField = '';
        break;
    case Collections::COLLECTION_TYPE_SHOP:
        $controllerName = 'Shops';
        $hideSelectField = '';
        break;
    case Collections::COLLECTION_TYPE_BRAND:
        //$frm->setFormTagAttribute('onsubmit', 'setupCollectionBrands(this); return(false);');
        $collectionRecordFld = $frm->getField('collection_records');
        $brandAfterText = '<small class="text--small form-text text-muted">' . sprintf(Labels::getLabel('LBL_Please_choose_brand_before_uploading_image', $adminLangId)) . '</small>';
        $collectionRecordFld->htmlAfterField = $brandAfterText;
        $brandImgFld = $frm->getField('brand_image');
        $width = $imgSizeArr['width'];
        $height = $imgSizeArr['height'];
        $preferredDimensionsStr = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' ' . $width . '*' . $height . '</small>';
        $brandImgFld->htmlAfterField = $preferredDimensionsStr;
        $brandImgFld->addFieldTagAttribute('onChange', 'setupCollectionBrandImage(this)');
        $brandImgFld->addFieldTagAttribute('disabled', 'disabled');
        $controllerName = 'Brands';
        $hideSelectField = '';
        break;
    case Collections::COLLECTION_TYPE_BLOG:
        $controllerName = 'BlogPosts';
        $hideSelectField = '';
        break;
    case Collections::COLLECTION_TYPE_FAQ:
        $controllerName = 'Faq';
        $hideSelectField = '';
        break;
    case Collections::COLLECTION_TYPE_TESTIMONIAL:
        $controllerName = 'Testimonials';
        $hideSelectField = '';
        break;
    case Collections::COLLECTION_TYPE_CONTENT_BLOCK_WITH_ICON:
        $controllerName = 'ContentWithIcon';
        $hideSelectField = '';
        break;
    default:
        $controllerName = '';
        $actionName = '';
        break;
}

$recordId = (int) $collection_id;

$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'collectionForm(' . $collection_type . ', ' . $collection_layout_type . ', ' . $recordId . ', 0)',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false,
    ]
];

if (!in_array($collection_type, Collections::COLLECTION_WITHOUT_RECORDS)) {

    array_push($tabsButtons, [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'recordForm(' . $recordId . ', ' . $collection_type . ')' : '',
            'title' => Labels::getLabel('LBL_Link_Records', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Link_Records', $adminLangId),
        'isActive' => true,
        'isPrimary' => true
    ]);
}
$mediaLayoutArr = Collections::LAYOUT_WITH_MEDIA ; 
if($collection_layout_type == Collections::TYPE_BLOG_LAYOUT1 && applicationConstants::getActiveTheme() != applicationConstants::THEME_HEAVY_EQUIPMENT){
    $mediaLayoutArr = array_diff($mediaLayoutArr, [$collection_layout_type]);
}
if (in_array($collection_layout_type, $mediaLayoutArr)) {
    array_push($tabsButtons, [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'collectionMediaForm(' . $recordId . ')' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
    ]);
}

$formTitle = Labels::getLabel('LBL_Collection', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>

<?php
$tpl = new FatTemplate('', '');
$tpl->set('adminLangId', $adminLangId);
echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
echo $frm->getFormHtml();
?>
<div id="cropperBox-js"></div>
<div id="records_list"></div>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>
<script type="text/javascript">
    $("document").ready(function () {
        var controllerName = '<?php echo $controllerName; ?>';
        var actionName = '<?php echo $actionName; ?>';
        var collectionId = $("input[name='collection_id']").val();
        var dropdownParent = $('.modal-body.form-edit').length ? $('.modal-body.form-edit') : undefined;
        <?php if ($collection_type == Collections::COLLECTION_TYPE_PRODUCT) { ?>
            $("select[name='collection_records']").select2({
                closeOnSelect: true,
                dir: layoutDirection,
                dropdownParent: dropdownParent,
                allowClear: true,
                placeholder: $("select[name='collection_records']").attr('placeholder'),
                theme: "default custom-select2",
                ajax: {
                    url: fcom.makeUrl(controllerName, actionName),
                    dataType: 'json',
                    delay: 250,
                    method: 'post',
                    data: function (params) {
                        return {
                            keyword: params.term, // search term
                            page: params.page,
                            collection_id: collectionId
                        };
                    },
                    processResults: function (data, params) {
                        params.page = params.page || 1;
                        return {
                            results: data.products,
                            pagination: {
                                more: params.page < data.pageCount
                            }
                        };
                    },
                    cache: true
                },
                minimumInputLength: 0,
                templateResult: function (result) {
                    return result.name;
                },
                templateSelection: function (result) {
                    return result.name || result.text;
                }
            }).on('select2:selecting', function (e) {
                var item = e.params.args.data;
                updateRecord(<?php echo $collection_id; ?>, item.id);
                setTimeout(function () {
                    $("select[name='collection_records']").val('').trigger('change.select2');
                }, 200);

            });

        <?php } elseif ($collection_type == Collections::COLLECTION_TYPE_BRAND) { ?>
            $('input[name=\'collection_records\']').autocomplete({
                'classes': {
                    "ui-autocomplete": "custom-ui-autocomplete"
                },
                'source': function (request, response) {
                    $.ajax({
                        url: fcom.makeUrl(controllerName, actionName),
                        data: {
                            keyword: request['term'],
                            fIsAjax: 1,
                            collection_id: collectionId,
                        },
                        dataType: 'json',
                        type: 'post',
                        success: function (json) {
                            response($.map(json, function (item) {
                                return {
                                    label: item['name'],
                                    value: item['name'],
                                    id: item['id']
                                };
                            }));
                        },
                    });
                },
                select: function (event, ul) {
                    //updateRecord(<?php echo $collection_id; ?>, ul.item.id);
                    $('input[name=\'collection_records\']').val(ul.item.value);
                    $('input[name=\'collection_brand_id\']').val(ul.item.id);

                    $('input[name=brand_image]').prop('disabled', false);
                    return false;
                }
            });

            <?php
        } else { ?>

            $('input[name=\'collection_records\']').autocomplete({
                'classes': {
                    "ui-autocomplete": "custom-ui-autocomplete"
                },
                'source': function (request, response) {
                    $.ajax({
                        url: fcom.makeUrl(controllerName, actionName),
                        data: {
                            keyword: request['term'],
                            fIsAjax: 1,
                            collection_id: collectionId,
                        },
                        dataType: 'json',
                        type: 'post',
                        success: function (json) {
                            response($.map(json, function (item) {
                                return {
                                    label: item['name'],
                                    value: item['name'],
                                    id: item['id']
                                };
                            }));
                        },
                    });
                },
                select: function (event, ul) {
                    updateRecord(<?php echo $collection_id; ?>, ul.item.id);
                    $('input[name=\'collection_records\']').val('');
                    return false;
                }
            });
        <?php } ?>
    });
</script>