<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class='page'>
    <div class='content content-space'>
        <div class="page-title">
            <div class="row">
                <div class="col--first col-lg-12">
                    <h5><?php echo Labels::getLabel('LBL_Manage_Collections', $adminLangId); ?> </h5>
                    <div class="breadcrumb-wrap">
                        <?php $this->includeTemplate('_partial/header/header-breadcrumb.php'); ?>
                        <a href="javascript:void(0)" class="btn btn-icon btn-outline-brand" onclick="layoutSelectorForm()" title="" data-bs-toggle="tooltip" data-placement="top" data-bs-original-title="Click here to check the layout type and create layout based collection">
                            <svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                            </svg><span><?php echo Labels::getLabel('Lbl_New', $adminLangId) ?></span>
                        </a>
                    </div>
                </div>
            </div>
        </div>
        <section class="card searchform_filter advance-search">
            <div class="card-head">
                <h4> <?php echo Labels::getLabel('LBL_Search...', $adminLangId); ?></h4>
            </div>
            <div class="card-body extra togglewrap">
                <?php
                $search->setFormTagAttribute('onsubmit', 'searchCollection(this); return(false);');
                $search->setFormTagAttribute('class', 'form web_form');
                $search->setFormTagAttribute('id', 'frmSearch');
                $search->developerTags['colClassPrefix'] = 'col-md-';
                $search->developerTags['fld_default_col'] = 3;
                $btn_submit = $search->getField('btn_submit');
                $btn_submit->developerTags['noCaptionTag'] = false;
                $frmId = $search->getFormTagAttribute('id');
                $fld = $search->getField('collection_type');
                $fld->addFieldTagAttribute('onChange', 'getCollectionTypeLayout("' . $frmId . '",this.value,1); ');
                $search->getField('keyword')->addFieldtagAttribute('class', 'search-input');
                $search->getField('btn_clear')->addFieldtagAttribute('onclick', 'clearSearch();');

                echo $search->getFormHtml();
                ?>
            </div>
        </section>
        <div class="row">
            <div class="col-lg-12">
                <div class="card" id="frmBlock">
                    
                    <div class="card-head">
                        <?php
                        $data = [
                            'statusButtons' => $canEdit,
                            'deleteButton' => $canEdit,
                            'adminLangId' => $adminLangId
                        ];

                        /* if ($canEdit) {
                            $data['otherButtons'][] = [
                                'attr' => [
                                    'href' => 'javascript:void(0)',
                                    'onclick' => 'collectionForm(0)',
                                    'title' => Labels::getLabel('Lbl_Add_Collection', $adminLangId)
                                ],
                                'label' => '<svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                    <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                </svg>'
                            ];
                        } */

                        /* $data['otherButtons'][] = [
                            'attr' => [
                                'href' => 'javascript:void(0)',
                                'onclick' => 'collectionLayouts()',
                                'title' => Labels::getLabel('LBL_All_Layouts_Instructions', $adminLangId)
                            ],
                            'label' => '<i class="fas fa-file-image"></i>'
                        ]; */

                        $this->includeTemplate('_partial/action-buttons.php', $data, false);
                        ?>
                    </div>
                    <div class="card-table">
                        <div id="listing">
                            <?php echo Labels::getLabel('Lbl_Processing...', $adminLangId); ?>....
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>