<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'form web_form layout--' . $formLayout);
$frm->setFormTagAttribute('onsubmit', 'setupCollection(); return(false);');
$frm->setFormTagAttribute('dir', $formLayout);
if (!in_array($collection_layout_type, Collections::APP_COLLECTIONS_ONLY)) {
    $fld = $frm->getField('collection_for_web');
    $fld->setOptionListTagAttribute('class', 'list-radio');
    $fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
    $fld->developerTags['cbHtmlAfterCheckbox'] = '';
}

$fld = $frm->getField('collection_for_app');
$fld->setOptionListTagAttribute('class', 'list-radio');
$fld->developerTags['cbLabelAttributes'] = array('class' => 'checkbox');
$fld->developerTags['cbHtmlAfterCheckbox'] = '';
if (in_array($collection_layout_type, Collections::APP_COLLECTIONS_ONLY)) {
    $fld->setFieldTagAttribute('disabled', 'disabled');
}

$fld = $frm->getField('auto_update_other_langs_data');
if (null != $fld) {
    $fld->developerTags['cbLabelAttributes'] = array('class' => 'switch switch-sm switch-icon');
    $fld->developerTags['cbHtmlAfterCheckbox'] = '';
}
$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);

if ($collection_layout_type != Collections::TYPE_PENDING_REVIEWS1) {

    $recordId = (int) $collection_id;

    $tabsButtons = [
        [
            'attr' => [
                'onclick' => 'collectionForm(' . $collection_type . ', ' . $collection_layout_type . ', ' . $recordId . ', 0)',
                'title' => Labels::getLabel('LBL_General', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_General', $adminLangId),
            'isActive' => true,
            'isPrimary' => true
        ]
    ];

    if (!in_array($collection_type, Collections::COLLECTION_WITHOUT_RECORDS) && $collection_layout_type != Collections::TYPE_PRODUCT_LAYOUT5 && $collection_layout_type != Collections::TYPE_CATEGORY_LAYOUT4) {

        array_push($tabsButtons, [
            'attr' => [
                'onclick' => (0 < $recordId) ? 'recordForm(' . $recordId . ', ' . $collection_type . ')' : '',
                'title' => Labels::getLabel('LBL_Link_Records', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Link_Records', $adminLangId),
        ]);
    }

    if ($collection_type == Collections::COLLECTION_TYPE_CONTENT_BLOCK_WITH_ICON) {
        for ($recordIndex = 1; $recordIndex <= $recordLimit; $recordIndex++) {
            array_push($tabsButtons, [
                'attr' => [
                    'onclick' => (0 < $recordId) ? 'addRecordForm(' . $recordId . ', ' . $collection_type . ', ' . $recordIndex . ')' : '',
                    'title' => Labels::getLabel('LBL_Step_' . $recordIndex, $adminLangId),
                ],
                'label' => Labels::getLabel('LBL_Step_' . $recordIndex, $adminLangId),
            ]);
        }
    }

    if ($collection_layout_type == Collections::TYPE_PRODUCT_LAYOUT5) {
        if (!empty($subCollectionsList)) {
            foreach ($subCollectionsList as $subCollection) {
                array_push($tabsButtons, [
                    'attr' => [
                        'onclick' => (0 < $recordId) ? 'tabsForm(' . $recordId . ', ' . $subCollection['collection_id'] . ', ' . Collections::COLLECTION_TYPE_SUB_COLLECTION . ')' : '',
                        'title' => $subCollection['collection_name'],
                    ],
                    'label' => $subCollection['collection_name'],
                ]);
            }
        }
        if (count($subCollectionsList) < $recordLimit) {
            array_push($tabsButtons, [
                'attr' => [
                    'onclick' => 'tabsForm(' . $recordId . ')',
                    'title' => Labels::getLabel('LBL_Tab_+', $adminLangId),
                ],
                'label' => Labels::getLabel('LBL_Tab_+', $adminLangId),
            ]);
        }
    }

    if ($collection_type == Collections::COLLECTION_TYPE_BANNER) {
        array_push($tabsButtons, [
            'attr' => [
                'onclick' => 'banners(' . $recordId . ')',
                'title' => Labels::getLabel('LBL_Banners', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Banners', $adminLangId),
        ]);
    }
    if ($collection_type == Collections::COLLECTION_TYPE_CMS) {
        array_push($tabsButtons, [
            'attr' => [
                'onclick' => 'singleBannerForm(' . $recordId . ')',
                'title' => Labels::getLabel('LBL_Banner', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Banner', $adminLangId),
        ]);
    }
    $mediaLayoutArr = Collections::LAYOUT_WITH_MEDIA ; 
    if($collection_layout_type == Collections::TYPE_BLOG_LAYOUT1 && applicationConstants::getActiveTheme() != applicationConstants::THEME_HEAVY_EQUIPMENT){
        $mediaLayoutArr = array_diff($mediaLayoutArr, [$collection_layout_type]);
    }
    if (in_array($collection_layout_type, $mediaLayoutArr)) {
        array_push($tabsButtons, [
            'attr' => [
                'onclick' => 'collectionMediaForm(' . $recordId . ')',
                'title' => Labels::getLabel('LBL_Media', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Media', $adminLangId),
        ]);
    }
}
$formTitle = Labels::getLabel('LBL_Collection', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>

<div class="tabs_panel_wrap">
    <div class="tabs_panel" id="tabs_form">
        <?php echo $frm->getFormTag(); ?>
        <div class="row">
            <div class="col-md-4">
                <div class="field-set">
                    <div class="caption-wraper">
                        <label class="form-label">
                            <?php
                            $fld = $frm->getField('collection_name[' . $siteDefaultLangId . ']');
                            echo $fld->getCaption();
                            ?>
                            <span class="spn_must_field">*</span></label>
                    </div>
                    <div class="field-wraper">
                        <div class="field_cover">
                            <?php echo $frm->getFieldHtml('collection_name[' . $siteDefaultLangId . ']'); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php if ($collection_type != Collections::COLLECTION_TYPE_SUB_COLLECTION && $collection_type != Collections::COLLECTION_TYPE_CMS) { ?>
                <div class="col-md-8">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('collection_description[' . $siteDefaultLangId . ']');
                                echo $fld->getCaption();
                                ?>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('collection_description[' . $siteDefaultLangId . ']'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>

            <?php if ($collection_type == Collections::COLLECTION_TYPE_CMS) { ?>
                <div class="col-md-4">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('collection_link_url');
                                echo $fld->getCaption();
                                ?>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('collection_link_url'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('collection_banner_position');
                                echo $fld->getCaption();
                                ?>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('collection_banner_position'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('collection_desc_' . $siteDefaultLangId);
                                echo $fld->getCaption();
                                ?>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('collection_desc_' . $siteDefaultLangId); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>

            <?php if (applicationConstants::getActiveTheme() == applicationConstants::THEME_FASHION && $collection_layout_type == Collections::TYPE_PRODUCT_LAYOUT5) { ?>
                <div class="col-md-12">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('collection_text[' . $siteDefaultLangId . ']');
                                echo $fld->getCaption();
                                ?>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('collection_text[' . $siteDefaultLangId . ']'); ?>
                            </div>
                        </div>
                    </div>
                </div>

            <?php } ?>


            <?php if ($collection_type == Collections::COLLECTION_TYPE_CONTENT_BLOCK) { ?>
                <div class="col-md-12">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('epage_content_' . $siteDefaultLangId);
                                echo $fld->getCaption();
                                ?>
                                <span class="spn_must_field">*</span>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('epage_content_' . $siteDefaultLangId); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                echo $frm->getFieldHtml('epage_id');
            }
            ?>
            <?php if ($collection_type == Collections::COLLECTION_TYPE_BANNER) { ?>
                <div class="col-md-6">
                    <div class="field-set">
                        <div class="caption-wraper">
                            <label class="form-label">
                                <?php
                                $fld = $frm->getField('blocation_promotion_cost');
                                echo $fld->getCaption();
                                ?>
                            </label>
                        </div>
                        <div class="field-wraper">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('blocation_promotion_cost'); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if ($collection_layout_type == Collections::TYPE_BANNER_LAYOUT4) { ?>
                    <div class="col-md-6">
                        <div class="field-set">
                            <div class="caption-wraper">
                                <label class="form-label">
                                    <?php
                                    $fld = $frm->getField('blocation_promotion_cost_second');
                                    echo $fld->getCaption();
                                    ?>
                                </label>
                            </div>
                            <div class="field-wraper">
                                <div class="field_cover">
                                    <?php echo $frm->getFieldHtml('blocation_promotion_cost_second'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            <?php } ?>
        </div>
        <div class="row">
            <?php if (!in_array($collection_layout_type, Collections::APP_COLLECTIONS_ONLY)) { ?>
                <div class="col-md-4 d-none">
                    <div class="field-set d-flex align-items-center">
                        <div class="field-wraper w-auto">
                            <div class="field_cover">
                                <?php echo $frm->getFieldHtml('collection_for_web'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <div class="col-md-4 d-none">
                <div class="field-set d-flex align-items-center">
                    <div class="field-wraper w-auto">
                        <div class="field_cover">
                            <?php echo $frm->getFieldHtml('collection_for_app'); ?>
                        </div>
                    </div>
                </div>
            </div>
            <?php
            $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
            if (!empty($translatorSubscriptionKey) && count($otherLangData) > 0) {
                ?>
                <div class="col-md-12">
                    <div class="field-set align-items-center">
                        <div class="field-wraper w-auto">
                            <div class="field_cover setting-block">
                                <?php echo $frm->getFieldHtml('auto_update_other_langs_data'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
        </div>

        <?php
        if (!empty($otherLangData)) {
            foreach ($otherLangData as $langId => $data) {
                ?>
                <div class="custom-accordion accordians_container accordians_container-categories"
                    defaultLang="<?php echo $siteDefaultLangId; ?>" language="<?php echo $langId; ?>"
                    id="accordion-language_<?php echo $langId; ?>" onClick="translateData(this)">
                    <div class="custom-accordion-block accordian_panel">
                        <button class="accordian-btn btn btn-secondary dropdown-toggle accordianhead"
                            id="collapse_<?php echo $langId; ?>">
                            <?php
                            echo $data . " ";
                            echo Labels::getLabel('LBL_Language_Data', $adminLangId);
                            ?>
                        </button>
                        <div class="custom-accordion-body accordian_body accordiancontent form-section " style="display: none;">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="field-set">
                                        <div class="caption-wraper">
                                            <label class="form-label">
                                                <?php
                                                $fld = $frm->getField('collection_name[' . $langId . ']');
                                                echo $fld->getCaption();
                                                ?>
                                            </label>
                                        </div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <?php echo $frm->getFieldHtml('collection_name[' . $langId . ']'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php if ($collection_type != Collections::COLLECTION_TYPE_SUB_COLLECTION && $collection_type != Collections::COLLECTION_TYPE_CMS) { ?>
                                    <div class="col-md-12">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                    $fld = $frm->getField('collection_description[' . $langId . ']');
                                                    echo $fld->getCaption();
                                                    ?>
                                                </label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $frm->getFieldHtml('collection_description[' . $langId . ']'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if (applicationConstants::getActiveTheme() == applicationConstants::THEME_FASHION && $collection_layout_type == Collections::TYPE_PRODUCT_LAYOUT5) { ?>
                                    <div class="col-md-12">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                    $fld = $frm->getField('collection_text[' . $langId . ']');
                                                    echo $fld->getCaption();
                                                    ?>
                                                    <span class="spn_must_field">*</span></label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $frm->getFieldHtml('collection_text[' . $langId . ']'); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </div>
                            <?php if ($collection_type == Collections::COLLECTION_TYPE_CMS) { ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                    $fld = $frm->getField('collection_desc_' . $langId);
                                                    echo $fld->getCaption();
                                                    ?>
                                                </label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $frm->getFieldHtml('collection_desc_' . $langId); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                            <?php if ($collection_type == Collections::COLLECTION_TYPE_CONTENT_BLOCK) { ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="field-set">
                                            <div class="caption-wraper">
                                                <label class="form-label">
                                                    <?php
                                                    $fld = $frm->getField('epage_content_' . $langId);
                                                    echo $fld->getCaption();
                                                    ?>
                                                </label>
                                            </div>
                                            <div class="field-wraper">
                                                <div class="field_cover">
                                                    <?php echo $frm->getFieldHtml('epage_content_' . $langId); ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
                <?php
            }
        }
        ?>

        <?php
        if ($collection_type == Collections::COLLECTION_TYPE_CMS) {
            echo $frm->getFieldHtml('blocation_promotion_cost');
        }
        echo $frm->getFieldHtml('collection_id');
        echo $frm->getFieldHtml('collection_active');
        echo $frm->getFieldHtml('collection_type');
        echo $frm->getFieldHtml('collection_layout_type');
        echo $frm->getFieldHtml('collection_parent_id');
        ?>
        </form>
        <?php echo $frm->getExternalJS(); ?>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        callCollectionTypePopulate
            (<?php echo $collection_type; ?>);
    });
</script>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>