<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frm->setFormTagAttribute('class', 'form web_form layout--' . $formLayout);
$frm->setFormTagAttribute('id', 'contentBlockFrm');
$frm->setFormTagAttribute('onsubmit', 'setupRecord(); return(false);');
$frm->setFormTagAttribute('dir', $formLayout);
$imgFld = $frm->getField('block_image');
$imgFld->addFieldTagAttribute('onChange', 'popupImageBlock(this)');
$imgFld->htmlBeforeField = '<span class="filename"></span>';
$imgFld->htmlAfterField = '<small class="text--small form-text text-muted">' . Labels::getLabel('LBL_Please_keep_image_dimensions_greater_than_' . $frm->getField('min_width')->value . '_x_' . $frm->getField('min_height')->value . '', $adminLangId) . '</small>';

$minHeight = $frm->getField('min_height')->value;
$minWidth = $frm->getField('min_width')->value;

$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
$formTitle = Labels::getLabel('LBL_Setup', $adminLangId);

if ($collection_layout_type != Collections::TYPE_PENDING_REVIEWS1) {

    $recordId = (int) $collection_id;

    $tabsButtons = [
        [
            'attr' => [
                'onclick' => 'collectionForm(' . $collection_type . ', ' . $collection_layout_type . ', ' . $recordId . ', 0)',
                'title' => Labels::getLabel('LBL_General', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_General', $adminLangId),
            'isActive' => false,
            'isPrimary' => true
        ]
    ];
    for ($recordIndex = 1; $recordIndex <= $recordLimit; $recordIndex++) {
        array_push($tabsButtons, [
            'attr' => [
                'onclick' => (0 < $recordId) ? 'addRecordForm(' . $recordId . ', ' . $collection_type . ', ' . $recordIndex . ')' : '',
                'title' => Labels::getLabel('LBL_Step_' . $recordIndex, $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Step_' . $recordIndex, $adminLangId),
            'isActive' => ($displayOrder == $recordIndex) ? true : false
        ]);
    }

    $mediaLayoutArr = Collections::LAYOUT_WITH_MEDIA ; 
    if($collection_layout_type == Collections::TYPE_BLOG_LAYOUT1 && applicationConstants::getActiveTheme() != applicationConstants::THEME_HEAVY_EQUIPMENT){
        $mediaLayoutArr = array_diff($mediaLayoutArr, [$collection_layout_type]);
    }
    if (in_array($collection_layout_type, $mediaLayoutArr)) {
        array_push($tabsButtons, [
            'attr' => [
                'onclick' => 'collectionMediaForm(' . $recordId . ')',
                'title' => Labels::getLabel('LBL_Media', $adminLangId),
            ],
            'label' => Labels::getLabel('LBL_Media', $adminLangId),
        ]);
    }
}
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
        <div class="row">
            <div class="col-sm-12">
                <div class="need-remove">

                    <div class="tabs_panel_wrap">
                        <div class="tabs_panel" id="tabs_form">
                            <?php echo $frm->getFormTag(); ?>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="field-set">
                                        <div class="caption-wraper">
                                            <label class="form-label">
                                                <?php
                                                $fld = $frm->getField('cbs_name[' . $siteDefaultLangId . ']');
                                                echo $fld->getCaption();
                                                ?>
                                                <span class="spn_must_field">*</span></label>
                                        </div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <?php echo $frm->getFieldHtml('cbs_name[' . $siteDefaultLangId . ']'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="field-set">
                                        <div class="caption-wraper">
                                            <label class="form-label">
                                                <?php
                                                $fld = $frm->getField('cbs_identifier');
                                                echo $fld->getCaption();
                                                ?>
                                                <span class="spn_must_field">*</span></label>
                                        </div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <?php echo $frm->getFieldHtml('cbs_identifier'); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php if ($collection_layout_type != Collections::TYPE_CONTENT_BLOCK_WITH_ICON_LAYOUT3) { ?>
                                                    <div class="col-md-12">
                                                        <div class="field-set pb-0">
                                                            <div class="caption-wraper">
                                                                <label class="form-label">
                                                                    <?php
                                                                    $fld = $frm->getField('block_image');
                                                                    echo $fld->getCaption();
                                                                    ?>
                                                                </label>
                                                            </div>
                                                            <div class="field-wraper">
                                                                <div class="field_cover">
                                                                    <?php echo $frm->getFieldHtml('block_image'); ?>
                                                                </div>
                                                            </div>
                                                            <div id="cropperBox-js "></div>
                                                            <div class="mt-2">
                                                            <?php
                                                            /* [ MEDIA INSTRUCTIONS START HERE */
                                                            $tpl = new FatTemplate('', '');
                                                            $tpl->set('adminLangId', $adminLangId);
                                                            echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
                                                            /* ] */
                                                            ?>
                                                            </div>
                                                            <div id="imageupload_div" class="padd15"></div>
                                                            <div id="cropper-dimensions" data-height="<?php echo $minHeight; ?>"
                                                                data-width="<?php echo $minWidth; ?>">
                                                            </div>
                                                        </div>


                                                    </div>
                                                    <div class="col-md-12">

                                                    </div>

                                <?php } ?>

                                <div class="col-md-12">
                                    <div class="field-set">
                                        <div class="caption-wraper">
                                            <label class="form-label">
                                                <?php
                                                $fld = $frm->getField('cbslang_description_' . $siteDefaultLangId);
                                                echo $fld->getCaption();
                                                ?>
                                            </label>
                                        </div>
                                        <div class="field-wraper">
                                            <div class="field_cover">
                                                <?php echo $frm->getFieldHtml('cbslang_description_' . $siteDefaultLangId); ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <?php if (!empty($otherLangData)) { ?>
                                                    <div class="col-md-12">
                                                        <?php foreach ($otherLangData as $langId => $data) { ?>
                                                                            <div class="custom-accordion accordians_container accordians_container-categories"
                                                                                defaultLang="<?php echo $siteDefaultLangId; ?>"
                                                                                language="<?php echo $langId; ?>" id="accordion-language_<?php echo $langId; ?>"
                                                                                onClick="translateData(this)">
                                                                                <div class="custom-accordion-block accordian_panel">
                                                                                    <button
                                                                                        class="accordian-btn btn btn-secondary dropdown-toggle accordianhead"
                                                                                        id="collapse_<?php echo $langId; ?>">
                                                                                        <?php
                                                                                        echo $data . " ";
                                                                                        echo Labels::getLabel('LBL_Language_Data', $adminLangId);
                                                                                        ?>
                                                                                    </button>
                                                                                    <div class="custom-accordion-body accordian_body accordiancontent form-section " style="display: none;">
                                                                                        <div class="row">
                                                                                            <div class="col-md-12">
                                                                                                <div class="field-set">
                                                                                                    <div class="caption-wraper">
                                                                                                        <label class="form-label">
                                                                                                            <?php
                                                                                                            $fld = $frm->getField('cbs_name[' . $langId . ']');
                                                                                                            echo $fld->getCaption();
                                                                                                            ?>
                                                                                                        </label>
                                                                                                    </div>
                                                                                                    <div class="field-wraper">
                                                                                                        <div class="field_cover">
                                                                                                            <?php echo $frm->getFieldHtml('cbs_name[' . $langId . ']'); ?>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-md-12">
                                                                                                <div class="field-set">
                                                                                                    <div class="caption-wraper">
                                                                                                        <label class="form-label">
                                                                                                            <?php
                                                                                                            $fld = $frm->getField('cbslang_description_' . $langId);
                                                                                                            echo $fld->getCaption();
                                                                                                            ?>
                                                                                                        </label>
                                                                                                    </div>
                                                                                                    <div class="field-wraper">
                                                                                                        <div class="field_cover">
                                                                                                            <?php echo $frm->getFieldHtml('cbslang_description_' . $langId); ?>
                                                                                                        </div>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>

                                                                                        </div>

                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                <?php } ?>
                            

                                <?php
                                echo $frm->getFieldHtml('min_width');
                                echo $frm->getFieldHtml('min_height');
                                echo $frm->getFieldHtml('cbs_id');
                                echo $frm->getFieldHtml('collection_id');
                                echo $frm->getFieldHtml('collection_type');
                                echo $frm->getFieldHtml('cbs_display_order');
                                ?>
                                </form>
                                <?php echo $frm->getExternalJS(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

<script type="text/javascript">
    $(document).ready(function () {

    });
</script>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>