<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
?>
<div class="form-section">
	<legend class="form-section-head">
		<?php echo Labels::getLabel('LBL_Checklist_Fields', $adminLangId); ?>
	</legend>
	<div class="row">
		<div class="col-md-12">
			<div class="tablewrap">
				<table class="table table--hovered" width="100%">
					<thead>
						<tr>
							<th width="25%"><?php echo Labels::getLabel('LBL_Field_Name', $adminLangId); ?></th>
							<th width="30%"><?php echo Labels::getLabel('LBL_Field_Type', $adminLangId); ?></th>
							<th width="30%"><?php echo Labels::getLabel('LBL_Status', $adminLangId); ?></th>
							<th width="20%"></th>
						</tr>
					</thead>
					<tbody>
						<?php foreach ($checklistPointFldData as $checklistId => $data) { ?>
							<tr>
								<td><?php echo $data['cp_name']; ?></td>
								<td><?php echo (!empty($checklistTypes[$data['cp_type']])) ? $checklistTypes[$data['cp_type']] : 'N/A'; ?>
								</td>
								<td>
									<label class="switch switch-sm switch-icon">
										<input <?php echo ($data['cp_active'] == ChecklistPoint::ACTIVE) ? 'checked' : ''; ?>
											type="checkbox" id="switch2" class="switch-labels"
											onclick="changeChecklistStatus(<?php echo $checklistId; ?>, <?php echo ($data['cp_active'] == ChecklistPoint::INACTIVE) ? ChecklistPoint::ACTIVE : ChecklistPoint::INACTIVE; ?>)">
									</label>
								</td>
								<td class="text-right">
									<a href="javascript:void(0)" class="btn btn-sm btn-clean btn-icon btn-icon-md"
										title="Edit" onclick="editChecklist(<?php echo $checklistId; ?>)"><svg class="svg" width="18" height="18"><use xlink:href="<?php echo CONF_WEBROOT_FRONT_URL; ?>images/admin/retina/sprite-actions.svg#edit"></use></svg></a>
								</td>
							</tr>
						<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>