<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$prodBrandLangFrm->setFormTagAttribute('id', 'prodBrand');
$prodBrandLangFrm->setFormTagAttribute('class', 'form web_form form_horizontal layout--' . $formLayout);
$prodBrandLangFrm->setFormTagAttribute('onsubmit', 'setupBrandLang(this); return(false);');
$prodBrandLangFrm->developerTags['colClassPrefix'] = 'col-md-';
$prodBrandLangFrm->developerTags['fld_default_col'] = 12;
$prodBrandLangFrm->setFormTagAttribute('dir', $formLayout);
$langFld = $prodBrandLangFrm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "brandRequestLangForm(" . $brand_id . ", this.value);");


$recordId = (int) $brand_id;

$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'brandRequestForm('.$brand_id.');',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'brandRequestLangForm("'.$recordId.'","'.FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1).'")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'brandRequestMediaForm("'.$recordId.'")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => false
    ],
];


$formTitle = Labels::getLabel('LBL_Product_Brand_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');

$translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
$siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
if (!empty($translatorSubscriptionKey) && $brand_lang_id != $siteDefaultLangId) { ?>
    <div class="row justify-content-end">
        <div class="col-auto mb-4">
            <input class="btn btn-brand" type="button"
                value="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $adminLangId); ?>"
                onClick="brandRequestLangForm(<?php echo $brand_id; ?>, <?php echo $brand_lang_id; ?>, 1)">
        </div>
    </div>
<?php } ?>
<?php echo $prodBrandLangFrm->getFormHtml(); ?>
<?php 
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>