<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$prodBrandFrm->setFormTagAttribute('id', 'prodBrand');
$prodBrandFrm->setFormTagAttribute('class', 'form web_form form_horizontal');
$prodBrandFrm->developerTags['colClassPrefix'] = 'col-md-';
$prodBrandFrm->developerTags['fld_default_col'] = 12;
$prodBrandFrm->setFormTagAttribute('onsubmit', 'setupBrand(this); return(false);');
$urlFld = $prodBrandFrm->getField('urlrewrite_custom');
$urlFld->setFieldTagAttribute('id', "urlrewrite_custom");
$urlFld->htmlAfterField = "<small class='text--small form-text text-muted'>" . UrlHelper::generateFullUrl('Brands', 'View', array($brand_id), CONF_WEBROOT_FRONT_URL) . '</small>';
$urlFld->setFieldTagAttribute('onkeyup', "getSlugUrl(this,this.value)");
$fld = $prodBrandFrm->getField('brand_status');
$fld->setFieldTagAttribute('onChange', 'showHideCommentBox(this.value)');

$fldBl = $prodBrandFrm->getField('brand_comments');
$fldBl->htmlBeforeField = '<span id="div_comments_box" class="hide">Reason for Cancellation';
$fldBl->htmlAfterField = '</span>';


$recordId = (int) $brand_id;

$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'brandRequestForm('.$brand_id.');',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => true,
        'isPrimary'=> true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'brandRequestLangForm("'.$recordId.'","'.FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1).'")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'brandRequestMediaForm("'.$recordId.'")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => false
    ],
];

$formTitle = Labels::getLabel('LBL_Product_Brand_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>       
<?php echo $prodBrandFrm->getFormHtml(); ?>
<script>
    getSlugUrl($("#urlrewrite_custom"), $("#urlrewrite_custom").val())
</script>
<?php 
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>