<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$brandLogoFrm->setFormTagAttribute('class', 'form web_form  form_horizontal');
$brandLogoFrm->developerTags['colClassPrefix'] = 'col-md-';
$brandLogoFrm->developerTags['fld_default_col'] = 12;
$ratioFld = $brandLogoFrm->getField('ratio_type');
$ratioFld->addFieldTagAttribute('class', 'prefRatio-js');
$ratioFld->addOptionListTagAttribute('class', 'list-radio');
$logoFld = $brandLogoFrm->getField('logo');
$logoFld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$logoFld->addFieldTagAttribute('onChange', 'logoPopupImage(this)');
$logoLangFld = $brandLogoFrm->getField('lang_id');
$logoLangFld->addFieldTagAttribute('class', 'logo-language-js');
$logoPreferredDimensions = '<small class="text--small form-text text-muted logoPreferredDimensions-js">' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) .' 500 x 500' . '</small>';
$htmlAfterField = $logoPreferredDimensions;
// $htmlAfterField .= '<div id="logo-listing"></div>';
$logoFld->htmlAfterField = $htmlAfterField;

$brandImageFrm->setFormTagAttribute('class', 'form web_form  form_horizontal');
$brandImageFrm->developerTags['colClassPrefix'] = 'col-md-';
$brandImageFrm->developerTags['fld_default_col'] = 12;
$imageFld = $brandImageFrm->getField('image');
$imageFld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$imageFld->addFieldTagAttribute('onChange', 'bannerPopupImage(this)');
$imageLangFld = $brandImageFrm->getField('lang_id');
$imageLangFld->addFieldTagAttribute('class', 'image-language-js');
$screenFld = $brandImageFrm->getField('slide_screen');
$screenFld->addFieldTagAttribute('class', 'prefDimensions-js');

$htmlAfterField = '<div class="preferredDimensions-js form-text text-muted">' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId). ' 2000 x 500' . '</div>';

// $htmlAfterField .= '<div id="image-listing"></div>';
$imageFld->htmlAfterField = $htmlAfterField;


$recordId = (int) $brand_id;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'brandForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'brandLangForm("' . $recordId . '","' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . '")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'brandMediaForm("' . $recordId . '")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => true
    ],
];
$formTitle = Labels::getLabel('LBL_Product_Brand_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>

<div class="col-sm-12">
    <?php
    /* [ MEDIA INSTRUCTIONS START HERE */
    $tpl = new FatTemplate('', '');
    $tpl->set('adminLangId', $adminLangId);
    echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
    /* ] */
    ?>
</div>
<section class="form-section">
    <?php echo $brandLogoFrm->getFormHtml(); ?>
</section>
<section class="form-section">
    <?php echo $brandImageFrm->getFormHtml(); ?>
</section>
<script>
    $('input[name=banner_min_width]').val(2000);
    $('input[name=banner_min_height]').val(500);
    $('input[name=logo_min_width]').val(150);
    $('input[name=logo_min_height]').val(150);
    var ratioTypeSquare = <?php echo AttachedFile::RATIO_TYPE_SQUARE; ?>;
    var ratioTypeRectangular = <?php echo AttachedFile::RATIO_TYPE_RECTANGULAR; ?>;
    var aspectRatio = 4 / 1;

    $(document).on('change', '.prefDimensions-js', function () {
        var screenDesktop = <?php echo applicationConstants::SCREEN_DESKTOP ?>;
        var screenIpad = <?php echo applicationConstants::SCREEN_IPAD ?>;

        if ($(this).val() == screenDesktop) {
            $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 2000 x 500');
            $('input[name=banner_min_width]').val(2000);
            $('input[name=banner_min_height]').val(500);
            aspectRatio = 4 / 1;
        } else if ($(this).val() == screenIpad) {
            $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 1024 x 360');
            $('input[name=banner_min_width]').val(1024);
            $('input[name=banner_min_height]').val(360);
            aspectRatio = 128 / 45;
        } else {
            $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 640 x 360');
            $('input[name=banner_min_width]').val(640);
            $('input[name=banner_min_height]').val(360);
            aspectRatio = 16 / 9;
        }
    });

    $(document).on('change', '.prefRatio-js', function () {
        if ($(this).val() == ratioTypeSquare) {
            $('input[name=logo_min_width]').val(500);
            $('input[name=logo_min_height]').val(500);
            $('.logoPreferredDimensions-js').html(langLbl.preferredDimensions + ' 500 x 500');
        } else {
            $('input[name=logo_min_width]').val(500);
            $('input[name=logo_min_height]').val(280);
            $('.logoPreferredDimensions-js').html(langLbl.preferredDimensions + ' 500 x 280');
        }
    });
</script>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>